/*
 * Decompiled with CFR 0.152.
 */
package lc.common.crypto;

import java.security.KeyStoreException;
import java.security.PublicKey;
import java.util.HashMap;
import java.util.Map;

public class KeyTrustRegistry {
    private final HashMap<String, PublicKey> keyMap = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void placeKey(String label, PublicKey pk) throws KeyStoreException {
        HashMap<String, PublicKey> hashMap = this.keyMap;
        synchronized (hashMap) {
            if (this.keyMap.containsKey(label)) {
                throw new KeyStoreException("Entry with label already exists");
            }
            if (this.keyMap.containsValue(pk)) {
                throw new KeyStoreException("Public key already in key map");
            }
            this.keyMap.put(label, pk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forget(String label) {
        HashMap<String, PublicKey> hashMap = this.keyMap;
        synchronized (hashMap) {
            this.keyMap.remove(label);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forget(PublicKey pk) {
        HashMap<String, PublicKey> hashMap = this.keyMap;
        synchronized (hashMap) {
            String key = this.label(pk);
            if (key != null) {
                this.keyMap.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String label(PublicKey pk) {
        HashMap<String, PublicKey> hashMap = this.keyMap;
        synchronized (hashMap) {
            String key = null;
            for (Map.Entry<String, PublicKey> pair : this.keyMap.entrySet()) {
                if (!pair.getValue().equals(pk)) continue;
                key = pair.getKey();
            }
            return key;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean checkTrust(PublicKey pk) {
        HashMap<String, PublicKey> hashMap = this.keyMap;
        synchronized (hashMap) {
            for (Map.Entry<String, PublicKey> pair : this.keyMap.entrySet()) {
                if (!pair.getValue().equals(pk)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void purge() {
        HashMap<String, PublicKey> hashMap = this.keyMap;
        synchronized (hashMap) {
            this.keyMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final PublicKey[] contents() {
        HashMap<String, PublicKey> hashMap = this.keyMap;
        synchronized (hashMap) {
            return this.keyMap.values().toArray(new PublicKey[0]);
        }
    }
}

