/*
 * Decompiled with CFR 0.152.
 */
package lc.common.configuration.store;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import lc.common.configuration.model.IConfigObject;
import lc.common.configuration.model.IConfigObjectList;
import lc.common.configuration.store.datamodel.IXMLDataModel;
import lc.common.configuration.xml.DOMHelper;
import lc.common.configuration.xml.XMLParserException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ConfigObjectXMLParser {
    private final DocumentBuilderFactory factory;
    private final String rootTag;
    private final IXMLDataModel model;

    public ConfigObjectXMLParser(IXMLDataModel model, String rootTag) {
        this.model = model;
        this.rootTag = rootTag;
        this.factory = DocumentBuilderFactory.newInstance();
        this.factory.setIgnoringComments(false);
    }

    public IConfigObject read(InputStream chunk) throws XMLParserException {
        try {
            IConfigObject rootNode;
            DocumentBuilder builder = this.factory.newDocumentBuilder();
            Document doc = builder.parse(chunk);
            NodeList root = doc.getChildNodes();
            Node confRoot = DOMHelper.findNode(root, this.rootTag, false);
            if (confRoot == null) {
                throw new XMLParserException("Missing root tag");
            }
            if (confRoot.hasChildNodes()) {
                rootNode = (IConfigObject)((Object)this.model.createRootList(this, confRoot));
                this.populateChildNodes((IConfigObjectList)((Object)rootNode), confRoot);
            } else {
                rootNode = this.model.createRootNode(this, confRoot);
            }
            this.model.applyRootAttributes(this, rootNode, confRoot);
            return rootNode;
        }
        catch (IOException e) {
            throw new XMLParserException("Can't parse; IOException occured.", e);
        }
        catch (ParserConfigurationException e) {
            throw new XMLParserException("Can't parse; configuration exception.", e);
        }
        catch (SAXException e) {
            throw new XMLParserException("Can't parse; document syntax exception.", e);
        }
    }

    public void populateChildNodes(IConfigObjectList rootList, Node confRoot) throws XMLParserException {
        NodeList children = confRoot.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element)) continue;
            IConfigObject cld = this.model.readNode(this, rootList, (Element)child);
            this.model.applyAttributes(this, cld, (Element)child);
            if (cld == null) continue;
            rootList.addChild(cld);
        }
    }
}

