/*
 * Decompiled with CFR 0.152.
 */
package lc.common.configuration.model;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import lc.common.configuration.model.IConfigObject;
import lc.common.configuration.model.IConfigObjectVisitor;

public class ModelConfigNode
implements IConfigObject {
    private String name;
    private String comment;
    private HashMap<String, Object> parameters;
    private WeakReference<ModelConfigNode> parent;
    private boolean modified;

    public ModelConfigNode() {
        this(null, null, null);
    }

    public ModelConfigNode(String name) {
        this(name, null, null);
    }

    public ModelConfigNode(String name, ModelConfigNode parent) {
        this(name, null, parent);
    }

    public ModelConfigNode(String name, String comment) {
        this(name, comment, null);
    }

    public ModelConfigNode(String name, String comment, ModelConfigNode parent) {
        this.name = name;
        this.comment = comment;
        this.parent = new WeakReference<ModelConfigNode>(parent);
        this.parameters = new HashMap();
    }

    @Override
    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String comment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public HashMap<String, Object> parameters() {
        return this.parameters;
    }

    public void setParameters(HashMap<String, Object> parameters) {
        this.parameters = parameters;
    }

    @Override
    public IConfigObject getParent() {
        return (IConfigObject)this.parent.get();
    }

    public void modify() {
        this.modified = true;
        if (this.parent != null && this.parent.get() != null) {
            ((ModelConfigNode)this.parent.get()).modify();
        }
    }

    public boolean modified() {
        return this.modified;
    }

    @Override
    public void visit(IConfigObjectVisitor visitor) {
        visitor.visitNode(this);
        visitor.finishVisitNode(this);
    }
}

