/*
 * Decompiled with CFR 0.152.
 */
package lc.common.configuration;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import lc.api.components.ComponentType;
import lc.common.LCLog;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.configuration.xml.ComponentConfigList;
import lc.common.configuration.xml.ConfigHelper;
import lc.common.configuration.xml.XMLParser;
import lc.common.configuration.xml.XMLParserException;
import lc.common.configuration.xml.XMLSaver;
import lc.common.configuration.xml.XMLSaverException;
import lc.common.util.Tracer;
import lc.common.util.java.DeferredTaskExecutor;

public class ConfigurationController {
    private File workdir;
    private File defaultConfigFile;
    private ComponentConfigList defaultConfig;
    private Runnable writer = new Runnable(){

        @Override
        public void run() {
            ConfigurationController.this.commit();
        }
    };

    public ConfigurationController() {
        DeferredTaskExecutor.scheduleWithFixedDelay(this.writer, 240L, 300L, TimeUnit.SECONDS);
    }

    public void initialize(File wd) {
        Tracer.begin(this);
        this.workdir = new File(wd, "LanteaCraft");
        if (!this.workdir.exists()) {
            this.workdir.mkdir();
        }
        try {
            this.defaultConfigFile = new File(this.workdir, "config.xml");
            if (this.defaultConfigFile.exists()) {
                XMLParser parser = new XMLParser();
                FileInputStream test = new FileInputStream(this.defaultConfigFile);
                this.defaultConfig = parser.read(test);
                LCLog.debug("Loaded default configuration from disk.");
            } else {
                this.defaultConfig = new ComponentConfigList();
                LCLog.debug("No configuration on disk. Writing a new one.");
            }
        }
        catch (XMLParserException pex) {
            throw new RuntimeException("Error configuring LanteaCraft.", pex);
        }
        catch (IOException ioex) {
            throw new RuntimeException("Error configuring LanteaCraft setting storage.", ioex);
        }
        finally {
            Tracer.end();
        }
    }

    public void commit() {
        if (this.defaultConfig.modified()) {
            try {
                Tracer.begin(this);
                LCLog.debug("Default configuration modified. Saving it...");
                XMLSaver saver = new XMLSaver();
                saver.save(this.defaultConfig, new FileOutputStream(this.defaultConfigFile));
                LCLog.debug("Default configuration committed.");
            }
            catch (XMLSaverException sex) {
                throw new RuntimeException("Error saving LanteaCraft configuration state.", sex);
            }
            catch (IOException ioex) {
                throw new RuntimeException("Error saving to LanteaCraft setting storage.", ioex);
            }
            finally {
                Tracer.end();
            }
        }
    }

    public ComponentConfig config(ComponentType type) {
        return ConfigHelper.findComponentContainer(this.defaultConfig, type.name());
    }

    public File getObject(String name) {
        return new File(this.workdir, name);
    }
}

