/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.ux;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import lc.common.base.ux.LCContainerGUI;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.RenderHelper;
import org.apache.commons.lang3.text.WordUtils;
import org.lwjgl.opengl.GL11;

public class Popover {
    private String message;
    private int age;
    private int expiry;

    public Popover(String message, int expiry) {
        this.message = message;
        this.expiry = expiry;
    }

    public int render(Minecraft mc, LCContainerGUI gui, int x, int y, int width, float zLevel) {
        float remain = 1.0f;
        if ((float)this.age > 0.5f * (float)this.expiry) {
            remain = Math.max(0.001f, (float)(this.expiry - this.age) / (0.5f * (float)(this.expiry + 1)));
        }
        return Popover.drawPopover(mc, gui, this.message, x, y, remain, width, zLevel);
    }

    public void tick() {
        ++this.age;
    }

    public boolean dead() {
        return this.age > this.expiry;
    }

    public static int drawPopover(Minecraft mc, LCContainerGUI gui, String text, int x, int y, float remain, int width, float zLevel) {
        GL11.glDisable((int)32826);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)2896);
        int boxWidth = 0;
        FontRenderer font = mc.field_71466_p;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)remain);
        ArrayList lines = Lists.newArrayList((Object[])WordUtils.wrap((String)text, (int)width).split("\n"));
        for (String s : lines) {
            int l = font.func_78256_a(s);
            if (l <= boxWidth) continue;
            boxWidth = l;
        }
        int x0 = x - boxWidth / 2;
        int y0 = y;
        int height = 8;
        if (lines.size() > 1) {
            height += 2 + (lines.size() - 1) * 10;
        }
        int j1 = 0x100010 | (int)Math.ceil(remain * 240.0f) << 24;
        gui.drawGradientRectUV(x0 - 3, y0 - 4, x0 + boxWidth + 3, y0 - 3, j1, j1);
        gui.drawGradientRectUV(x0 - 3, y0 + height + 3, x0 + boxWidth + 3, y0 + height + 4, j1, j1);
        gui.drawGradientRectUV(x0 - 3, y0 - 3, x0 + boxWidth + 3, y0 + height + 3, j1, j1);
        gui.drawGradientRectUV(x0 - 4, y0 - 3, x0 - 3, y0 + height + 3, j1, j1);
        gui.drawGradientRectUV(x0 + boxWidth + 3, y0 - 3, x0 + boxWidth + 4, y0 + height + 3, j1, j1);
        int k1 = 0x5000FF | (int)Math.ceil(remain * 80.0f) << 24;
        int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
        gui.drawGradientRectUV(x0 - 3, y0 - 3 + 1, x0 - 3 + 1, y0 + height + 3 - 1, k1, l1);
        gui.drawGradientRectUV(x0 + boxWidth + 2, y0 - 3 + 1, x0 + boxWidth + 3, y0 + height + 3 - 1, k1, l1);
        gui.drawGradientRectUV(x0 - 3, y0 - 3, x0 + boxWidth + 3, y0 - 3 + 1, k1, k1);
        gui.drawGradientRectUV(x0 - 3, y0 + height + 2, x0 + boxWidth + 3, y0 + height + 3, l1, l1);
        for (int i2 = 0; i2 < lines.size(); ++i2) {
            String s1 = (String)lines.get(i2);
            int col = 0xFFFFFF | (int)(remain * 80.0f) << 24;
            font.func_78261_a(s1, x0, y0, col);
            if (i2 == 0) {
                y0 += 2;
            }
            y0 += 10;
        }
        GL11.glEnable((int)2896);
        RenderHelper.func_74519_b();
        GL11.glEnable((int)32826);
        return height + 8;
    }
}

