/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.ux;

import com.google.common.collect.Lists;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import lc.api.stargate.StargateType;
import lc.client.opengl.BufferTexture;
import lc.common.LCLog;
import lc.common.base.ux.LCContainerTab;
import lc.common.base.ux.Popover;
import lc.common.base.ux.StargateGlyphRenderer;
import lc.common.resource.ResourceAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public abstract class LCContainerGUI
extends GuiContainer {
    private static final int defaultTextColor = 0x404040;
    private LCContainerTab activeTab;
    private ArrayList<Popover> popovers;
    private TileEntity tile;
    private BufferTexture tabVboBuffer;
    double uscale;
    double vscale;
    float red = 1.0f;
    float green = 1.0f;
    float blue = 1.0f;
    int textColor = 0x404040;
    boolean textShadow = false;
    boolean mouseDown = false;

    public LCContainerGUI(TileEntity tile, Container container) {
        super(container);
        this.tile = tile;
        this.tabVboBuffer = new BufferTexture(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        this.popovers = new ArrayList();
        this.tabVboBuffer.init();
    }

    protected abstract HashMap<Integer, LCContainerTab> getTabs();

    public void switchTab(int to) {
        LCContainerTab nextTab = this.getTabs().get(to);
        if (nextTab == this.activeTab) {
            return;
        }
        if (nextTab == null) {
            nextTab = this.getTabs().get(0);
        }
        if (this.activeTab != null) {
            this.activeTab.onTabClosed(this);
        }
        this.activeTab = nextTab;
        this.mouseDown = false;
        this.rebuildLayout();
        this.activeTab.onTabOpened(this);
    }

    public void rebuildLayout() {
        Dimension size = this.activeTab.getTabDimensions();
        if (size == null) {
            size = new Dimension(800, 600);
            LCLog.warn("Problem rendering tab %s: no tab size!", this.activeTab);
        }
        this.field_146999_f = size.width;
        this.field_147000_g = size.height;
        this.field_147003_i = (this.field_146294_l - this.field_146999_f) / 2;
        this.field_147009_r = (this.field_146295_m - this.field_147000_g) / 2;
    }

    public int getXSize() {
        return this.field_146999_f;
    }

    public int getYSize() {
        return this.field_147000_g;
    }

    public int offsetLeft() {
        return this.field_147003_i;
    }

    public int offsetTop() {
        return this.field_147009_r;
    }

    public void func_146280_a(Minecraft mc, int w, int h) {
        super.func_146280_a(mc, w, h);
        this.rebuildLayout();
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.activeTab != null) {
            this.activeTab.update(this);
        }
        Iterator<Popover> i = this.popovers.iterator();
        while (i.hasNext()) {
            Popover what = i.next();
            what.tick();
            if (!what.dead()) continue;
            i.remove();
        }
    }

    protected void func_146976_a(float partialTickCount, int mouseX, int mouseY) {
        GL11.glEnable((int)3042);
        if (this.activeTab != null) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)this.field_147003_i, (float)this.field_147009_r, (float)0.0f);
            this.activeTab.drawBackgroundLayer(this, partialTickCount, mouseX, mouseY);
            GL11.glPopMatrix();
        }
        GL11.glPushMatrix();
        float stop = this.field_147003_i + this.field_146999_f;
        boolean tips = (float)mouseX > stop && (float)mouseX < stop + 16.0f;
        GL11.glTranslatef((float)stop, (float)this.field_147009_r, (float)0.0f);
        GL11.glDisable((int)2896);
        for (int i = 0; i < this.getTabs().size(); ++i) {
            int y = i * 16;
            LCContainerTab tab = this.getTabs().get(i);
            ResourceLocation ico = tab.getTabIcon();
            if (ico != null) {
                if (tab == this.activeTab) {
                    this.bindTexture(ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/gui/components/button_down_${TEX_QUALITY}.png", new Object[0])));
                } else {
                    this.bindTexture(ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/gui/components/button_up_${TEX_QUALITY}.png", new Object[0])));
                }
                this.drawTexturedRect(0.0, y, 16.0, 16.0);
                this.bindTexture(ico);
                this.drawTexturedRect(2.0, y + 2, 12.0, 12.0);
                if (!tips || mouseY <= y + this.field_147009_r || mouseY >= y + this.field_147009_r + 16) continue;
                this.drawTooltip(tab.getTabName(), (int)((float)mouseX - stop - 2.0f), mouseY - this.field_147009_r);
                continue;
            }
            LCLog.warn("Problem rendering tab %s: tab icon null!", tab.getClass().getName());
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        Iterator<Popover> popovers = this.popovers.iterator();
        int qx = 16;
        while (popovers.hasNext()) {
            Popover over = popovers.next();
            qx += over.render(Minecraft.func_71410_x(), this, this.field_146294_l / 2, this.field_146295_m - qx, 80, 300.0f);
        }
        GL11.glPopMatrix();
        GL11.glDisable((int)3042);
    }

    public void drawTooltip(String what, int x, int y) {
        ArrayList l0 = Lists.newArrayList((Object[])new String[]{what});
        this.drawHoveringText(l0, x, y, this.field_146289_q);
        RenderHelper.func_74518_a();
        GL11.glEnable((int)3042);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        GL11.glEnable((int)3042);
        if (this.activeTab != null) {
            this.activeTab.drawForegroundLayer(this, mouseX, mouseY);
        }
        GL11.glDisable((int)3042);
    }

    protected void func_73869_a(char c, int key) {
        if (this.activeTab != null) {
            this.activeTab.keyTyped(this, c, key);
        }
        if (key == 1) {
            this.close();
        }
    }

    protected void func_73864_a(int x, int y, int mouseButton) {
        int where;
        int which;
        super.func_73864_a(x, y, mouseButton);
        if (mouseButton == 0) {
            this.mouseDown = true;
        }
        if (this.activeTab != null) {
            this.activeTab.mouseClicked(this, x, y, mouseButton);
        }
        if (x > this.field_147003_i + this.field_146999_f && x < this.field_147003_i + this.field_146999_f + 16 && (which = (int)Math.floor((where = y - this.field_147009_r) / 16)) >= 0 && which < this.getTabs().size()) {
            this.switchTab(which);
        }
    }

    protected void func_146286_b(int x, int y, int mouseButton) {
        super.func_146286_b(x, y, mouseButton);
        if (this.activeTab != null) {
            this.activeTab.mouseMovedOrUp(this, x, y, mouseButton);
        }
        if (mouseButton == 0 || mouseButton == 1) {
            this.mouseDown = false;
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.resetColor();
        this.textColor = 0x404040;
        this.textShadow = false;
        super.func_73863_a(par1, par2, par3);
    }

    protected void close() {
        if (this.activeTab != null) {
            this.activeTab.onTabClosed(this);
        }
        this.tabVboBuffer.delete();
        this.field_146297_k.field_71439_g.func_71053_j();
    }

    public void drawFramedSymbols(int x, int y, StargateType type, char[] address) {
        int scale = 2;
        ResourceLocation tex = null;
        tex = type.getSuffix().length() != 0 ? ResourceAccess.getNamedResource("textures/gui/symbols/symbol_frame_" + type.getSuffix() + ".png") : ResourceAccess.getNamedResource("textures/gui/symbols/symbol_frame.png");
        this.bindTexture(tex, 512 / scale, 128 / scale);
        this.drawTexturedRect(x - 472 / scale / 2, y, 472 / scale, 88 / scale, 0.0, 0.0);
        StargateGlyphRenderer.drawAddress(this.field_146297_k, type, address, x - 472 / scale / 2, y, 8, scale, this.field_73735_i);
    }

    public void drawAddressString(int x, int y, String address, int len, String padding, String caret) {
        StringBuilder result = new StringBuilder();
        result.append(address);
        if (len != result.length() && caret != null) {
            result.append(caret);
        }
        while (len > result.length()) {
            result.append(padding);
        }
        this.func_73732_a(this.field_146289_q, result.toString(), x, y, 0xFFFFFF);
    }

    public void bindTexture(ResourceLocation rsrc) {
        this.bindTexture(rsrc, 1, 1);
    }

    public void bindTexture(ResourceLocation rsrc, int usize, int vsize) {
        this.field_146297_k.func_110434_K().func_110577_a(rsrc);
        this.uscale = 1.0 / (double)usize;
        this.vscale = 1.0 / (double)vsize;
    }

    public void drawTexturedRect(double x, double y, double w, double h) {
        this.drawTexturedRectUV(x, y, w, h, 0.0, 0.0, 1.0, 1.0);
    }

    public void drawTexturedRect(double x, double y, double w, double h, double u, double v) {
        this.drawTexturedRect(x, y, w, h, u, v, w, h);
    }

    public void drawTexturedRect(double x, double y, double w, double h, double u, double v, double us, double vs) {
        this.drawTexturedRectUV(x, y, w, h, u * this.uscale, v * this.vscale, us * this.uscale, vs * this.vscale);
    }

    public void drawTexturedRectUV(double x, double y, double w, double h, double u, double v, double us, double vs) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78386_a(this.red, this.green, this.blue);
        tess.func_78374_a(x, y + h, (double)this.field_73735_i, u, v + vs);
        tess.func_78374_a(x + w, y + h, (double)this.field_73735_i, u + us, v + vs);
        tess.func_78374_a(x + w, y, (double)this.field_73735_i, u + us, v);
        tess.func_78374_a(x, y, (double)this.field_73735_i, u, v);
        tess.func_78381_a();
    }

    public void drawGradientRectUV(int x, int y, int x1, int y1, int c0, int c1) {
        float f = (float)(c0 >> 24 & 0xFF) / 255.0f;
        float f1 = (float)(c0 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(c0 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(c0 & 0xFF) / 255.0f;
        float f4 = (float)(c1 >> 24 & 0xFF) / 255.0f;
        float f5 = (float)(c1 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(c1 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(c1 & 0xFF) / 255.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)3008);
        OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
        GL11.glShadeModel((int)7425);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78369_a(f1, f2, f3, f);
        tessellator.func_78377_a((double)x1, (double)y, (double)this.field_73735_i);
        tessellator.func_78377_a((double)x, (double)y, (double)this.field_73735_i);
        tessellator.func_78369_a(f5, f6, f7, f4);
        tessellator.func_78377_a((double)x, (double)y1, (double)this.field_73735_i);
        tessellator.func_78377_a((double)x1, (double)y1, (double)this.field_73735_i);
        tessellator.func_78381_a();
        GL11.glShadeModel((int)7424);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)3553);
    }

    public void setColor(int hex) {
        this.setColor((double)(hex >> 16) / 255.0, (double)(hex >> 8 & 0xFF) / 255.0, (double)(hex & 0xFF) / 255.0);
    }

    public void setColor(double r, double g, double b) {
        this.red = (float)r;
        this.green = (float)g;
        this.blue = (float)b;
    }

    public void resetTextColor() {
        this.textColor = 0x404040;
    }

    public void setTextColor(double r, double g, double b) {
        this.setTextColor(Math.max(0.0, r) * 255.0, Math.max(0.0, g) * 255.0, Math.max(0.0, b) * 255.0);
    }

    public void setTextColor(int r, int g, int b) {
        this.setTextColor((r << 16 | g << 8 | b) & 0xFFFFFF);
    }

    public void setTextColor(int rgb) {
        this.textColor = rgb & 0xFFFFFF;
    }

    public void resetColor() {
        this.setColor(1.0, 1.0, 1.0);
    }

    public void drawString(String s, int x, int y) {
        this.field_146289_q.func_85187_a(s, x, y, this.textColor, this.textShadow);
    }

    public void drawCenteredString(String s, int x, int y) {
        this.field_146289_q.func_85187_a(s, x - this.field_146289_q.func_78256_a(s) / 2, y, this.textColor, this.textShadow);
    }

    public void drawInventoryName(IInventory inv, int x, int y) {
        this.drawString(LCContainerGUI.inventoryName(inv), x, y);
    }

    public void drawPlayerInventoryName() {
        this.drawString(LCContainerGUI.playerInventoryName(), 8, this.field_147000_g - 96 + 2);
    }

    public static String inventoryName(IInventory inv) {
        return StatCollector.func_74838_a((String)inv.func_145825_b());
    }

    public static String playerInventoryName() {
        return StatCollector.func_74838_a((String)"container.inventory");
    }

    public boolean isMouseDown() {
        return this.mouseDown;
    }

    public boolean putTextOnClipboard(String what) {
        try {
            Clipboard destination = Toolkit.getDefaultToolkit().getSystemClipboard();
            destination.setContents(new StringSelection(what), null);
            return true;
        }
        catch (Throwable t) {
            LCLog.warn("Can't write to clipboard.", t);
            return false;
        }
    }

    public String getTextFromClipboard() {
        try {
            Clipboard source = Toolkit.getDefaultToolkit().getSystemClipboard();
            return (String)source.getData(DataFlavor.stringFlavor);
        }
        catch (Throwable t) {
            LCLog.warn("Can't read from clipboard.", t);
            return null;
        }
    }

    public void pushPopover(Popover over) {
        this.popovers.add(over);
    }

    public TileEntity getTile() {
        return this.tile;
    }

    public void setTile(TileEntity tile) {
        this.tile = tile;
    }
}

