/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.ux;

import lc.common.resource.ResourceAccess;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;

public class IconButton {
    public static void drawButton(Minecraft mc, String iconName, int x, int y, int mx, int my, boolean down, double scale, float zLevel) {
        boolean inBounds = IconButton.buttonHovered(x, y, mx, my, scale);
        IconButton.bindAndClamp(mc, "components/button_" + (down && inBounds ? "down" : (inBounds ? "hover" : "up")));
        IconButton.drawTexturedRectUV(x, y, 24.0 * scale, 24.0 * scale, 0.0, 0.0, 1.0, 1.0, zLevel);
        IconButton.drawIcon(mc, iconName, x, y, scale, zLevel);
    }

    public static void drawIcon(Minecraft mc, String icon, int x, int y, double scale, float z) {
        IconButton.bindAndClamp(mc, "icons/" + icon);
        IconButton.drawTexturedRectUV((double)x + 4.0 * scale, (double)y + 4.0 * scale, 16.0 * scale, 16.0 * scale, 0.0, 0.0, 1.0, 1.0, z);
    }

    public static boolean buttonHovered(int x, int y, int mx, int my, double scale) {
        return mx >= x && (double)mx <= (double)x + 24.0 * scale && my >= y && (double)my <= (double)y + 24.0 * scale;
    }

    public static boolean buttonDepressed(int x, int y, int mx, int my, boolean down, double scale) {
        return down && IconButton.buttonHovered(x, y, mx, my, scale);
    }

    private static void bindAndClamp(Minecraft mc, String name) {
        mc.func_110434_K().func_110577_a(ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/gui/%s_${TEX_QUALITY}.png", name)));
    }

    private static void drawTexturedRectUV(double x, double y, double w, double h, double u, double v, double us, double vs, float zLevel) {
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        tess.func_78374_a(x, y + h, (double)zLevel, u, v + vs);
        tess.func_78374_a(x + w, y + h, (double)zLevel, u + us, v + vs);
        tess.func_78374_a(x + w, y, (double)zLevel, u + us, v);
        tess.func_78374_a(x, y, (double)zLevel, u, v);
        tess.func_78381_a();
    }
}

