/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.pipeline;

import lc.LCRuntime;
import lc.api.defs.ILanteaCraftRenderer;
import lc.client.render.fabs.DebugLayerTileRenderer;
import lc.client.render.fabs.DefaultTileRenderer;
import lc.common.LCLog;
import lc.common.base.LCTile;
import lc.common.base.LCTileRenderer;
import lc.common.impl.registry.DefinitionRegistry;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class LCTileRenderPipeline
extends TileEntitySpecialRenderer {
    private DefinitionRegistry registry = (DefinitionRegistry)LCRuntime.runtime.registries().definitions();
    private final DefaultTileRenderer defaultTileRenderer = new DefaultTileRenderer();
    private final DebugLayerTileRenderer debugTileRenderer = new DebugLayerTileRenderer();

    public void func_147500_a(TileEntity tile, double x, double y, double z, float partialTickTime) {
        LCTile lct = (LCTile)tile;
        if (lct.shouldRender()) {
            boolean flag = true;
            ILanteaCraftRenderer worker = this.registry.getRendererFor(DefinitionRegistry.RendererType.TILE, lct.getClass());
            if (worker == null && !(worker instanceof LCTileRenderer)) {
                flag = false;
            } else {
                try {
                    LCTileRenderer tileRenderer = (LCTileRenderer)worker;
                    while (tileRenderer != null && !tileRenderer.renderTileEntityAt(lct, this, x, y, z, partialTickTime)) {
                        worker = tileRenderer.getParent();
                        if (worker != null && worker instanceof LCTileRenderer) continue;
                        flag = false;
                        break;
                    }
                }
                catch (Throwable t) {
                    LCLog.warn("Uncaught tile rendering exception.", t);
                    flag = false;
                }
            }
            if (!flag) {
                this.defaultTileRenderer.renderTileEntityAt(lct, this, x, y, z, partialTickTime);
            }
        }
        try {
            this.debugTileRenderer.renderTileEntityAt(lct, this, x, y, z, partialTickTime);
        }
        catch (Exception e) {
            LCLog.warn("Uncaught debug layer tile rendering exception.", e);
        }
    }

    public void bind(ResourceLocation texture) {
        this.func_147499_a(texture);
    }
}

