/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.pipeline;

import lc.LCRuntime;
import lc.api.defs.ILanteaCraftRenderer;
import lc.common.LCLog;
import lc.common.base.LCItemRenderer;
import lc.common.base.LCTileRenderer;
import lc.common.impl.registry.DefinitionRegistry;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;

public class LCItemRenderPipeline
implements IItemRenderer {
    private DefinitionRegistry registry = (DefinitionRegistry)LCRuntime.runtime.registries().definitions();

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        boolean flag = true;
        ILanteaCraftRenderer worker = this.registry.getRendererFor(DefinitionRegistry.RendererType.ITEM, item.func_77973_b().getClass());
        if (worker == null && !(worker instanceof LCItemRenderer)) {
            flag = false;
        } else {
            try {
                LCItemRenderer itemRenderer = (LCItemRenderer)worker;
                while (itemRenderer != null && !itemRenderer.handleRenderType(item, type)) {
                    worker = itemRenderer.getParent();
                    if (worker != null && worker instanceof LCTileRenderer) continue;
                    flag = false;
                    break;
                }
            }
            catch (Throwable t) {
                LCLog.warn("Uncaught item rendering exception.", t);
                flag = false;
            }
        }
        return flag;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        boolean flag = true;
        ILanteaCraftRenderer worker = this.registry.getRendererFor(DefinitionRegistry.RendererType.ITEM, item.func_77973_b().getClass());
        if (worker == null && !(worker instanceof LCItemRenderer)) {
            flag = false;
        } else {
            try {
                LCItemRenderer itemRenderer = (LCItemRenderer)worker;
                while (itemRenderer != null && !itemRenderer.shouldUseRenderHelper(type, item, helper)) {
                    worker = itemRenderer.getParent();
                    if (worker != null && worker instanceof LCTileRenderer) continue;
                    flag = false;
                    break;
                }
            }
            catch (Throwable t) {
                LCLog.warn("Uncaught item rendering exception.", t);
                flag = false;
            }
        }
        return flag;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        ILanteaCraftRenderer worker = this.registry.getRendererFor(DefinitionRegistry.RendererType.ITEM, item.func_77973_b().getClass());
        if (worker != null && worker instanceof LCItemRenderer) {
            try {
                LCItemRenderer itemRenderer = (LCItemRenderer)worker;
                while (itemRenderer != null && !itemRenderer.renderItem(type, item, data) && (worker = itemRenderer.getParent()) != null && worker instanceof LCTileRenderer) {
                }
            }
            catch (Throwable t) {
                LCLog.warn("Uncaught item rendering exception.", t);
            }
        }
    }
}

