/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.pipeline;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import lc.LCRuntime;
import lc.api.defs.ILanteaCraftRenderer;
import lc.client.render.fabs.DefaultBlockRenderer;
import lc.common.LCLog;
import lc.common.base.LCBlockRenderer;
import lc.common.impl.registry.DefinitionRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;

public class LCBlockRenderPipeline
implements ISimpleBlockRenderingHandler {
    private final int renderIdx;
    private final DefinitionRegistry registry;
    private final DefaultBlockRenderer defaultBlockRenderer;

    public LCBlockRenderPipeline(int renderIdx) {
        this.renderIdx = renderIdx;
        this.registry = (DefinitionRegistry)LCRuntime.runtime.registries().definitions();
        this.defaultBlockRenderer = new DefaultBlockRenderer();
    }

    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        boolean flag = true;
        ILanteaCraftRenderer worker = this.registry.getRendererFor(DefinitionRegistry.RendererType.BLOCK, block.getClass());
        if (worker == null || !(worker instanceof LCBlockRenderer)) {
            flag = false;
        } else {
            try {
                LCBlockRenderer blockRenderer = (LCBlockRenderer)worker;
                while (blockRenderer != null && !blockRenderer.renderInventoryBlock(block, renderer, metadata)) {
                    worker = this.registry.getRenderer(DefinitionRegistry.RendererType.BLOCK, blockRenderer.getParent());
                    if (worker == null || !(worker instanceof LCBlockRenderer)) {
                        flag = false;
                        break;
                    }
                    blockRenderer = (LCBlockRenderer)worker;
                }
            }
            catch (Throwable t) {
                LCLog.warn("Uncaught block rendering exception.", t);
                flag = false;
            }
        }
        if (!flag) {
            this.defaultBlockRenderer.renderInventoryBlock(block, renderer, metadata);
        }
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        boolean flag = true;
        ILanteaCraftRenderer worker = this.registry.getRendererFor(DefinitionRegistry.RendererType.BLOCK, block.getClass());
        if (worker == null || !(worker instanceof LCBlockRenderer)) {
            flag = false;
        } else {
            LCBlockRenderer blockRenderer = (LCBlockRenderer)worker;
            while (blockRenderer != null && !blockRenderer.renderWorldBlock(block, renderer, world, x, y, z)) {
                worker = this.registry.getRenderer(DefinitionRegistry.RendererType.BLOCK, blockRenderer.getParent());
                if (worker == null || !(worker instanceof LCBlockRenderer)) {
                    flag = false;
                    break;
                }
                blockRenderer = (LCBlockRenderer)worker;
            }
        }
        if (!flag) {
            flag = this.defaultBlockRenderer.renderWorldBlock(block, renderer, world, x, y, z);
        }
        return flag;
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return this.renderIdx;
    }
}

