/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.multiblock;

import java.util.ArrayList;
import java.util.List;
import lc.common.LCLog;
import lc.common.base.multiblock.LCMultiblockTile;
import lc.common.util.game.BlockFilter;
import lc.common.util.math.Matrix3;
import lc.common.util.math.Orientations;
import lc.common.util.math.Vector3;
import lc.common.util.math.VectorAABB;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class StructureConfiguration {
    public abstract Vector3 getStructureDimensions();

    public abstract Vector3 getStructureCenter();

    public abstract int[][][] getStructureLayout();

    public abstract BlockFilter[] getBlockMappings();

    public boolean test(World world, int x, int y, int z, Orientations orientation) {
        BlockFilter[] mappings = this.getBlockMappings();
        Matrix3 rotation = orientation != null ? orientation.rotation() : Matrix3.ident;
        Vector3 origin = new Vector3(x, y, z).sub(rotation.mul(this.getStructureCenter()));
        VectorAABB box = VectorAABB.boxOf(origin, this.getStructureDimensions());
        List<Vector3> elems = box.contents();
        for (Vector3 mapping : elems) {
            Vector3 tile = origin.add(rotation.mul(mapping));
            try {
                int cell = this.getStructureLayout()[mapping.rx()][mapping.ry()][mapping.rz()];
                BlockFilter filter = mappings[cell];
                if (filter.matches(world, tile.rx(), tile.ry(), tile.rz())) continue;
                return false;
            }
            catch (IndexOutOfBoundsException bounds) {
                LCLog.fatal("Access out of bounds: " + bounds.getMessage() + ": " + String.format("%s %s %s", mapping.rx(), mapping.ry(), mapping.rz()));
                return false;
            }
        }
        return true;
    }

    public Vector3[] mapType(int x, int y, int z, int typeof, Orientations orientation) {
        ArrayList<Vector3> vectors = new ArrayList<Vector3>();
        Matrix3 rotation = orientation != null ? orientation.rotation() : Matrix3.ident;
        Vector3 origin = new Vector3(x, y, z).sub(rotation.mul(this.getStructureCenter()));
        VectorAABB box = VectorAABB.boxOf(origin, this.getStructureDimensions());
        List<Vector3> elems = box.contents();
        for (Vector3 mapping : elems) {
            Vector3 tile = origin.add(rotation.mul(mapping.add(0.5, 0.5, 0.5)));
            try {
                int cell = this.getStructureLayout()[mapping.rx()][mapping.ry()][mapping.rz()];
                if (cell != typeof) continue;
                vectors.add(tile);
            }
            catch (IndexOutOfBoundsException bounds) {
                LCLog.fatal("Access out of bounds: " + bounds.getMessage() + ": " + String.format("%s %s %s", mapping.rx(), mapping.ry(), mapping.rz()));
            }
        }
        return vectors.toArray(new Vector3[0]);
    }

    public void apply(World world, int x, int y, int z, Orientations orientation, LCMultiblockTile owner) {
        Vector3 ownerVec = owner != null ? new Vector3(owner) : null;
        Matrix3 rotation = orientation != null ? orientation.rotation() : Matrix3.ident;
        Vector3 origin = new Vector3(x, y, z).sub(rotation.mul(this.getStructureCenter()));
        VectorAABB box = VectorAABB.boxOf(origin, this.getStructureDimensions());
        List<Vector3> elems = box.contents();
        for (Vector3 mapping : elems) {
            Vector3 tile = origin.add(rotation.mul(mapping));
            try {
                LCMultiblockTile multiTile;
                TileEntity wTile = world.func_147438_o(tile.rx(), tile.ry(), tile.rz());
                if (wTile == null || !(wTile instanceof LCMultiblockTile) || !(multiTile = (LCMultiblockTile)wTile).isSlave()) continue;
                multiTile.setOwner(ownerVec);
            }
            catch (IndexOutOfBoundsException bounds) {
                LCLog.fatal("Access out of bounds: " + bounds.getMessage() + ": " + String.format("%s %s %s", mapping.rx(), mapping.ry(), mapping.rz()));
            }
        }
    }
}

