/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.multiblock;

import java.util.List;
import javax.naming.OperationNotSupportedException;
import lc.LCRuntime;
import lc.common.LCLog;
import lc.common.base.LCTile;
import lc.common.base.multiblock.MultiblockState;
import lc.common.base.multiblock.StructureConfiguration;
import lc.common.network.LCNetworkException;
import lc.common.network.LCPacket;
import lc.common.network.packets.LCMultiblockPacket;
import lc.common.util.Tracer;
import lc.common.util.math.DimensionPos;
import lc.common.util.math.Vector3;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public abstract class LCMultiblockTile
extends LCTile {
    private NBTTagCompound multiblockCompound = new NBTTagCompound();
    private boolean multiblockNbtDirty = false;
    private boolean isSlave = false;

    public void setSlave(boolean state) {
        this.isSlave = state;
    }

    public boolean isSlave() {
        return this.isSlave;
    }

    protected void changeState(MultiblockState next) {
        if (this.isSlave) {
            LCLog.fatal(new OperationNotSupportedException("Not allowed to changeState on a slave."));
        } else {
            if (this.multiblockCompound.func_74764_b("state") && MultiblockState.fromOrdinal(this.multiblockCompound.func_74762_e("state")) == next) {
                return;
            }
            this.multiblockCompound.func_74768_a("state_next", next.ordinal());
        }
    }

    public void setOwner(Vector3 owner) {
        if (!this.isSlave) {
            LCLog.fatal(new OperationNotSupportedException("Not allowed to setOwner on a master."));
        } else {
            if (owner == null) {
                this.multiblockCompound.func_82580_o("owner");
            } else {
                this.multiblockCompound.func_74782_a("owner", (NBTBase)owner.toNBT());
            }
            this.markMultiblockDirty();
        }
    }

    public MultiblockState getState() {
        if (this.isSlave) {
            if (!this.multiblockCompound.func_74764_b("owner")) {
                return MultiblockState.NONE;
            }
            Vector3 owner = Vector3.from(this.multiblockCompound.func_74775_l("owner"));
            TileEntity tile = this.field_145850_b.func_147438_o(owner.fx(), owner.fy(), owner.fz());
            if (!(tile instanceof LCMultiblockTile)) {
                return MultiblockState.NONE;
            }
            return ((LCMultiblockTile)tile).getState();
        }
        if (!this.multiblockCompound.func_74764_b("state")) {
            return MultiblockState.NONE;
        }
        return MultiblockState.fromOrdinal(this.multiblockCompound.func_74762_e("state"));
    }

    public MultiblockState nextState() {
        if (!this.multiblockCompound.func_74764_b("state_next")) {
            return null;
        }
        return MultiblockState.fromOrdinal(this.multiblockCompound.func_74762_e("state_next"));
    }

    public void markMultiblockDirty() {
        this.multiblockNbtDirty = true;
    }

    public abstract StructureConfiguration getConfiguration();

    public abstract void thinkMultiblock();

    @Override
    public void thinkServerPost() {
        super.thinkServerPost();
        Tracer.begin(this);
        this.thinkMultiblock();
        MultiblockState next = this.nextState();
        if (next != null && next != this.getState()) {
            this.multiblockCompound.func_74768_a("state", next.ordinal());
            this.multiblockNbtDirty = true;
        }
        if (this.multiblockNbtDirty) {
            this.multiblockNbtDirty = false;
            LCMultiblockPacket update = new LCMultiblockPacket(new DimensionPos(this), this.multiblockCompound);
            LCRuntime.runtime.network().getPreferredPipe().sendToAllAround(update, update.target, 128.0);
        }
        Tracer.end();
    }

    @Override
    public void thinkPacket(LCPacket packet, EntityPlayer player) throws LCNetworkException {
        Tracer.begin(this);
        if (packet instanceof LCMultiblockPacket && this.field_145850_b.field_72995_K) {
            this.multiblockCompound = ((LCMultiblockPacket)packet).compound;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        Tracer.end();
    }

    @Override
    public void sendPackets(List<LCPacket> packets) throws LCNetworkException {
        super.sendPackets(packets);
        Tracer.begin(this);
        packets.add(new LCMultiblockPacket(new DimensionPos(this), this.multiblockCompound));
        Tracer.end();
    }

    @Override
    public void save(NBTTagCompound compound) {
    }

    @Override
    public void load(NBTTagCompound compound) {
    }
}

