/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.generation.structure;

import java.util.Random;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public abstract class LCFeature
extends StructureComponent {
    protected int scatteredFeatureSizeX;
    protected int scatteredFeatureSizeY;
    protected int scatteredFeatureSizeZ;
    protected int hPos = -1;

    public LCFeature() {
    }

    protected LCFeature(Random rng, int x, int y, int z, int sx, int sy, int sz) {
        super(0);
        this.scatteredFeatureSizeX = sx;
        this.scatteredFeatureSizeY = sy;
        this.scatteredFeatureSizeZ = sz;
        this.field_74885_f = rng.nextInt(4);
        switch (this.field_74885_f) {
            case 0: 
            case 2: {
                this.field_74887_e = new StructureBoundingBox(x, y, z, x + sx - 1, y + sy - 1, z + sz - 1);
                break;
            }
            default: {
                this.field_74887_e = new StructureBoundingBox(x, y, z, x + sz - 1, y + sy - 1, z + sx - 1);
            }
        }
    }

    protected void func_143012_a(NBTTagCompound tag) {
        tag.func_74768_a("Width", this.scatteredFeatureSizeX);
        tag.func_74768_a("Height", this.scatteredFeatureSizeY);
        tag.func_74768_a("Depth", this.scatteredFeatureSizeZ);
        tag.func_74768_a("HPos", this.hPos);
    }

    protected void func_143011_b(NBTTagCompound tag) {
        this.scatteredFeatureSizeX = tag.func_74762_e("Width");
        this.scatteredFeatureSizeY = tag.func_74762_e("Height");
        this.scatteredFeatureSizeZ = tag.func_74762_e("Depth");
        this.hPos = tag.func_74762_e("HPos");
    }

    protected boolean canPlaceAt(World world, StructureBoundingBox sbb, int offset) {
        if (this.hPos >= 0) {
            return true;
        }
        int j = 0;
        int k = 0;
        for (int z = this.field_74887_e.field_78896_c; z <= this.field_74887_e.field_78892_f; ++z) {
            for (int x = this.field_74887_e.field_78897_a; x <= this.field_74887_e.field_78893_d; ++x) {
                if (!sbb.func_78890_b(x, 64, z)) continue;
                j += Math.max(world.func_72825_h(x, z), world.field_73011_w.func_76557_i());
                ++k;
            }
        }
        if (k == 0) {
            return false;
        }
        this.hPos = j / k;
        this.field_74887_e.func_78886_a(0, this.hPos - this.field_74887_e.field_78895_b + offset, 0);
        return true;
    }
}

