/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.generation.scattered;

import java.util.Random;
import lc.common.util.math.Vector3;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public abstract class LCScatteredFeature
extends StructureComponent {
    protected int scatteredFeatureSizeX;
    protected int scatteredFeatureSizeY;
    protected int scatteredFeatureSizeZ;
    protected int hPos = -1;

    public LCScatteredFeature() {
        this.field_74885_f = 0;
    }

    protected LCScatteredFeature(Random rng, int x, int y, int z, int sx, int sy, int sz) {
        super(0);
        this.field_74885_f = 0;
        this.scatteredFeatureSizeX = sx;
        this.scatteredFeatureSizeY = sy;
        this.scatteredFeatureSizeZ = sz;
        this.field_74887_e = new StructureBoundingBox(x, y, z, x + sz - 1, y + sy - 1, z + sx - 1);
    }

    protected void func_143012_a(NBTTagCompound tag) {
        tag.func_74768_a("Width", this.scatteredFeatureSizeX);
        tag.func_74768_a("Height", this.scatteredFeatureSizeY);
        tag.func_74768_a("Depth", this.scatteredFeatureSizeZ);
        tag.func_74768_a("HPos", this.hPos);
    }

    protected void func_143011_b(NBTTagCompound tag) {
        this.scatteredFeatureSizeX = tag.func_74762_e("Width");
        this.scatteredFeatureSizeY = tag.func_74762_e("Height");
        this.scatteredFeatureSizeZ = tag.func_74762_e("Depth");
        this.hPos = tag.func_74762_e("HPos");
    }

    protected void recalcHeightOffsets(World world, StructureBoundingBox sbb, int offset) {
        if (this.hPos >= 0) {
            return;
        }
        int seenBlocks = 0;
        int totalHeight = 0;
        for (int z = this.field_74887_e.field_78896_c; z <= this.field_74887_e.field_78892_f; ++z) {
            for (int x = this.field_74887_e.field_78897_a; x <= this.field_74887_e.field_78893_d; ++x) {
                totalHeight += Math.max(world.func_72825_h(x, z), world.field_73011_w.func_76557_i());
                ++seenBlocks;
            }
        }
        if (seenBlocks == 0) {
            return;
        }
        this.hPos = totalHeight / seenBlocks;
        this.field_74887_e.func_78886_a(0, this.hPos - this.field_74887_e.field_78895_b + offset, 0);
    }

    public abstract boolean func_74875_a(World var1, Random var2, StructureBoundingBox var3);

    protected void fill(World w, StructureBoundingBox bb, Vector3 v0, Vector3 v1, Block b0) {
        this.fill(w, bb, v0, v1, b0, b0);
    }

    protected void fill(World w, StructureBoundingBox bb, Vector3 v0, Vector3 v1, Block b0, int m0) {
        this.fill(w, bb, v0, v1, b0, m0, b0, m0);
    }

    protected void fill(World w, StructureBoundingBox bb, Vector3 v0, Vector3 v1, Block b0, Block b1) {
        this.fill(w, bb, v0, v1, b0, b1, false);
    }

    protected void fill(World w, StructureBoundingBox bb, Vector3 v0, Vector3 v1, Block b0, int m0, Block b1, int m1) {
        this.fill(w, bb, v0, v1, b0, m0, b1, m1, false);
    }

    protected void fill(World w, StructureBoundingBox bb, Vector3 v0, Vector3 v1, Block b0, Block b1, boolean rep) {
        this.func_151549_a(w, bb, v0.fx(), v0.fy(), v0.fz(), v1.fx(), v1.fy(), v1.fz(), b0, b1, rep);
    }

    protected void fill(World w, StructureBoundingBox bb, Vector3 v0, Vector3 v1, Block b0, int m0, Block b1, int m1, boolean rep) {
        this.func_151556_a(w, bb, v0.fx(), v0.fy(), v0.fz(), v1.fx(), v1.fy(), v1.fz(), b0, m0, b1, m1, rep);
    }
}

