/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.generation;

import java.util.Set;
import lc.common.LCLog;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraft.world.storage.MapStorage;

public class LCWorldData
extends WorldSavedData {
    NBTTagCompound compound;

    public LCWorldData() {
        this("LC2DS");
    }

    public LCWorldData(String label) {
        super("LC2DS");
        if (!label.equals("LC2DS")) {
            LCLog.warn("Warning, loading LCWorldData wrapper around storage with label %s!", label);
        }
        this.compound = new NBTTagCompound();
    }

    public static LCWorldData forWorld(World world) {
        MapStorage storage = world.perWorldStorage;
        LCWorldData result = (LCWorldData)storage.func_75742_a(LCWorldData.class, "LC2DS");
        if (result == null) {
            result = new LCWorldData();
            storage.func_75745_a("LC2DS", (WorldSavedData)result);
        }
        return result;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        Set tags = nbt.func_150296_c();
        for (String tag : tags) {
            this.compound.func_74782_a(tag, nbt.func_74781_a(tag));
        }
        if (!this.compound.func_74764_b("LC2DS")) {
            LCLog.warn("Warning, readFromNBT LCWorldData wrapper couldn't find LC2DS store!");
            this.compound.func_74782_a("LC2DS", (NBTBase)new NBTTagCompound());
        }
    }

    public void func_76187_b(NBTTagCompound nbt) {
        if (!this.compound.func_74764_b("LC2DS")) {
            LCLog.warn("Warning, writeToNBT LCWorldData wrapper doesn't have LC2DS store!");
        }
        Set tags = this.compound.func_150296_c();
        for (String tag : tags) {
            nbt.func_74782_a(tag, this.compound.func_74781_a(tag));
        }
    }

    public NBTTagCompound getDSData() {
        return this.compound.func_74775_l("LC2DS");
    }
}

