/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.generation;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import lc.common.LCLog;
import lc.common.base.generation.LCChunkData;
import lc.common.base.generation.decoration.LCChunkDecorator;
import lc.common.base.generation.scattered.LCScatteredFeatureGenerator;
import lc.common.base.generation.structure.LCFeatureGenerator;
import lc.common.util.Tracer;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public class LCMasterWorldGen
implements IWorldGenerator {
    protected final LCScatteredFeatureGenerator scatteredGenerator = new LCScatteredFeatureGenerator();
    protected final LCFeatureGenerator featureGenerator = new LCFeatureGenerator();
    protected final LCChunkDecorator decorator = new LCChunkDecorator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        try {
            Tracer.begin(this, "chunk decorator pass");
            Chunk achunk = world.func_72964_e(chunkX, chunkZ);
            this.decorator.paint(random, world, achunk, LCChunkData.forChunk(achunk));
        }
        catch (Throwable t) {
            LCLog.warn("Problem decoration chunk.", t);
        }
        finally {
            Tracer.end();
        }
        try {
            Tracer.begin(this, "scattered feature generator allocation");
            this.scatteredGenerator.func_151539_a(chunkProvider, world, chunkX, chunkZ, null);
        }
        catch (Throwable t) {
            LCLog.warn("Problem populating scattered features for chunk.", t);
        }
        finally {
            Tracer.end();
        }
        try {
            Tracer.begin(this, "ordered feature generator allocation");
            this.featureGenerator.func_151539_a(chunkProvider, world, chunkX, chunkX, null);
        }
        catch (Throwable t) {
            LCLog.warn("Problem populating features for chunk.", t);
        }
        finally {
            Tracer.end();
        }
        boolean flag = false;
        try {
            Tracer.begin(this, "scattered feature population");
            this.scatteredGenerator.func_75051_a(world, random, chunkX, chunkZ);
        }
        catch (Throwable t) {
            LCLog.warn("Failed to generate scattered structures.", t);
        }
        finally {
            Tracer.end();
        }
        if (!flag) {
            try {
                Tracer.begin(this, "ordered feature population");
                flag = this.featureGenerator.func_75051_a(world, random, chunkX, chunkZ);
            }
            catch (Throwable t) {
                LCLog.warn("Failed to generate structures.", t);
            }
            finally {
                Tracer.end();
            }
        }
    }
}

