/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base.generation;

import java.util.WeakHashMap;
import lc.LCRuntime;
import lc.common.LCLog;
import lc.server.HintProviderServer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;

public class LCChunkData {
    private static WeakHashMap<Chunk, LCChunkData> chunkCache = new WeakHashMap();
    public NBTTagCompound compound = new NBTTagCompound();
    public NBTTagCompound legacyCompound;
    private boolean dirty = false;

    public static LCChunkData forChunk(Chunk chunk) {
        LCChunkData data = chunkCache.get(chunk);
        if (data == null) {
            data = new LCChunkData();
            chunkCache.put(chunk, data);
        }
        return data;
    }

    public static void onChunkLoad(ChunkDataEvent.Load e) {
        Chunk chunk = e.getChunk();
        LCChunkData data = LCChunkData.forChunk(chunk);
        if (!data.dirty) {
            data.readFromNBT(e.getData());
            ((HintProviderServer)LCRuntime.runtime.hints()).generator().decorator.paint(e.world.field_73012_v, e.world, chunk, data);
        } else {
            LCLog.warn("Detected chunk data load before data commit, forcing a commit now.");
            data.writeToNBT(e.getData());
            data.dirty = false;
        }
    }

    public static void onChunkSave(ChunkDataEvent.Save e) {
        Chunk chunk = e.getChunk();
        LCChunkData data = LCChunkData.forChunk(chunk);
        data.writeToNBT(e.getData());
        data.dirty = false;
    }

    public static void flush() {
        chunkCache.clear();
    }

    private LCChunkData() {
    }

    public void dirty() {
        this.dirty = true;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("LC2DS")) {
            this.compound = nbt.func_74775_l("LC2DS");
        }
        if (nbt.func_74764_b("LanteaCraftMeta")) {
            this.legacyCompound = nbt.func_74775_l("LanteaCraftMeta");
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("LC2DS", (NBTBase)this.compound);
        if (this.legacyCompound != null) {
            nbt.func_74782_a("LanteaCraftMeta", (NBTBase)this.legacyCompound);
        }
    }
}

