/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base;

import cpw.mods.fml.relauncher.Side;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import lc.LCRuntime;
import lc.api.audio.ISoundController;
import lc.api.audio.channel.ChannelDescriptor;
import lc.api.audio.channel.IMixer;
import lc.api.audio.streaming.ISound;
import lc.api.audio.streaming.ISoundProperties;
import lc.api.audio.streaming.ISoundServer;
import lc.api.event.IBlockEventHandler;
import lc.api.rendering.IBlockRenderInfo;
import lc.api.rendering.IEntityRenderInfo;
import lc.api.rendering.IRenderInfo;
import lc.common.LCLog;
import lc.common.configuration.IConfigure;
import lc.common.network.IPacketHandler;
import lc.common.network.LCNetworkException;
import lc.common.network.LCPacket;
import lc.common.network.packets.LCClientUpdate;
import lc.common.network.packets.LCTileSync;
import lc.common.util.ReflectionHelper;
import lc.common.util.Tracer;
import lc.common.util.java.DestructableReferenceQueue;
import lc.common.util.math.DimensionPos;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class LCTile
extends TileEntity
implements IInventory,
IPacketHandler,
IBlockEventHandler,
IRenderInfo,
IConfigure {
    private static HashMap<Class<? extends LCTile>, HashMap<String, ArrayList<String>>> callbacks = new HashMap();
    private static HashMap<Class<? extends LCTile>, ArrayList<ChannelDescriptor>> channels = new HashMap();
    protected NBTTagCompound compound;
    private boolean nbtDirty;
    private boolean clientDataDirty = true;
    private int clientDataCooldown;
    private IMixer clientMixer;

    public static void registerCallback(Class<?> me, String method, String event) {
        HashMap<String, ArrayList<String>> me_calls;
        Class<?> tile = me;
        if (!callbacks.containsKey(tile)) {
            callbacks.put(tile, new HashMap());
        }
        if (!(me_calls = callbacks.get(tile)).containsKey(event)) {
            me_calls.put(event, new ArrayList());
        }
        if (!me_calls.get(event).contains(method)) {
            me_calls.get(event).add(method);
        }
        LCLog.debug("Driver adding callback on class %s event %s: %s", me.getName(), event, method);
    }

    public static void registerChannel(Class<?> me, ChannelDescriptor descriptor) {
        ArrayList<ChannelDescriptor> descriptors;
        Class<?> tile = me;
        if (!channels.containsKey(tile)) {
            channels.put(tile, new ArrayList());
        }
        if (!(descriptors = channels.get(tile)).contains(descriptor)) {
            descriptors.add(descriptor);
        }
        LCLog.debug("Adding sound descriptor %s on class %s", descriptor, me.getName());
    }

    public static void doCallbacksNow(Object me, String type, Object ... params) {
        Class<?> meClazz = me.getClass();
        ArrayList<String> cbs = LCTile.getCallbacks(meClazz, type);
        if (cbs == null) {
            return;
        }
        Tracer.begin(meClazz, String.format("doCallbacksNow invocation: %s", type));
        LCTile.doCallbacks(meClazz, me, cbs, params);
        Tracer.end();
    }

    public static ArrayList<String> getCallbacks(Class<? extends LCTile> me, String type) {
        if (!callbacks.containsKey(me)) {
            return null;
        }
        HashMap<String, ArrayList<String>> me_calls = callbacks.get(me);
        if (!me_calls.containsKey(type)) {
            return null;
        }
        return me_calls.get(type);
    }

    public static void doCallbacks(Class<? extends LCTile> me, Object meObject, ArrayList<String> methods, Object[] aparams) {
        Tracer.begin(me, String.format("doCallbacks invocation: %s", methods.size()));
        Method[] meMethods = me.getMethods();
        block2: for (String methodName : methods) {
            for (Method invoke : meMethods) {
                if (!invoke.getName().equalsIgnoreCase(methodName)) continue;
                if (aparams == null) {
                    aparams = new Object[]{meObject};
                }
                Tracer.begin(me, String.format("doCallbacks method invocation: %s", invoke));
                try {
                    ReflectionHelper.invokeWithExpansions(meObject, invoke, aparams);
                }
                catch (Throwable t) {
                    LCLog.warn("Error when processing callback %s!", methodName, t);
                }
                Tracer.end();
                continue block2;
            }
        }
        Tracer.end();
    }

    public static ChannelDescriptor[] getDescriptors(Class<? extends LCTile> me) {
        if (!channels.containsKey(me)) {
            return null;
        }
        return channels.get(me).toArray(new ChannelDescriptor[0]);
    }

    public abstract IInventory getInventory();

    public abstract void thinkClient();

    public void thinkClientPost() {
    }

    public abstract void thinkServer();

    public void thinkServerPost() {
    }

    public abstract void thinkPacket(LCPacket var1, EntityPlayer var2) throws LCNetworkException;

    public void sendPackets(List<LCPacket> packets) throws LCNetworkException {
        packets.add(new LCTileSync(new DimensionPos(this), this.compound));
    }

    public abstract boolean shouldRender();

    public abstract void save(NBTTagCompound var1);

    public abstract void load(NBTTagCompound var1);

    public abstract String[] debug(Side var1);

    public NBTTagCompound getBaseCompound() {
        return this.compound;
    }

    public ForgeDirection getRotation() {
        if (this.compound == null || !this.compound.func_74764_b("canRotate")) {
            return ForgeDirection.NORTH;
        }
        return ForgeDirection.getOrientation((int)this.compound.func_74762_e("canRotate"));
    }

    public void setRotation(ForgeDirection direction) {
        if (this.compound == null) {
            this.compound = new NBTTagCompound();
        }
        this.compound.func_74768_a("canRotate", direction.ordinal());
        this.markNbtDirty();
    }

    public void func_145843_s() {
        super.func_145843_s();
        LCTile.doCallbacksNow(this, "tileInvalidated", new Object[0]);
        if (this.clientMixer != null) {
            this.clientMixer.shutdown(true);
        }
        DestructableReferenceQueue.queue(this);
    }

    public void onChunkUnload() {
        LCTile.doCallbacksNow(this, "tileUnload", new Object[0]);
        if (this.clientMixer != null) {
            this.clientMixer.shutdown(true);
        }
        DestructableReferenceQueue.queue(this);
    }

    @Override
    public void blockPlaced() {
        LCTile.doCallbacksNow(this, "blockPlace", new Object[0]);
    }

    @Override
    public void blockBroken() {
        LCTile.doCallbacksNow(this, "blockBreak", new Object[0]);
        if (this.clientMixer != null) {
            this.clientMixer.shutdown(true);
        }
        DestructableReferenceQueue.queue(this);
    }

    @Override
    public void neighborChanged() {
        LCTile.doCallbacksNow(this, "neighborChanged", new Object[0]);
    }

    protected void markNbtDirty() {
        this.nbtDirty = true;
    }

    protected void markClientDataDirty() {
        this.clientDataDirty = true;
    }

    protected void sendUpdatesToClients() {
        Tracer.begin(this);
        try {
            ArrayList<LCPacket> packets = new ArrayList<LCPacket>();
            this.sendPackets(packets);
            for (LCPacket packet : packets) {
                this.sendPacketToClients(packet);
            }
        }
        catch (LCNetworkException e) {
            LCLog.warn("Error sending network update.", e);
        }
        Tracer.end();
    }

    protected void sendPacketToClients(LCPacket packet) {
        LCRuntime.runtime.network().getPreferredPipe().sendScoped(packet, 128.0);
    }

    private void sendUpdatesToClient(EntityPlayerMP player) {
        Tracer.begin(this);
        try {
            ArrayList<LCPacket> packets = new ArrayList<LCPacket>();
            this.sendPackets(packets);
            for (LCPacket packet : packets) {
                this.sendPacketToClient(packet, player);
            }
        }
        catch (LCNetworkException e) {
            LCLog.warn("Error sending network update.", e);
        }
        Tracer.end();
    }

    protected void sendPacketToClient(LCPacket packet, EntityPlayerMP player) {
        LCRuntime.runtime.network().getPreferredPipe().sendTo(packet, player);
    }

    @Override
    public void handlePacket(LCPacket packetOf, EntityPlayer player) throws LCNetworkException {
        Tracer.begin(this);
        if (packetOf instanceof LCTileSync && this.field_145850_b.field_72995_K) {
            this.clientDataDirty = false;
            this.compound = ((LCTileSync)packetOf).compound;
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (packetOf instanceof LCClientUpdate) {
            if (!this.field_145850_b.field_72995_K) {
                this.sendUpdatesToClient((EntityPlayerMP)player);
            } else {
                throw new LCNetworkException("Can't handle LCClientUpdates on the client!");
            }
        }
        try {
            Tracer.begin(this, "thinkPacket implementation");
            this.thinkPacket(packetOf, player);
        }
        finally {
            Tracer.end();
        }
        Tracer.end();
    }

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        Tracer.begin(this);
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                Tracer.begin(this, "thinkClient implementation");
                this.thinkClient();
                this.thinkClientPost();
                Tracer.end();
                if (this.clientDataDirty) {
                    Tracer.begin(this, "enqueueClientDataUpdateReq");
                    if (this.clientDataCooldown > 0) {
                        --this.clientDataCooldown;
                    }
                    if (this.clientDataCooldown <= 0) {
                        LCRuntime.runtime.network().getPreferredPipe().sendToServer(new LCClientUpdate(new DimensionPos(this)));
                        this.clientDataCooldown += 600;
                    }
                    Tracer.end();
                }
            } else {
                Tracer.begin(this, "thinkServer implementation");
                this.thinkServer();
                this.thinkServerPost();
                Tracer.end();
                if (this.nbtDirty) {
                    this.nbtDirty = false;
                    Tracer.begin(this, "enqueueNBTDataUpdate");
                    LCTileSync packet = new LCTileSync(new DimensionPos(this), this.compound);
                    LCRuntime.runtime.network().getPreferredPipe().sendToAllAround(packet, packet.target, 128.0);
                    Tracer.end();
                }
            }
        }
        Tracer.end();
    }

    public void func_145839_a(NBTTagCompound p_145839_1_) {
        super.func_145839_a(p_145839_1_);
        this.compound = p_145839_1_.func_74764_b("base-tag") ? p_145839_1_.func_74775_l("base-tag") : new NBTTagCompound();
        if (p_145839_1_.func_74764_b("inventory") && this.getInventory() != null) {
            IInventory inventory = this.getInventory();
            NBTTagList tagList = p_145839_1_.func_150295_c("inventory", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("slot");
                if (slot < 0 || slot >= inventory.func_70302_i_()) continue;
                inventory.func_70299_a((int)slot, ItemStack.func_77949_a((NBTTagCompound)tag));
            }
        }
        this.markNbtDirty();
        try {
            this.load(p_145839_1_);
        }
        catch (Throwable t) {
            LCLog.warn("Failed when loading data from NBT for tile.", t);
        }
    }

    public void func_145841_b(NBTTagCompound p_145841_1_) {
        super.func_145841_b(p_145841_1_);
        if (this.compound != null) {
            p_145841_1_.func_74782_a("base-tag", (NBTBase)this.compound);
        }
        if (this.getInventory() != null) {
            IInventory inventory = this.getInventory();
            NBTTagList itemList = new NBTTagList();
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                ItemStack stack = inventory.func_70301_a(i);
                if (stack == null) continue;
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74774_a("slot", (byte)i);
                stack.func_77955_b(tag);
                itemList.func_74742_a((NBTBase)tag);
            }
            p_145841_1_.func_74782_a("inventory", (NBTBase)itemList);
        }
        try {
            this.save(p_145841_1_);
        }
        catch (Throwable t) {
            LCLog.warn("Failed when saving data to NBT for tile.", t);
        }
    }

    public int func_70302_i_() {
        if (this.getInventory() == null) {
            return 0;
        }
        return this.getInventory().func_70302_i_();
    }

    public ItemStack func_70301_a(int p_70301_1_) {
        if (this.getInventory() == null) {
            return null;
        }
        return this.getInventory().func_70301_a(p_70301_1_);
    }

    public ItemStack func_70298_a(int p_70298_1_, int p_70298_2_) {
        if (this.getInventory() == null) {
            return null;
        }
        return this.getInventory().func_70298_a(p_70298_1_, p_70298_2_);
    }

    public ItemStack func_70304_b(int p_70304_1_) {
        if (this.getInventory() == null) {
            return null;
        }
        return this.getInventory().func_70304_b(p_70304_1_);
    }

    public void func_70299_a(int p_70299_1_, ItemStack p_70299_2_) {
        if (this.getInventory() == null) {
            return;
        }
        this.getInventory().func_70299_a(p_70299_1_, p_70299_2_);
    }

    public String func_145825_b() {
        if (this.getInventory() == null) {
            return null;
        }
        return this.getInventory().func_145825_b();
    }

    public boolean func_145818_k_() {
        if (this.getInventory() == null) {
            return false;
        }
        return this.getInventory().func_145818_k_();
    }

    public int func_70297_j_() {
        if (this.getInventory() == null) {
            return 0;
        }
        return this.getInventory().func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer p_70300_1_) {
        if (this.getInventory() == null) {
            return false;
        }
        return this.getInventory().func_70300_a(p_70300_1_);
    }

    public void func_70295_k_() {
        if (this.getInventory() == null) {
            return;
        }
        this.getInventory().func_70295_k_();
    }

    public void func_70305_f() {
        if (this.getInventory() == null) {
            return;
        }
        this.getInventory().func_70305_f();
    }

    public boolean func_94041_b(int p_94041_1_, ItemStack p_94041_2_) {
        if (this.getInventory() == null) {
            return false;
        }
        return this.getInventory().func_94041_b(p_94041_1_, p_94041_2_);
    }

    public Packet func_145844_m() {
        if (this.field_145850_b.field_72995_K) {
            LCRuntime.runtime.network().getPreferredPipe().sendToServer(new LCClientUpdate(new DimensionPos(this)));
        }
        return null;
    }

    @Override
    public IEntityRenderInfo renderInfoEntity() {
        return null;
    }

    @Override
    public IBlockRenderInfo renderInfoBlock() {
        return null;
    }

    public IMixer mixer() {
        ChannelDescriptor[] descriptors;
        if (this.clientMixer != null) {
            return this.clientMixer;
        }
        ISoundController sys = LCRuntime.runtime.hints().audio();
        if (sys == null || !sys.ready()) {
            return null;
        }
        this.clientMixer = sys.findMixer(this);
        for (ChannelDescriptor descriptor : descriptors = LCTile.getDescriptors(this.getClass())) {
            this.clientMixer.createChannelDescriptor(descriptor.name, descriptor);
        }
        return this.clientMixer;
    }

    protected ISound sound(String filename, ISoundProperties properties) {
        ISoundController sys = LCRuntime.runtime.hints().audio();
        if (sys == null || !sys.ready()) {
            return null;
        }
        ISoundServer server = sys.getSoundService();
        if (server == null || !server.ready()) {
            return null;
        }
        return server.assign(this, filename, sys.getPosition(this), properties);
    }

    public int getRedstoneOutput(int side) {
        return 0;
    }

    public boolean canConnectRedstone(int side) {
        return false;
    }
}

