/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base;

import lc.api.defs.IDefinitionReference;
import lc.api.defs.ILanteaCraftRenderer;
import lc.common.configuration.IConfigure;
import lc.common.impl.registry.DefinitionReference;
import lc.common.util.math.Trans3;
import lc.common.util.math.Vector3;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class LCBlockRenderer
implements ILanteaCraftRenderer,
IConfigure {
    private double u0;
    private double v0;
    private double u1;
    private double v1;
    private double us;
    private double vs;
    private boolean textureOverridden;
    private float cmr;
    private float cmg;
    private float cmb;
    protected static double[][] cubeMap = new double[][]{{-0.5, -0.5, 0.5, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0, 0.0, -1.0, 0.0}, {-0.5, 0.5, -0.5, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 1.0, 0.0}, {0.5, 0.5, -0.5, 0.0, -1.0, 0.0, -1.0, 0.0, 0.0, 0.0, 0.0, -1.0}, {-0.5, 0.5, 0.5, 0.0, -1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0}, {-0.5, 0.5, -0.5, 0.0, -1.0, 0.0, 0.0, 0.0, 1.0, -1.0, 0.0, 0.0}, {0.5, 0.5, 0.5, 0.0, -1.0, 0.0, 0.0, 0.0, -1.0, 1.0, 0.0, 0.0}};

    public abstract Class<? extends LCBlockRenderer> getParent();

    public abstract boolean renderInventoryBlock(Block var1, RenderBlocks var2, int var3);

    public abstract boolean renderWorldBlock(Block var1, RenderBlocks var2, IBlockAccess var3, int var4, int var5, int var6);

    public abstract boolean renderInventoryItemAs3d();

    @Override
    public IDefinitionReference ref() {
        return new DefinitionReference(this);
    }

    public void renderDefaultInventoryBlock(Block block, int metadata, RenderBlocks rb) {
        this.renderDefaultInventoryBlock(block, metadata, new Trans3(0.0, 0.0, 0.0), rb);
    }

    public void renderDefaultInventoryBlock(Block block, int metadata, Trans3 trans, RenderBlocks rb) {
        this.setUpTextureOverride(rb);
        this.setColorMultiplier(0xFFFFFF);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        tess.func_78382_b();
        GL11.glTranslatef((float)0.0f, (float)-0.1f, (float)0.0f);
        this.renderCube(tess, trans, null, block, 0, 0, 0, metadata, 0xF000F0);
        tess.func_78381_a();
    }

    public boolean renderDefaultWorldBlock(IBlockAccess world, int x, int y, int z, Block block, RenderBlocks rb) {
        return this.renderDefaultWorldBlock(world, x, y, z, block, new Trans3((double)x + 0.5, (double)y + 0.5, (double)z + 0.5), rb);
    }

    public boolean renderDefaultWorldBlock(IBlockAccess world, int x, int y, int z, Block block, Trans3 trans, RenderBlocks rb) {
        this.setUpTextureOverride(rb);
        this.setColorMultiplier(block.func_149720_d(world, x, y, z));
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78386_a(1.0f, 1.0f, 1.0f);
        this.renderCube(tess, trans, world, block, x, y, z, world.func_72805_g(x, y, z), block.func_149677_c(world, x, y, z));
        return true;
    }

    public void renderDefaultItem(ItemStack stack) {
        IIcon iicon = stack.func_77973_b().func_77617_a(stack.func_77960_j());
        if (iicon == null) {
            return;
        }
        TextureManager texturemanager = Minecraft.func_71410_x().func_110434_K();
        texturemanager.func_110577_a(texturemanager.func_130087_a(stack.func_94608_d()));
        TextureUtil.func_152777_a((boolean)false, (boolean)false, (float)1.0f);
        Tessellator tessellator = Tessellator.field_78398_a;
        float u0 = iicon.func_94209_e();
        float u1 = iicon.func_94212_f();
        float v0 = iicon.func_94206_g();
        float v1 = iicon.func_94210_h();
        float f4 = 0.0f;
        float f5 = 0.3f;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)(-f4), (float)(-f5), (float)0.0f);
        float f6 = 1.25f;
        GL11.glScalef((float)f6, (float)f6, (float)f6);
        GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)0.0f);
        this.renderItemIn2D(tessellator, u1, v0, u0, v1, iicon.func_94211_a(), iicon.func_94216_b(), 0.0625f);
        GL11.glEnable((int)2896);
        TextureUtil.func_147945_b();
        GL11.glPopMatrix();
    }

    private void renderItemIn2D(Tessellator t, float u1, float v0, float u0, float v1, int w, int h, float p_78439_7_) {
        float f9;
        float f8;
        float f7;
        int k;
        t.func_78382_b();
        t.func_78375_b(0.0f, 0.0f, 1.0f);
        t.func_78374_a(0.0, 0.0, 0.0, (double)u1, (double)v1);
        t.func_78374_a(1.0, 0.0, 0.0, (double)u0, (double)v1);
        t.func_78374_a(1.0, 1.0, 0.0, (double)u0, (double)v0);
        t.func_78374_a(0.0, 1.0, 0.0, (double)u1, (double)v0);
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(0.0f, 0.0f, -1.0f);
        t.func_78374_a(0.0, 1.0, (double)(0.0f - p_78439_7_), (double)u1, (double)v0);
        t.func_78374_a(1.0, 1.0, (double)(0.0f - p_78439_7_), (double)u0, (double)v0);
        t.func_78374_a(1.0, 0.0, (double)(0.0f - p_78439_7_), (double)u0, (double)v1);
        t.func_78374_a(0.0, 0.0, (double)(0.0f - p_78439_7_), (double)u1, (double)v1);
        t.func_78381_a();
        float f5 = 0.5f * (u1 - u0) / (float)w;
        float f6 = 0.5f * (v1 - v0) / (float)h;
        t.func_78382_b();
        t.func_78375_b(-1.0f, 0.0f, 0.0f);
        for (k = 0; k < w; ++k) {
            f7 = (float)k / (float)w;
            f8 = u1 + (u0 - u1) * f7 - f5;
            t.func_78374_a((double)f7, 0.0, (double)(0.0f - p_78439_7_), (double)f8, (double)v1);
            t.func_78374_a((double)f7, 0.0, 0.0, (double)f8, (double)v1);
            t.func_78374_a((double)f7, 1.0, 0.0, (double)f8, (double)v0);
            t.func_78374_a((double)f7, 1.0, (double)(0.0f - p_78439_7_), (double)f8, (double)v0);
        }
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(1.0f, 0.0f, 0.0f);
        for (k = 0; k < w; ++k) {
            f7 = (float)k / (float)w;
            f8 = u1 + (u0 - u1) * f7 - f5;
            f9 = f7 + 1.0f / (float)w;
            t.func_78374_a((double)f9, 1.0, (double)(0.0f - p_78439_7_), (double)f8, (double)v0);
            t.func_78374_a((double)f9, 1.0, 0.0, (double)f8, (double)v0);
            t.func_78374_a((double)f9, 0.0, 0.0, (double)f8, (double)v1);
            t.func_78374_a((double)f9, 0.0, (double)(0.0f - p_78439_7_), (double)f8, (double)v1);
        }
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(0.0f, 1.0f, 0.0f);
        for (k = 0; k < h; ++k) {
            f7 = (float)k / (float)h;
            f8 = v1 + (v0 - v1) * f7 - f6;
            f9 = f7 + 1.0f / (float)h;
            t.func_78374_a(0.0, (double)f9, 0.0, (double)u1, (double)f8);
            t.func_78374_a(1.0, (double)f9, 0.0, (double)u0, (double)f8);
            t.func_78374_a(1.0, (double)f9, (double)(0.0f - p_78439_7_), (double)u0, (double)f8);
            t.func_78374_a(0.0, (double)f9, (double)(0.0f - p_78439_7_), (double)u1, (double)f8);
        }
        t.func_78381_a();
        t.func_78382_b();
        t.func_78375_b(0.0f, -1.0f, 0.0f);
        for (k = 0; k < h; ++k) {
            f7 = (float)k / (float)h;
            f8 = v1 + (v0 - v1) * f7 - f6;
            t.func_78374_a(1.0, (double)f7, 0.0, (double)u0, (double)f8);
            t.func_78374_a(0.0, (double)f7, 0.0, (double)u1, (double)f8);
            t.func_78374_a(0.0, (double)f7, (double)(0.0f - p_78439_7_), (double)u1, (double)f8);
            t.func_78374_a(1.0, (double)f7, (double)(0.0f - p_78439_7_), (double)u0, (double)f8);
        }
        t.func_78381_a();
    }

    private void setColorMultiplier(int color) {
        this.cmr = (float)(color >> 16 & 0xFF) / 255.0f;
        this.cmg = (float)(color >> 8 & 0xFF) / 255.0f;
        this.cmb = (float)(color & 0xFF) / 255.0f;
    }

    private void setUpTextureOverride(RenderBlocks rb) {
        IIcon icon;
        this.textureOverridden = false;
        if (rb != null && (icon = rb.field_147840_d) != null) {
            this.useIcon(icon);
            this.textureOverridden = true;
        }
    }

    private void selectTile(IIcon icon) {
        if (!this.textureOverridden) {
            this.useIcon(icon);
        }
        this.us = (this.u1 - this.u0) / 16.0;
        this.vs = (this.v1 - this.v0) / 16.0;
    }

    private void useIcon(IIcon icon) {
        this.u0 = icon.func_94209_e();
        this.v0 = icon.func_94206_g();
        this.u1 = icon.func_94212_f();
        this.v1 = icon.func_94210_h();
    }

    protected void renderCube(Tessellator tess, Trans3 t, IBlockAccess world, Block block, int x, int y, int z, int data, int brightness) {
        for (int i = 0; i < 6; ++i) {
            this.selectTile(block.func_149691_a(i, data));
            if (world != null) {
                ForgeDirection d = ForgeDirection.getOrientation((int)i);
                Vector3 p = t.p(d.offsetX, d.offsetY, d.offsetZ);
                tess.func_78380_c(block.func_149677_c(world, p.fx(), p.fy(), p.fz()));
            } else {
                tess.func_78380_c(brightness);
            }
            this.cubeFace(tess, t.translate(0.5, 0.5, 0.5), cubeMap[i]);
        }
    }

    private void setNormal(Tessellator tess, Trans3 t, double nx, double ny, double nz, double shade) {
        Vector3 n = t.v(nx, ny, nz);
        float bm = (float)(shade * (0.6 * n.x * n.x + 0.8 * n.z * n.z + (n.y > 0.0 ? 1.0 : 0.5) * n.y * n.y));
        tess.func_78375_b((float)n.x, (float)n.y, (float)n.z);
        tess.func_78386_a(bm * this.cmr, bm * this.cmg, bm * this.cmb);
    }

    private void cubeFace(Tessellator tess, Trans3 t, double[] c) {
        this.setNormal(tess, t, c[9], c[10], c[11], 1.0);
        this.face(tess, t, c[0], c[1], c[2], c[3], c[4], c[5], c[6], c[7], c[8], 0.0, 0.0, 16.0, 16.0);
    }

    private void face(Tessellator tess, Trans3 t, double x, double y, double z, double dx1, double dy1, double dz1, double dx2, double dy2, double dz2, double u, double v, double du, double dv) {
        this.vertex(tess, t, x, y, z, u, v);
        this.vertex(tess, t, x + dx1, y + dy1, z + dz1, u, v + dv);
        this.vertex(tess, t, x + dx1 + dx2, y + dy1 + dy2, z + dz1 + dz2, u + du, v + dv);
        this.vertex(tess, t, x + dx2, y + dy2, z + dz2, u + du, v);
    }

    private void vertex(Tessellator tess, Trans3 t, double x, double y, double z, double u, double v) {
        Vector3 p = t.p(x, y, z);
        tess.func_78374_a(p.x, p.y, p.z, this.u0 + u * this.us, this.v0 + v * this.vs);
    }
}

