/*
 * Decompiled with CFR 0.152.
 */
package lc.common.base;

import lc.api.event.IBlockEventHandler;
import lc.api.rendering.IBlockRenderInfo;
import lc.api.rendering.IEntityRenderInfo;
import lc.api.rendering.IRenderInfo;
import lc.api.rendering.ITileRenderInfo;
import lc.common.LCLog;
import lc.common.base.LCTile;
import lc.common.configuration.IConfigure;
import lc.common.util.java.MethodInvocationResolver;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class LCBlock
extends BlockContainer
implements IRenderInfo,
IConfigure {
    protected static final ForgeDirection[] directions = new ForgeDirection[]{ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.EAST};
    protected boolean isOpaque = false;
    protected boolean isTyped = false;
    protected boolean hasInventory = false;
    protected boolean canRotate = false;
    protected Class<? extends LCTile> tileType;
    protected int rendererIdx = 0;

    public LCBlock(Material material) {
        super(material);
    }

    public LCBlock setOpaque(boolean b) {
        this.isOpaque = b;
        return this;
    }

    public LCBlock setRenderer(int i) {
        this.rendererIdx = i;
        return this;
    }

    public void setProvidesTile(Class<? extends LCTile> tile) {
        this.tileType = tile;
    }

    public Class<? extends LCTile> getTileType() {
        return this.tileType;
    }

    public LCBlock setProvidesInventory(boolean b) {
        this.hasInventory = b;
        return this;
    }

    public LCBlock setCanRotate(boolean b) {
        this.canRotate = b;
        return this;
    }

    public LCBlock setProvidesTypes(boolean b) {
        this.isTyped = b;
        return this;
    }

    public boolean canRotate() {
        return this.canRotate;
    }

    public ForgeDirection getRotation(IBlockAccess world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof LCTile)) {
            return null;
        }
        return ((LCTile)tile).getRotation();
    }

    public void setRotation(World world, int x, int y, int z, ForgeDirection direction) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof LCTile)) {
            return;
        }
        ((LCTile)tile).setRotation(direction);
    }

    public final boolean func_149662_c() {
        return this.isOpaque;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        TileEntity t;
        boolean def = super.isSideSolid(world, x, y, z, side);
        if (this.tileType != null && (t = world.func_147438_o(x, y, z)) instanceof LCTile) {
            String[] klasses = MethodInvocationResolver.getCallerClassNames(0);
            Object[] map = new Object[]{def, klasses};
            LCTile.doCallbacksNow(t, "isSideSolid", new Object[]{map});
            return (Boolean)map[0];
        }
        return def;
    }

    public boolean func_149686_d() {
        return this.isOpaque;
    }

    public int func_149645_b() {
        return this.rendererIdx;
    }

    public final TileEntity func_149915_a(World world, int data) {
        if (this.tileType != null) {
            try {
                return this.tileType.newInstance();
            }
            catch (Throwable t) {
                LCLog.fatal("Couldn't create new instance of tile type.", t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException("Couldn't create new instance of tile type.", t);
            }
        }
        return null;
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase player, ItemStack stack) {
        super.func_149689_a(world, x, y, z, player, stack);
        if (this.canRotate() && !world.field_72995_K) {
            int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
            this.setRotation(world, x, y, z, directions[heading]);
            world.func_147471_g(x, y, z);
        }
    }

    public void func_149726_b(World world, int x, int y, int z) {
        TileEntity tile;
        super.func_149726_b(world, x, y, z);
        if (this.tileType != null && (tile = world.func_147438_o(x, y, z)) instanceof IBlockEventHandler) {
            ((IBlockEventHandler)tile).blockPlaced();
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block a, int b) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof IBlockEventHandler) {
            ((IBlockEventHandler)tile).blockBroken();
        }
        super.func_149749_a(world, x, y, z, a, b);
    }

    public void func_149695_a(World world, int x, int y, int z, Block b) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof IBlockEventHandler) {
            ((IBlockEventHandler)tile).neighborChanged();
        }
        super.func_149695_a(world, x, y, z, b);
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof LCTile)) {
            return false;
        }
        return ((LCTile)tile).canConnectRedstone(side);
    }

    public int func_149748_c(IBlockAccess world, int x, int y, int z, int side) {
        return this.func_149709_b(world, x, y, z, side);
    }

    public int func_149709_b(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile == null || !(tile instanceof LCTile)) {
            return 0;
        }
        return ((LCTile)tile).getRedstoneOutput(side);
    }

    public boolean isGettingInput(World world, int x, int y, int z, ForgeDirection side) {
        return this.getInputStrength(world, x, y, z, side) > 0;
    }

    public boolean isGettingAnyInput(World world, int x, int y, int z) {
        return this.getBestInputStrength(world, x, y, z) > 0;
    }

    public int getBestInputStrength(World world, int x, int y, int z) {
        int best = 0;
        for (ForgeDirection side : ForgeDirection.values()) {
            best = Math.max(best, this.getInputStrength(world, x, y, z, side));
        }
        return best;
    }

    public int getInputStrength(World world, int x, int y, int z, ForgeDirection side) {
        int dx = x + side.offsetX;
        int dy = y + side.offsetY;
        int dz = z + side.offsetZ;
        int l1 = world.func_72878_l(dx, dy, dz, side.getOpposite().ordinal());
        int l2 = world.func_147439_a(dx, dy, dz) == Blocks.field_150488_af ? world.func_72805_g(dx, dy, dz) : 0;
        int l3 = world.func_147439_a(dx, dy, dz) == Blocks.field_150429_aA ? 15 : 0;
        return Math.max(l1, Math.max(l2, l3));
    }

    @Override
    public IBlockRenderInfo renderInfoBlock() {
        return null;
    }

    @Override
    public ITileRenderInfo renderInfoTile() {
        return null;
    }

    @Override
    public IEntityRenderInfo renderInfoEntity() {
        return null;
    }
}

