/*
 * Decompiled with CFR 0.152.
 */
package lc.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import lc.BuildInfo;
import lc.api.jit.AnyPredicate;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class LCLog {
    private static volatile Logger log;
    private static volatile PrintStream printLog;
    private static volatile Logger cmLog;
    private static volatile PrintStream cmPrintLog;

    public static void initPrintLoggers() throws FileNotFoundException {
        File logDir = new File("./logs/lanteacraft/");
        if (!logDir.exists()) {
            logDir.mkdir();
        }
        printLog = new PrintStream(new File("./logs/lanteacraft/game.log"));
        cmPrintLog = new PrintStream(new File("./logs/lanteacraft/core.log"));
    }

    public static void setLogger(Logger log) {
        LCLog.log = log;
    }

    public static void setCoremodLogger(Logger log) {
        cmLog = log;
    }

    private static boolean isCore() {
        StackTraceElement[] trackback;
        for (StackTraceElement element : trackback = Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().startsWith("lc.coremod")) continue;
            return true;
        }
        return false;
    }

    private static void push(Level level, Object[] args) {
        Logger log = LCLog.log;
        PrintStream stream = printLog;
        if (LCLog.isCore() || LCLog.log == null) {
            log = cmLog;
            stream = cmPrintLog;
        }
        if (args.length == 1) {
            if (args[0] instanceof Throwable) {
                LCLog.writeAll(log, stream, level, "Uncaught exception, no reason given.", (Throwable)args[0]);
            } else {
                LCLog.writeAll(log, stream, level, args[0] instanceof String ? (String)args[0] : args[0].toString(), null);
            }
        } else if (args.length == 2 && args[0] instanceof Throwable) {
            LCLog.writeAll(log, stream, level, (String)args[1], (Throwable)args[0]);
        } else if (args.length == 2 && args[1] instanceof Throwable) {
            LCLog.writeAll(log, stream, level, (String)args[0], (Throwable)args[1]);
        } else {
            Object[] format;
            boolean flag = false;
            for (Object arg : args) {
                if (!(arg instanceof Throwable)) continue;
                flag = true;
            }
            if (!flag) {
                format = new Object[args.length - 1];
                System.arraycopy(args, 1, format, 0, format.length);
                LCLog.writeAll(log, stream, level, String.format((String)args[0], format), null);
            } else {
                format = new Object[args.length - 2];
                Throwable t = null;
                int q = 0;
                for (int i = 1; i < args.length; ++i) {
                    if (!(args[i] instanceof Throwable)) {
                        format[q++] = args[i];
                        continue;
                    }
                    t = (Throwable)args[i];
                }
                if (t != null) {
                    LCLog.writeAll(log, stream, level, String.format((String)args[0], format), t);
                } else {
                    LCLog.writeAll(log, stream, level, String.format((String)args[0], format), null);
                }
            }
        }
    }

    private static void writeAll(Logger l, PrintStream s, Level l0, String s0, Throwable z) {
        if (l0 == Level.DEBUG || l0 == Level.TRACE) {
            if (BuildInfo.DEBUG) {
                LCLog.writeLog(l, l0, s0, z);
            }
        } else {
            LCLog.writeLog(l, l0, s0, z);
        }
        LCLog.writeStream(s, l0, s0, z);
    }

    private static void writeLog(Logger l, Level l0, String s0, Throwable z) {
        if (z != null) {
            l.log(l0, s0, z);
        } else {
            l.log(l0, s0);
        }
    }

    private static void writeStream(PrintStream s, Level l0, String s0, Throwable z) {
        StringBuilder blob = new StringBuilder();
        blob.append("[").append(l0).append("] ");
        blob.append(s0);
        if (z != null) {
            blob.append(": ").append(z.getClass()).append(": ").append(z.getMessage());
            StringWriter writer = new StringWriter();
            z.printStackTrace(new PrintWriter(writer));
            s.println(blob.toString());
            s.println(writer.toString());
        } else {
            s.println(blob.toString());
        }
    }

    public static void fatal(Object ... args) {
        LCLog.push(Level.FATAL, args);
    }

    public static void warn(Object ... args) {
        LCLog.push(Level.WARN, args);
    }

    public static void info(Object ... args) {
        LCLog.push(Level.INFO, args);
    }

    public static void debug(Object ... args) {
        LCLog.push(BuildInfo.DEBUG_MASQ ? Level.INFO : Level.DEBUG, args);
    }

    public static void trace(Object ... args) {
        LCLog.push(BuildInfo.DEBUG_MASQ ? Level.INFO : Level.TRACE, args);
    }

    public static void showRuntimeInfo() {
        LCLog.info("Hello, I'm LanteaCraft build %s version %s (debug: %s).", BuildInfo.$.build(), "1.0.0", BuildInfo.DEBUG);
        if (BuildInfo.DEBUG) {
            LCLog.info("Debugging is ON (log masquerading: %s).", BuildInfo.DEBUG_MASQ);
        }
    }

    public static void doAssert(boolean condition, Object ... params) {
        if (!condition) {
            LCLog.fatal(params);
            throw new Error("A proxied assertion error in LanteaCraft occurred.");
        }
    }

    public static void doPredicateAssert(AnyPredicate dictate, Object[] conditions, Object ... params) {
        try {
            if (!dictate.test(conditions)) {
                LCLog.fatal(params);
                throw new Error("A proxied assertion error in LanteaCraft occurred.");
            }
        }
        catch (Exception e) {
            LCLog.fatal(params);
            throw new Error("A proxied assertion error in LanteaCraft occurred.");
        }
    }

    public static void doSoftAssert(boolean condition, Object ... params) {
        if (!condition) {
            LCLog.warn(params);
        }
    }

    public static void doSoftPredicateAssert(AnyPredicate dictate, Object[] conditions, Object ... params) {
        try {
            if (!dictate.test(conditions)) {
                LCLog.warn(params);
            }
        }
        catch (Exception e) {
            LCLog.warn(params);
        }
    }
}

