/*
 * Decompiled with CFR 0.152.
 */
package lc.client.render.gfx.beam;

import lc.client.opengl.LCEntityFX;
import lc.common.resource.ResourceAccess;
import lc.common.util.math.Vector3;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class GFXBeam
extends LCEntityFX {
    private Object from;
    private Object to;
    private Vector3 origin;
    private Vector3 destination;
    private int fins;
    private float scale;

    public GFXBeam(World world, Object src, Object dst, boolean solid, float alpha, int maxAge, int maxFins, float beamScale) {
        super(world, 0.0, 0.0, 0.0);
        this.from = src;
        this.origin = this.resolvePosition(this.from);
        this.to = dst;
        this.destination = this.resolvePosition(this.to);
        this.field_70551_j = 1.0f;
        this.field_70553_i = 1.0f;
        this.field_70552_h = 1.0f;
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.field_70545_g = 0.0f;
        this.field_82339_as = alpha;
        this.field_70544_f = 1.0f;
        this.field_70547_e = maxAge;
        this.field_70145_X = false;
        this.scale = beamScale;
        this.fins = maxFins;
        this.func_70105_a(0.01f, 0.01f);
    }

    @Override
    public ResourceLocation getTextureForRender() {
        return ResourceAccess.getNamedResource("textures/fx/beam/beam.png");
    }

    public void func_70539_a(Tessellator tessellator, float frame, float rotX, float rotXZ, float rotZ, float rotYZ, float rotXY) {
        tessellator.func_78381_a();
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.field_82339_as);
        this.destination = this.resolvePosition(this.to);
        Vector3 brx = this.destination.sub(this.origin);
        float length = (float)brx.mag();
        GL11.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
        GL11.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        GL11.glDisable((int)2884);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glDepthMask((boolean)false);
        float ux = (float)(this.field_70169_q + (this.field_70165_t - this.field_70169_q) * (double)frame - EntityFX.field_70556_an);
        float uy = (float)(this.field_70167_r + (this.field_70163_u - this.field_70167_r) * (double)frame - EntityFX.field_70554_ao);
        float uz = (float)(this.field_70166_s + (this.field_70161_v - this.field_70166_s) * (double)frame - EntityFX.field_70555_ap);
        GL11.glTranslated((double)ux, (double)uy, (double)uz);
        double var44 = -0.15 * (double)this.scale;
        double var17 = 0.15 * (double)this.scale;
        double vdxdz = MathHelper.func_76133_a((double)(brx.x * brx.x + brx.z * brx.z));
        float rotYaw = (float)(Math.atan2(brx.x, brx.z) * 180.0 / Math.PI);
        float rotPitch = (float)(Math.atan2(brx.y, vdxdz) * 180.0 / Math.PI);
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)rotYaw, (float)0.0f, (float)0.0f, (float)-1.0f);
        GL11.glRotatef((float)(-rotPitch), (float)1.0f, (float)0.0f, (float)0.0f);
        for (int t = 0; t < this.fins; ++t) {
            GL11.glRotatef((float)(180.0f / (float)this.fins), (float)0.0f, (float)1.0f, (float)0.0f);
            tessellator.func_78382_b();
            tessellator.func_78380_c(200);
            tessellator.func_78369_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, 1.0f);
            tessellator.func_78374_a(var44, var44, 0.0, 0.0, 0.0);
            tessellator.func_78374_a(var44, var17 + (double)length, 0.0, 0.0, (double)length);
            tessellator.func_78374_a(var17, var17 + (double)length, 0.0, (double)length, (double)length);
            tessellator.func_78374_a(var17, var44, 0.0, (double)length, 0.0);
            tessellator.func_78381_a();
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)true);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        GL11.glPopMatrix();
        tessellator.func_78382_b();
    }

    public int func_70537_b() {
        return 2;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_70106_y();
        }
        this.origin = this.resolvePosition(this.from);
        this.field_70169_q = this.field_70165_t = this.origin.x;
        this.field_70167_r = this.field_70163_u = this.origin.y;
        this.field_70166_s = this.field_70161_v = this.origin.z;
    }

    private Vector3 resolvePosition(Object zz) {
        if (zz == null) {
            throw new IllegalArgumentException("Can't trace null positional object.");
        }
        if (zz instanceof TileEntity) {
            return new Vector3((TileEntity)zz).add(0.5, 0.5, 0.5);
        }
        if (zz instanceof Entity) {
            Entity ee = (Entity)zz;
            return new Vector3(ee).add(ee.field_70130_N, ee.field_70131_O, ee.field_70130_N);
        }
        if (zz instanceof Vector3) {
            return (Vector3)zz;
        }
        throw new IllegalArgumentException("Unknown or unsupported tracer: " + zz.getClass().getName());
    }
}

