/*
 * Decompiled with CFR 0.152.
 */
package lc.client.render.fabs.tiles;

import lc.api.stargate.StargateType;
import lc.client.animation.Animation;
import lc.client.models.ModelStargate;
import lc.common.base.LCTile;
import lc.common.base.LCTileRenderer;
import lc.common.base.multiblock.MultiblockState;
import lc.common.base.pipeline.LCTileRenderPipeline;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.resource.ResourceAccess;
import lc.common.resource.ResourceMap;
import lc.common.util.data.StateMap;
import lc.tiles.TileStargateBase;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileStargateBaseRenderer
extends LCTileRenderer {
    public final ResourceMap resources = new ResourceMap();
    public final ResourceLocation fxHorizon = ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/fx/eventhorizon_${TEX_QUALITY}.png", new Object[0]));
    public static final int ehGridRadialSize = 10;
    public static final int irBladeSize = 32;
    public static final int ehGridPolarSize = 38;
    public static final double ehBandWidth = 0.275;
    public final ModelStargate model;

    public TileStargateBaseRenderer() {
        for (StargateType type : StargateType.values()) {
            String suffix = type.getSuffix() != null && type.getSuffix().length() > 0 ? "_" + type.getSuffix() + "_${TEX_QUALITY}.png" : "_${TEX_QUALITY}.png";
            ResourceLocation fr = ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/tileentity/stargate" + suffix, new Object[0]));
            ResourceLocation gl = ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/tileentity/stargate_glyphs" + suffix, new Object[0]));
            ResourceMap map = new ResourceMap();
            map.add("frame", fr).add("glyphs", gl);
            this.resources.add(type.getName(), map);
        }
        this.model = new ModelStargate();
        this.model.init();
    }

    @Override
    public void configure(ComponentConfig c) {
    }

    @Override
    public LCTileRenderer getParent() {
        return null;
    }

    @Override
    public boolean renderTileEntityAt(LCTile tile, LCTileRenderPipeline renderer, double x, double y, double z, float partialTickTime) {
        TileStargateBase base;
        if (tile instanceof TileStargateBase && (base = (TileStargateBase)tile).getState() == MultiblockState.FORMED) {
            Double frame;
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 3.5), (double)(z + 0.5));
            StateMap state = base.renderInfoTile().tileRenderState();
            Animation animation = (Animation)base.renderInfoTile().tileAnimation();
            if (animation != null && !animation.finished(frame = Double.valueOf(base.renderInfoTile().tileAnimationProgress() + (double)partialTickTime))) {
                animation.sampleProperties(state, frame);
            }
            this.model.render(this, renderer, base, state);
            if (state.get("iris", false).booleanValue()) {
                if (state.get("iris-type", "mechanical").equals("mechanical")) {
                    this.renderMechIrisImmediate(base, renderer, state, x, y, z, partialTickTime);
                } else {
                    this.renderGhostIrisImmediate(base, renderer, state, x, y, z, partialTickTime);
                }
            }
            if (state.get("event-horizon", false).booleanValue()) {
                this.renderGfxHorizonImmediate(base, renderer, state, x, y, z);
            }
            GL11.glPopMatrix();
        }
        return true;
    }

    private void renderMechIrisImmediate(TileStargateBase tile, LCTileRenderPipeline pipeline, StateMap state, double x, double y, double z, float t) {
        double progress = 1.0 - state.get("iris-progress", 0.0);
        for (int i = 0; i < 32; ++i) {
            GL11.glPushMatrix();
            GL11.glRotated((double)(360.0 * (double)i / 32.0), (double)0.0, (double)0.0, (double)1.0);
            double tiltAngle = progress * 60.0;
            double radius = 3.2;
            double longW = 3.2;
            double shortW = 2.75;
            double heightZ = 0.2;
            double heightQ = 1.0;
            double length = heightQ - (heightQ - heightZ) * progress * progress;
            double u0 = shortW / longW;
            double v0 = length / heightQ;
            double v1 = heightZ / heightQ;
            double depth0 = 0.05;
            double depth1 = 0.01;
            GL11.glTranslated((double)radius, (double)0.0, (double)0.0);
            GL11.glRotated((double)(-tiltAngle), (double)0.0, (double)0.0, (double)1.0);
            GL11.glBegin((int)6);
            GL11.glTexCoord2d((double)0.0, (double)0.0);
            GL11.glVertex3d((double)(-longW), (double)0.0, (double)depth0);
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)(depth0 + depth1));
            GL11.glTexCoord2d((double)1.0, (double)v1);
            GL11.glVertex3d((double)0.0, (double)heightZ, (double)(depth0 + depth1));
            GL11.glTexCoord2d((double)u0, (double)v0);
            GL11.glVertex3d((double)(-longW + shortW), (double)length, (double)depth0);
            GL11.glTexCoord2d((double)0.0, (double)v0);
            GL11.glVertex3d((double)(-longW), (double)length, (double)depth0);
            GL11.glEnd();
            GL11.glBegin((int)6);
            GL11.glTexCoord2d((double)0.0, (double)0.0);
            GL11.glVertex3d((double)(-longW), (double)0.0, (double)depth0);
            GL11.glTexCoord2d((double)0.0, (double)v0);
            GL11.glVertex3d((double)(-longW), (double)length, (double)depth0);
            GL11.glTexCoord2d((double)u0, (double)v0);
            GL11.glVertex3d((double)(-longW + shortW), (double)length, (double)depth0);
            GL11.glTexCoord2d((double)1.0, (double)v1);
            GL11.glVertex3d((double)0.0, (double)heightZ, (double)(depth0 - depth1));
            GL11.glTexCoord2d((double)1.0, (double)0.0);
            GL11.glVertex3d((double)0.0, (double)0.0, (double)(depth0 - depth1));
            GL11.glEnd();
            GL11.glPopMatrix();
        }
    }

    private void renderGhostIrisImmediate(TileStargateBase tile, LCTileRenderPipeline pipeline, StateMap state, double x, double y, double z, float t) {
    }

    private void renderGfxHorizonImmediate(TileStargateBase tile, LCTileRenderPipeline pipeline, StateMap state, double x, double y, double z) {
        pipeline.bind(this.fxHorizon);
        GL11.glDisable((int)2884);
        GL11.glNormal3d((double)0.0, (double)0.0, (double)1.0);
        double[][] grid = tile.getGfxGrid()[0];
        for (int i = 1; i < 10; ++i) {
            GL11.glBegin((int)8);
            for (int j = 0; j <= 38; ++j) {
                this.eventHVertex(state, grid, i, j);
                this.eventHVertex(state, grid, i + 1, j);
            }
            GL11.glEnd();
        }
        GL11.glBegin((int)6);
        GL11.glTexCoord2d((double)0.5, (double)0.5);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)grid[1][0]);
        for (int j = 0; j <= 38; ++j) {
            this.eventHVertex(state, grid, 1, j);
        }
        GL11.glEnd();
        GL11.glEnable((int)2884);
    }

    private void eventHVertex(StateMap state, double[][] grid, int i, int j) {
        double r = (double)i * 2.75 / 10.0;
        double x = r * ModelStargate.cos[j];
        double y = r * ModelStargate.sin[j];
        double u = (x + 3.0) / 6.0;
        double v = (y + 3.0) / 6.0;
        GL11.glTexCoord2d((double)u, (double)v);
        if (state.get("iris", false).booleanValue()) {
            GL11.glVertex3d((double)x, (double)y, (double)Math.min(grid[j + 1][i], 0.035));
        } else {
            GL11.glVertex3d((double)x, (double)y, (double)grid[j + 1][i]);
        }
    }
}

