/*
 * Decompiled with CFR 0.152.
 */
package lc.client.render.fabs.tiles;

import lc.common.base.LCTile;
import lc.common.base.LCTileRenderer;
import lc.common.base.pipeline.LCTileRenderPipeline;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.resource.ResourceAccess;
import lc.common.util.math.Orientations;
import lc.tiles.TileLanteaDoor;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TileDoorRenderer
extends LCTileRenderer {
    @Override
    public void configure(ComponentConfig c) {
    }

    @Override
    public LCTileRenderer getParent() {
        return null;
    }

    @Override
    public boolean renderTileEntityAt(LCTile tile, LCTileRenderPipeline renderer, double x, double y, double z, float partialTickTime) {
        TileLanteaDoor door = (TileLanteaDoor)tile;
        String doorType = door.func_145832_p() != 0 ? "goauld" : "lantean";
        ResourceLocation whatTex = ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/blocks/%s_door_bottom_${TEX_QUALITY}.png", doorType));
        if (!door.hasBlockAbove()) {
            whatTex = ResourceAccess.getNamedResource(ResourceAccess.formatResourceName("textures/blocks/%s_door_top_${TEX_QUALITY}.png", doorType));
        }
        renderer.bind(whatTex);
        GL11.glPushMatrix();
        GL11.glTranslated((double)x, (double)y, (double)z);
        GL11.glDisable((int)2896);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        float frame = door.clientAnimation;
        float w = 0.085f;
        float d0 = 0.5f - w;
        float d1 = 0.5f + w;
        GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
        GL11.glRotatef((float)Orientations.from(tile.getRotation()).angle(), (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
        float dt = 20.0f - frame;
        float angle = 4.5f * dt;
        GL11.glTranslatef((float)0.2f, (float)0.5f, (float)0.5f);
        if (!door.getDoorState()) {
            angle = 90.0f - angle;
        }
        GL11.glRotatef((float)angle, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glTranslatef((float)-0.2f, (float)-0.5f, (float)-0.5f);
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)d0);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)d0);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)d0);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)d0);
        GL11.glTexCoord2f((float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)d1);
        GL11.glTexCoord2f((float)1.0f, (float)1.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)d1);
        GL11.glTexCoord2f((float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)d1);
        GL11.glTexCoord2f((float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)d1);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)d0);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)d0);
        GL11.glVertex3f((float)1.0f, (float)1.0f, (float)d1);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)d1);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)d0);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)d1);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)d1);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)d0);
        if (!door.hasBlockAbove()) {
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)d0);
            GL11.glVertex3f((float)0.0f, (float)1.0f, (float)d1);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)d1);
            GL11.glVertex3f((float)1.0f, (float)1.0f, (float)d0);
        }
        if (!door.hasBlockBelow()) {
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)d0);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)d0);
            GL11.glVertex3f((float)1.0f, (float)0.0f, (float)d1);
            GL11.glVertex3f((float)0.0f, (float)0.0f, (float)d1);
        }
        GL11.glEnd();
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        return true;
    }
}

