/*
 * Decompiled with CFR 0.152.
 */
package lc.client.render.fabs;

import java.util.ArrayList;
import lc.client.models.ModelError;
import lc.client.models.loader.WavefrontModel;
import lc.client.opengl.BufferDisplayList;
import lc.common.LCLog;
import lc.common.base.LCTile;
import lc.common.base.LCTileRenderer;
import lc.common.base.pipeline.LCTileRenderPipeline;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.resource.ResourceAccess;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class DefaultTileRenderer
extends LCTileRenderer {
    private ModelError model;
    private final BufferDisplayList listModel = new BufferDisplayList();
    private ArrayList<Class<? extends LCTile>> seenTypes;

    @Override
    public void configure(ComponentConfig c) {
    }

    public DefaultTileRenderer() {
        try {
            this.model = new ModelError(ResourceAccess.getNamedResource("models/error.obj"));
            this.listModel.init();
            this.listModel.enter();
            this.model.renderAll();
            this.listModel.exit();
        }
        catch (WavefrontModel.WavefrontModelException e) {
            e.printStackTrace();
        }
        this.seenTypes = new ArrayList();
    }

    @Override
    public LCTileRenderer getParent() {
        return null;
    }

    @Override
    public boolean renderTileEntityAt(LCTile tile, LCTileRenderPipeline renderer, double x, double y, double z, float partialTickTime) {
        if (!this.seenTypes.contains(tile.getClass())) {
            Class<?> clazz = tile.getClass();
            this.seenTypes.add(clazz);
            LCLog.warn("Tile class %s fed to default renderer, check implementation!", clazz.getName());
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        float a0 = (180.0f - Minecraft.func_71410_x().field_71439_g.field_70177_z) % 360.0f;
        float a1 = -Minecraft.func_71410_x().field_71439_g.field_70125_A % 360.0f;
        GL11.glTranslated((double)(x + 0.5), (double)y, (double)(z + 0.5));
        GL11.glTranslated((double)0.0, (double)0.5, (double)0.0);
        GL11.glRotatef((float)a0, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)a1, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
        GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
        this.listModel.bind(new Object[0]);
        this.listModel.release();
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
        return true;
    }
}

