/*
 * Decompiled with CFR 0.152.
 */
package lc.client.render.fabs;

import lc.api.defs.IDefinitionReference;
import lc.api.rendering.IBlockRenderInfo;
import lc.api.rendering.IBlockSkinnable;
import lc.api.rendering.IRenderInfo;
import lc.common.base.LCBlock;
import lc.common.base.LCBlockRenderer;
import lc.common.base.LCTile;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.impl.registry.DefinitionReference;
import lc.common.util.game.BlockContainerProxy;
import lc.common.util.game.WorldProxy;
import lc.common.util.math.Trans3;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class DefaultBlockRenderer
extends LCBlockRenderer {
    protected static int[] rotationMap = new int[]{0, 0, 0, 2, 1, 3};

    @Override
    public void configure(ComponentConfig c) {
    }

    @Override
    public Class<? extends LCBlockRenderer> getParent() {
        return null;
    }

    @Override
    public boolean renderInventoryBlock(Block block, RenderBlocks renderer, int metadata) {
        if (!(block instanceof LCBlock)) {
            return false;
        }
        LCBlock theBlock = (LCBlock)block;
        IBlockRenderInfo info = null;
        if (theBlock instanceof IRenderInfo) {
            info = theBlock.renderInfoBlock();
        }
        Trans3 trans = new Trans3(0.0, 0.0, 0.0);
        trans = this.preRenderInInventory(theBlock, info, metadata, renderer, trans);
        if (info == null || info.doInventoryRender(metadata)) {
            this.renderDefaultInventoryBlock(block, metadata, trans, renderer);
        }
        boolean flag = this.postRenderInInventory(theBlock, info, metadata, renderer);
        return flag;
    }

    @Override
    public boolean renderWorldBlock(Block block, RenderBlocks renderer, IBlockAccess world, int x, int y, int z) {
        if (!(block instanceof LCBlock)) {
            return false;
        }
        LCBlock theBlock = (LCBlock)block;
        IBlockRenderInfo info = null;
        if (theBlock instanceof IRenderInfo) {
            info = theBlock.renderInfoBlock();
        }
        Trans3 trans = new Trans3(x, y, (double)z);
        trans = this.preRenderInWorld(theBlock, info, world, renderer, trans, x, y, z);
        boolean flag = true;
        if (info == null || info.doWorldRender(world, world.func_72805_g(x, y, z), x, y, z)) {
            LCTile tile = (LCTile)world.func_147438_o(x, y, z);
            if (tile != null && tile instanceof IBlockSkinnable && ((IBlockSkinnable)((Object)tile)).getSkinBlock() != null) {
                IBlockSkinnable skin = (IBlockSkinnable)((Object)tile);
                Block skinBlock = skin.getSkinBlock();
                int skinBlockMetadata = skin.getSkinBlockMetadata();
                RenderBlocks proxyRender = new RenderBlocks((IBlockAccess)new WorldProxy(world, skinBlockMetadata));
                proxyRender.func_147775_a(block);
                if (skinBlockMetadata != 0) {
                    BlockContainerProxy proxyContainer = null;
                    for (int i = 0; i < 6; ++i) {
                        proxyRender.func_147757_a(skinBlock.func_149691_a(i, skinBlockMetadata));
                        proxyContainer = new BlockContainerProxy(skinBlock, i);
                        flag = proxyRender.func_147784_q((Block)proxyContainer, x, y, z);
                    }
                } else {
                    flag = proxyRender.func_147784_q(skinBlock, x, y, z);
                }
                proxyRender.func_147771_a();
            } else if (info == null || info.doProperty("noRender", world, world.func_72805_g(x, y, z), x, y, z, true)) {
                flag = this.renderDefaultWorldBlock(world, x, y, z, block, trans, renderer);
            }
        }
        flag = this.postRenderInWorld(theBlock, info, world, renderer, flag, x, y, z);
        return flag;
    }

    @Override
    public boolean renderInventoryItemAs3d() {
        return true;
    }

    private Trans3 preRenderInWorld(LCBlock block, IBlockRenderInfo info, IBlockAccess world, RenderBlocks renderer, Trans3 trans, int x, int y, int z) {
        if (block.canRotate()) {
            ForgeDirection rotation = block.getRotation(world, x, y, z);
            trans = trans.side(0).translate(0.5, 0.5, 0.5);
            trans = trans.turn(rotationMap[rotation.ordinal()]);
            trans = trans.translate(-0.5, -0.5, -0.5);
        }
        return trans;
    }

    private boolean postRenderInWorld(LCBlock block, IBlockRenderInfo info, IBlockAccess world, RenderBlocks renderer, boolean flag, int x, int y, int z) {
        renderer.field_147873_r = 0;
        renderer.field_147867_u = 0;
        renderer.field_147871_s = 0;
        renderer.field_147869_t = 0;
        renderer.field_147875_q = 0;
        renderer.field_147865_v = 0;
        return flag;
    }

    private Trans3 preRenderInInventory(LCBlock theBlock, IBlockRenderInfo info, int metadata, RenderBlocks renderer, Trans3 trans) {
        return trans;
    }

    private boolean postRenderInInventory(LCBlock theBlock, IBlockRenderInfo info, int metadata, RenderBlocks renderer) {
        return true;
    }

    @Override
    public IDefinitionReference ref() {
        return new DefinitionReference(this);
    }
}

