/*
 * Decompiled with CFR 0.152.
 */
package lc.client.render.fabs;

import lc.LCRuntime;
import lc.client.render.fabs.DefaultBlockRenderer;
import lc.common.LCLog;
import lc.common.base.LCBlock;
import lc.common.base.LCTile;
import lc.common.base.LCTileRenderer;
import lc.common.base.pipeline.LCTileRenderPipeline;
import lc.common.configuration.xml.ComponentConfig;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class DebugLayerTileRenderer
extends LCTileRenderer {
    private static double[] blockTurnRotations = new double[]{0.0, 90.0, 180.0, -90.0};

    @Override
    public void configure(ComponentConfig c) {
    }

    @Override
    public LCTileRenderer getParent() {
        return null;
    }

    @Override
    public boolean renderTileEntityAt(LCTile tile, LCTileRenderPipeline renderer, double x, double y, double z, float partialTickTime) {
        if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71439_g.field_71071_by == null || Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70460_b == null) {
            return false;
        }
        ItemStack[] wearStack = Minecraft.func_71410_x().field_71439_g.field_71071_by.field_70460_b;
        Item glassesStack = LCRuntime.runtime.items().glasses.getItem();
        boolean flag = false;
        for (int i = 0; i < wearStack.length; ++i) {
            if (wearStack[i] == null || wearStack[i].func_77973_b() == null || !wearStack[i].func_77973_b().equals(glassesStack)) continue;
            flag = true;
        }
        if (!flag) {
            return false;
        }
        GL11.glPushMatrix();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)2896);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
        GL11.glLineWidth((float)1.0f);
        this.batchRenderAxis();
        GL11.glPopMatrix();
        Block ablock = tile.func_145838_q();
        if (ablock instanceof LCBlock) {
            LCBlock target = (LCBlock)ablock;
            AxisAlignedBB box = tile.getRenderBoundingBox();
            AxisAlignedBB clip = target.func_149668_a(tile.func_145831_w(), (int)x, (int)y, (int)z);
            if (clip != null) {
                GL11.glPushMatrix();
                GL11.glLineWidth((float)1.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)771);
                this.batchRenderClipBox(clip, true, x, y, z, tile.func_145831_w().func_72820_D(), 0.5f);
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            } else {
                GL11.glPushMatrix();
                GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
                GL11.glLineWidth((float)1.0f);
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)1, (int)771);
                this.batchRenderClipBox(box, false, x, y, z, tile.func_145831_w().func_72820_D(), 0.2f);
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
            }
            if (target.canRotate()) {
                ForgeDirection facing = tile.getRotation();
                if (facing != null) {
                    int which = DefaultBlockRenderer.rotationMap[facing.ordinal()];
                    GL11.glPushMatrix();
                    GL11.glTranslated((double)x, (double)y, (double)z);
                    GL11.glPushMatrix();
                    GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
                    GL11.glRotated((double)blockTurnRotations[which], (double)0.0, (double)1.0, (double)0.0);
                    GL11.glEnable((int)3042);
                    GL11.glBlendFunc((int)1, (int)771);
                    float delta = 0.05f;
                    this.batchRenderGBox((float)(box.field_72336_d - box.field_72340_a) + delta, (float)(box.field_72337_e - box.field_72338_b) + delta, (float)(box.field_72334_f - box.field_72339_c) + delta, 0.5f);
                    GL11.glDisable((int)3042);
                    GL11.glPopMatrix();
                    GL11.glPopMatrix();
                } else {
                    LCLog.debug("DebugLayerTileRenderer got canRotate block but no getRotation tile!");
                }
            }
        }
        GL11.glEnable((int)3553);
        GL11.glEnable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glPopMatrix();
        return true;
    }

    private void batchRenderClipBox(AxisAlignedBB box, boolean hit, double x, double y, double z, float hl, float opac) {
        float pq = 0.2f + 0.6f * ((1.0f + (float)Math.sin(0.2f * hl)) / 2.0f);
        GL11.glTranslated((double)x, (double)y, (double)z);
        if (hit) {
            GL11.glColor4f((float)1.0f, (float)pq, (float)0.0f, (float)opac);
        } else {
            GL11.glColor4f((float)0.0f, (float)pq, (float)1.0f, (float)opac);
        }
        float delta = 0.002f;
        GL11.glBegin((int)7);
        LCLog.debug("batchRenderClipBox %s %s", hit, box);
        GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72334_f);
        GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72334_f);
        GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72334_f);
        GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72334_f);
        GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72339_c);
        GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72334_f);
        GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72334_f);
        GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72339_c);
        GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72339_c);
        GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72339_c);
        GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72334_f);
        GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72334_f);
        GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72339_c);
        GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72339_c);
        GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72339_c);
        GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72339_c);
        GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72339_c);
        GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72339_c);
        GL11.glVertex3d((double)box.field_72336_d, (double)box.field_72338_b, (double)box.field_72334_f);
        GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72334_f);
        GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72339_c);
        GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72334_f);
        GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72334_f);
        GL11.glVertex3d((double)box.field_72340_a, (double)box.field_72337_e, (double)box.field_72339_c);
        GL11.glEnd();
    }

    private void batchRenderGBox(float w, float h, float d, float opac) {
        float i = w / 2.0f;
        float j = h / 2.0f;
        float k = d / 2.0f;
        GL11.glBegin((int)7);
        GL11.glColor4f((float)0.25f, (float)0.25f, (float)1.0f, (float)opac);
        GL11.glVertex3f((float)(-i), (float)(-j), (float)k);
        GL11.glVertex3f((float)i, (float)(-j), (float)k);
        GL11.glVertex3f((float)i, (float)j, (float)k);
        GL11.glVertex3f((float)(-i), (float)j, (float)k);
        GL11.glColor4f((float)0.25f, (float)1.0f, (float)0.25f, (float)opac);
        GL11.glVertex3f((float)(-i), (float)j, (float)(-k));
        GL11.glVertex3f((float)(-i), (float)j, (float)k);
        GL11.glVertex3f((float)i, (float)j, (float)k);
        GL11.glVertex3f((float)i, (float)j, (float)(-k));
        GL11.glColor4f((float)1.0f, (float)0.25f, (float)0.25f, (float)opac);
        GL11.glVertex3f((float)i, (float)(-j), (float)(-k));
        GL11.glVertex3f((float)i, (float)j, (float)(-k));
        GL11.glVertex3f((float)i, (float)j, (float)k);
        GL11.glVertex3f((float)i, (float)(-j), (float)k);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.33f, (float)opac);
        GL11.glVertex3f((float)(-i), (float)(-j), (float)(-k));
        GL11.glVertex3f((float)(-i), (float)j, (float)(-k));
        GL11.glVertex3f((float)i, (float)j, (float)(-k));
        GL11.glVertex3f((float)i, (float)(-j), (float)(-k));
        GL11.glColor4f((float)0.0f, (float)0.33f, (float)0.0f, (float)opac);
        GL11.glVertex3f((float)(-i), (float)(-j), (float)(-k));
        GL11.glVertex3f((float)i, (float)(-j), (float)(-k));
        GL11.glVertex3f((float)i, (float)(-j), (float)k);
        GL11.glVertex3f((float)(-i), (float)(-j), (float)k);
        GL11.glColor4f((float)0.33f, (float)0.0f, (float)0.0f, (float)opac);
        GL11.glVertex3f((float)(-i), (float)(-j), (float)(-k));
        GL11.glVertex3f((float)(-i), (float)(-j), (float)k);
        GL11.glVertex3f((float)(-i), (float)j, (float)k);
        GL11.glVertex3f((float)(-i), (float)j, (float)(-k));
        GL11.glEnd();
    }

    private void batchRenderAxis() {
        GL11.glBegin((int)1);
        GL11.glColor3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glColor3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glVertex3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glEnd();
    }
}

