/*
 * Decompiled with CFR 0.152.
 */
package lc.client.render.animations;

import lc.LCRuntime;
import lc.client.animation.Animation;
import lc.client.render.gfx.particle.GFXDust;
import lc.common.base.LCTile;
import lc.common.util.data.StateMap;
import lc.common.util.game.RunnableTileCallback;
import lc.common.util.math.Vector3;
import lc.tiles.TileStargateBase;
import net.minecraft.world.World;

public class RingSpinAnimation
extends Animation {
    public RingSpinAnimation(Double duration, Double start, Double end, boolean resample) {
        super(duration, resample, new RunnableTileCallback(){

            @Override
            public void run(LCTile tile) {
                tile.mixer().replayChannel("spin");
                Vector3[] chevrons = ((TileStargateBase)tile).getChevronBlocks();
                World world = tile.func_145831_w();
                for (int i = 0; i < chevrons.length; ++i) {
                    if (world.field_73012_v.nextInt(2) != 1) continue;
                    Vector3 chevron = chevrons[i];
                    GFXDust spark = new GFXDust(world, chevron.x, chevron.y, chevron.z, 0.024f, 0.0f, 0.02f);
                    LCRuntime.runtime.hints().particles().placeParticle(world, (Object)spark);
                }
            }
        }, new RunnableTileCallback(){

            @Override
            public void run(LCTile tile) {
                tile.mixer().stopChannel("spin");
            }
        });
        this.addProperty("ring-rotation", start, end, Animation.InterpolationMode.SIN);
    }

    @Override
    public void resampleProperties(StateMap map) {
        super.resampleProperties(map);
    }
}

