/*
 * Decompiled with CFR 0.152.
 */
package lc.client.opengl;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import lc.LCRuntime;
import lc.api.event.ITickEventHandler;
import lc.api.rendering.IParticleMachine;
import lc.client.opengl.LCEntityFX;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import org.lwjgl.opengl.GL11;

public class ParticleMachine
implements ITickEventHandler,
IParticleMachine {
    private HashMap<Integer, HashMap<Integer, ArrayList<LCEntityFX>>> particles;

    public ParticleMachine() {
        LCRuntime.runtime.ticks().register(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.particles = new HashMap();
        for (int i = 0; i < 4; ++i) {
            this.particles.put(i, new HashMap());
        }
    }

    @Override
    public void placeParticle(World theWorld, Object object) {
        int dimension = theWorld.field_73011_w.field_76574_g;
        if (!(object instanceof LCEntityFX)) {
            throw new IllegalArgumentException("Must provide LCEntityFX decendant.");
        }
        LCEntityFX entity = (LCEntityFX)((Object)object);
        if (!this.particles.get(entity.func_70537_b()).containsKey(dimension)) {
            this.particles.get(entity.func_70537_b()).put(dimension, new ArrayList());
        }
        this.particles.get(entity.func_70537_b()).get(dimension).add(entity);
    }

    @Override
    public void think(Side what) {
        if (what == Side.CLIENT) {
            this.thinkParticles();
        }
    }

    private void thinkParticles() {
        WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
        if (theWorld == null) {
            return;
        }
        int dimension = theWorld.field_73011_w.field_76574_g;
        for (int layer = 0; layer < 4; ++layer) {
            HashMap<Integer, ArrayList<LCEntityFX>> objects = this.particles.get(layer);
            if (!objects.containsKey(dimension)) continue;
            ArrayList<LCEntityFX> entities = objects.get(dimension);
            Iterator<LCEntityFX> iter = entities.iterator();
            while (iter.hasNext()) {
                EntityFX entity = iter.next();
                if (entity != null) {
                    entity.func_70071_h_();
                    if (entity != null && !entity.field_70128_L) continue;
                    iter.remove();
                    continue;
                }
                iter.remove();
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void renderParticles(RenderWorldLastEvent event) {
        float frame = event.partialTicks;
        WorldClient theWorld = Minecraft.func_71410_x().field_71441_e;
        if (theWorld == null) {
            return;
        }
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        int dimension = theWorld.field_73011_w.field_76574_g;
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glAlphaFunc((int)516, (float)0.0044f);
        Tessellator tessellator = Tessellator.field_78398_a;
        TextureManager renderer = Minecraft.func_71410_x().field_71446_o;
        for (int layer = 0; layer < 4; ++layer) {
            ArrayList<LCEntityFX> list;
            HashMap<Integer, ArrayList<LCEntityFX>> objects = this.particles.get(layer);
            if (!objects.containsKey(dimension) || (list = objects.get(dimension)).size() == 0) continue;
            GL11.glPushMatrix();
            switch (layer) {
                case 0: 
                case 2: {
                    GL11.glBlendFunc((int)770, (int)1);
                    break;
                }
                case 1: 
                case 3: {
                    GL11.glBlendFunc((int)770, (int)771);
                }
            }
            for (LCEntityFX entity : list) {
                float f1 = ActiveRenderInfo.field_74588_d;
                float f2 = ActiveRenderInfo.field_74586_f;
                float f3 = ActiveRenderInfo.field_74587_g;
                float f4 = ActiveRenderInfo.field_74596_h;
                float f5 = ActiveRenderInfo.field_74589_e;
                EntityFX.field_70556_an = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)frame;
                EntityFX.field_70554_ao = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)frame;
                EntityFX.field_70555_ap = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)frame;
                tessellator.func_78382_b();
                tessellator.func_78380_c(entity.func_70070_b(frame));
                renderer.func_110577_a(entity.getTextureForRender());
                entity.func_70539_a(tessellator, frame, f1, f5, f2, f3, f4);
                tessellator.func_78381_a();
            }
            GL11.glPopMatrix();
        }
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glAlphaFunc((int)516, (float)0.1f);
        GL11.glPopMatrix();
    }
}

