/*
 * Decompiled with CFR 0.152.
 */
package lc.client.opengl;

import java.nio.ByteBuffer;
import lc.api.rendering.IGraphicsBuffer;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;

public class BufferTexture
implements IGraphicsBuffer {
    private boolean supported = false;
    private boolean assigned = false;
    private boolean entered = false;
    private boolean bound = false;
    private int texture;
    private int fbo;
    private int depth;
    private int width;
    private int height;

    public BufferTexture(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void init() {
        if (this.assigned) {
            throw new RuntimeException("Illegal state: cannot init() while assigned.");
        }
        this.fbo = EXTFramebufferObject.glGenFramebuffersEXT();
        this.texture = GL11.glGenTextures();
        this.depth = EXTFramebufferObject.glGenRenderbuffersEXT();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.fbo);
        GL11.glBindTexture((int)3553, (int)this.texture);
        GL11.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)this.width, (int)this.height, (int)0, (int)6408, (int)5124, (ByteBuffer)null);
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)36160, (int)36064, (int)3553, (int)this.texture, (int)0);
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)this.depth);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)35056, (int)this.width, (int)this.height);
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)36160, (int)33306, (int)36161, (int)this.depth);
        this.buildStateSupported();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        this.assigned = true;
    }

    @Override
    public boolean supported() {
        return this.supported;
    }

    private void buildStateSupported() {
        int state = EXTFramebufferObject.glCheckFramebufferStatusEXT((int)36160);
        switch (state) {
            case 36053: {
                break;
            }
            default: {
                this.supported = false;
            }
        }
    }

    public void resize(int width, int height) {
        if (!this.assigned) {
            throw new RuntimeException("Illegal state: cannot resize() while not assigned.");
        }
        if (this.width == width && this.height == height) {
            return;
        }
        this.width = width;
        this.height = height;
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.fbo);
        GL11.glBindTexture((int)3553, (int)this.texture);
        GL11.glTexImage2D((int)3553, (int)0, (int)32856, (int)width, (int)height, (int)0, (int)6408, (int)5124, (ByteBuffer)null);
        EXTFramebufferObject.glBindRenderbufferEXT((int)36161, (int)this.depth);
        EXTFramebufferObject.glRenderbufferStorageEXT((int)36161, (int)35056, (int)width, (int)height);
        this.buildStateSupported();
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
    }

    @Override
    public void enter() {
        if (this.entered) {
            throw new RuntimeException("Illegal state: cannot enter() while entered.");
        }
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)this.fbo);
        this.entered = true;
    }

    @Override
    public void exit() {
        if (!this.entered) {
            throw new RuntimeException("Illegal state: cannot exit() while exited.");
        }
        EXTFramebufferObject.glBindFramebufferEXT((int)36160, (int)0);
        this.entered = false;
    }

    @Override
    public void bind(Object ... args) {
        if (this.bound) {
            throw new RuntimeException("Illegal state: cannot bind() while bound.");
        }
        GL11.glEnable((int)3553);
        GL11.glBindTexture((int)3553, (int)this.texture);
        this.bound = true;
    }

    @Override
    public void release() {
        if (!this.bound) {
            throw new RuntimeException("Illegal state: cannot release() while released.");
        }
        this.bound = false;
    }

    @Override
    public void delete() {
        if (!this.assigned) {
            throw new RuntimeException("Illegal state: cannot delete() while not assigned.");
        }
        EXTFramebufferObject.glDeleteFramebuffersEXT((int)this.fbo);
        GL11.glDeleteTextures((int)this.texture);
        EXTFramebufferObject.glDeleteRenderbuffersEXT((int)this.depth);
        this.assigned = false;
    }
}

