/*
 * Decompiled with CFR 0.152.
 */
package lc.client.openal;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Vector;
import lc.api.audio.streaming.ISound;
import lc.api.audio.streaming.ISoundPosition;
import lc.api.audio.streaming.ISoundProperties;
import lc.api.audio.streaming.ISoundServer;
import lc.client.openal.StreamingSound;
import lc.common.LCLog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundCategory;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundManager;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraftforge.client.event.sound.SoundLoadEvent;
import net.minecraftforge.common.MinecraftForge;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;

public class StreamingSoundServer
implements ISoundServer {
    private static int sourceCounter = 0;
    private final float falloffDistance = 22.0f;
    private final int maxStreamingSources = 12;
    private boolean enabled = true;
    private int maxSources = 32;
    private float masterVolume = 0.5f;
    private SoundManager manager = null;
    private SoundSystem system = null;
    private volatile Thread initThread;
    private Field soundman_state;
    private HashMap<SoundOwner, ArrayList<ISound>> sounds = new HashMap();

    private static String nextSoundTag(String clazz) {
        if (++sourceCounter > 2048) {
            sourceCounter %= 2048;
        }
        return "lcds_" + clazz + "_" + sourceCounter;
    }

    public StreamingSoundServer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void initialize() {
        int k = 0;
        for (Field field : SoundManager.class.getDeclaredFields()) {
            if (!field.getType().isAssignableFrom(Boolean.TYPE)) continue;
            this.soundman_state = field;
            ++k;
        }
        if (k != 1) {
            this.enabled = false;
            return;
        }
        SoundSystemConfig.setNumberStreamingChannels((int)12);
        SoundSystemConfig.setNumberNormalChannels((int)(this.maxSources - 12));
        this.soundman_state.setAccessible(true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean ready() {
        return this.enabled && this.system != null;
    }

    private static SoundSystem getSoundSystem(SoundManager soundManager) {
        for (Field field : SoundManager.class.getDeclaredFields()) {
            if (!SoundSystem.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                return (SoundSystem)field.get(soundManager);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static SoundManager getSoundManager() {
        SoundHandler handler = Minecraft.func_71410_x().func_147118_V();
        for (Field field : SoundHandler.class.getDeclaredFields()) {
            if (!SoundManager.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                return (SoundManager)field.get(handler);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    @SubscribeEvent
    public void onSoundSetup(SoundLoadEvent event) {
        if (!this.enabled) {
            return;
        }
        this.sounds.clear();
        this.system = null;
        if (this.initThread != null) {
            this.initThread.interrupt();
            try {
                this.initThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        LCLog.debug("StreamingSoundServer starting...");
        this.manager = StreamingSoundServer.getSoundManager();
        this.initThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        boolean loaded = false;
                        try {
                            loaded = StreamingSoundServer.this.soundman_state.getBoolean(StreamingSoundServer.this.manager);
                        }
                        catch (Exception e) {
                            LCLog.fatal("StreamingSoundServer startup error: can't read sound management state.", e);
                            throw new RuntimeException(e);
                        }
                        if (loaded) {
                            StreamingSoundServer.this.system = StreamingSoundServer.getSoundSystem(StreamingSoundServer.this.manager);
                            if (StreamingSoundServer.this.system == null) {
                                LCLog.warn("StreamingSoundServer sound offline: system was marked as ready but can't find it.");
                                StreamingSoundServer.this.enabled = false;
                            } else {
                                LCLog.debug("StreamingSoundServer online.");
                            }
                            break;
                        }
                        Thread.sleep(100L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                StreamingSoundServer.this.initThread = null;
            }
        }, "LanteaCraft-StreamingSoundServer OpenAL fetch task");
        this.initThread.start();
    }

    @Override
    public ISound assign(Object owner, String f, ISoundPosition pos, ISoundProperties props) {
        LCLog.doAssert(owner != null, "No sound owner");
        LCLog.doAssert(f != null, "No sound file specified");
        LCLog.doAssert(pos != null, "No sound position specified");
        LCLog.doAssert(props != null, "No sound properties specified");
        String tag = StreamingSoundServer.nextSoundTag("StreamingSound");
        StreamingSound sound = new StreamingSound(this, this.system, pos, f, props, tag);
        SoundOwner host = new SoundOwner(owner);
        if (!this.sounds.containsKey(host)) {
            this.sounds.put(host, new ArrayList());
        }
        this.sounds.get(host).add(sound);
        return sound;
    }

    @Override
    public float master() {
        return this.masterVolume;
    }

    @Override
    public float falloff() {
        return 22.0f;
    }

    @Override
    public float volume(SoundCategory cat) {
        return Minecraft.func_71410_x().field_71474_y.func_151438_a(cat);
    }

    @Override
    public void think() {
        if (!this.enabled) {
            return;
        }
        if (this.system == null) {
            return;
        }
        this.masterVolume = Minecraft.func_71410_x().field_71474_y.func_151438_a(SoundCategory.MASTER);
        Vector<SoundOwner> purge = new Vector<SoundOwner>();
        EntityClientPlayerMP client = Minecraft.func_71410_x().field_71439_g;
        if (client == null) {
            purge.addAll(this.sounds.keySet());
        } else {
            PriorityQueue<ISound> playing = new PriorityQueue<ISound>();
            for (Map.Entry<SoundOwner, ArrayList<ISound>> entry : this.sounds.entrySet()) {
                if (entry.getKey().isEnqueued()) {
                    purge.add(entry.getKey());
                    continue;
                }
                for (ISound sound : entry.getValue()) {
                    StreamingSound base;
                    sound.think(this, client);
                    if (sound.realvol() > 0.0f) {
                        playing.add(sound);
                    }
                    if (!(sound instanceof StreamingSound) || !(base = (StreamingSound)sound).errored()) continue;
                    base.setup(StreamingSoundServer.nextSoundTag("StreamingSound"));
                }
            }
            int k = 0;
            while (!playing.isEmpty()) {
                ISound source = (ISound)playing.poll();
                if (this.maxSources > k) {
                    source.activate();
                } else {
                    source.cull();
                }
                ++k;
            }
        }
        for (SoundOwner host : purge) {
            this.removeSources(host);
        }
    }

    private void removeSources(Object o) {
        if (this.system == null) {
            return;
        }
        SoundOwner host = !(o instanceof SoundOwner) ? new SoundOwner(o) : (SoundOwner)o;
        if (!this.sounds.containsKey(host)) {
            return;
        }
        ArrayList<ISound> sources = this.sounds.get(host);
        for (ISound source : sources) {
            source.remove();
        }
        this.sounds.remove(host);
    }

    private static class SoundOwner
    extends WeakReference<Object> {
        public SoundOwner(Object host) {
            super(host);
        }

        public int hashCode() {
            if (this.get() != null) {
                return this.get().hashCode();
            }
            return 0;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SoundOwner)) {
                return this.get().equals(o);
            }
            return this.get().equals(((SoundOwner)o).get());
        }
    }
}

