/*
 * Decompiled with CFR 0.152.
 */
package lc.client.openal;

import java.util.HashMap;
import lc.api.audio.ISoundController;
import lc.api.audio.channel.ChannelDescriptor;
import lc.api.audio.channel.IMixer;
import lc.api.audio.streaming.ISound;
import lc.common.util.java.DestructableReference;

public class StreamingSoundMixer
implements IMixer {
    private final ISoundController controller;
    private final DestructableReference<Object> owner;
    private final HashMap<String, ISound> channels;
    private final HashMap<String, ChannelDescriptor> descriptors;
    private boolean dead;

    public StreamingSoundMixer(ISoundController controller, Object owner) {
        this.controller = controller;
        this.owner = new DestructableReference<Object>(owner);
        this.channels = new HashMap();
        this.descriptors = new HashMap();
    }

    @Override
    public void createChannelDescriptor(String name, ChannelDescriptor descriptor) {
        this.descriptors.put(name, descriptor);
    }

    @Override
    public void createChannel(String name, ISound sound) {
        this.channels.put(name, sound);
    }

    @Override
    public boolean hasChannel(String name) {
        return this.channels.containsKey(name) && this.channels.get(name) != null;
    }

    @Override
    public void deleteChannel(String name) {
        ISound sound = this.channels.remove(name);
        if (sound != null) {
            sound.stop();
            sound.remove();
        }
    }

    @Override
    public IMixer playChannel(String name) {
        ISound sound = this.channels.get(name);
        if (sound != null) {
            sound.play();
        }
        return this;
    }

    @Override
    public IMixer replayChannel(String name) {
        ISound sound = this.channels.get(name);
        if (sound != null) {
            sound.stop();
            sound.play();
        }
        return this;
    }

    @Override
    public IMixer pauseChannel(String name) {
        ISound sound = this.channels.get(name);
        if (sound != null) {
            sound.pause();
        }
        return this;
    }

    @Override
    public IMixer stopChannel(String name) {
        ISound sound = this.channels.get(name);
        if (sound != null) {
            sound.stop();
        }
        return this;
    }

    @Override
    public boolean shutdown(boolean now) {
        this.dead = true;
        if (!now) {
            for (ISound sound : this.channels.values()) {
                if (sound.properties().loop() || !sound.playing() || !(sound.realvol() > 0.0f)) continue;
                return false;
            }
        }
        for (ISound sound : this.channels.values()) {
            sound.remove();
        }
        this.channels.clear();
        return true;
    }

    @Override
    public void think() {
        Object oz;
        if (this.dead && this.shutdown(false)) {
            this.dead = false;
        }
        if ((oz = this.owner.get()) != null) {
            for (ChannelDescriptor descriptor : this.descriptors.values()) {
                ISound what;
                if (this.hasChannel(descriptor.name) || (what = this.controller.getSoundService().assign(oz, descriptor.file, this.controller.getPosition(oz), descriptor.properties)) == null) continue;
                this.createChannel(descriptor.name, what);
            }
        }
    }
}

