/*
 * Decompiled with CFR 0.152.
 */
package lc.client.openal;

import java.io.IOException;
import java.net.URL;
import lc.api.audio.streaming.ISound;
import lc.api.audio.streaming.ISoundPosition;
import lc.api.audio.streaming.ISoundProperties;
import lc.api.audio.streaming.ISoundServer;
import lc.client.openal.io.StreamingSoundProtocolHandler;
import lc.common.LCLog;
import lc.common.resource.ResourceAccess;
import lc.common.util.math.Vector3;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import paulscode.sound.SoundSystem;

public class StreamingSound
implements ISound,
Comparable<StreamingSound> {
    private final SoundSystem system;
    private ISoundPosition position;
    private ISoundProperties properties;
    private String tag;
    private String filename;
    private boolean valid;
    private boolean culled;
    private boolean paused;
    private float realVolume;
    private volatile boolean errored = false;

    public StreamingSound(ISoundServer server, SoundSystem system, ISoundPosition pos, String f, ISoundProperties props, String tag) {
        this.system = system;
        this.position = pos;
        this.properties = props;
        this.filename = f;
        this.setup(tag);
    }

    public void setup(String tag) {
        try {
            String f0 = ResourceAccess.formatResourceName("${ASSET_KEY}:sound/%s", this.filename);
            ResourceLocation resourcelocation = new ResourceLocation(f0);
            String s1 = String.format("%s:%s:%s", "lcds", resourcelocation.func_110624_b(), resourcelocation.func_110623_a());
            URL path = new URL(null, s1, new StreamingSoundProtocolHandler());
            Vector3 p = (Vector3)this.position.getPositionObject();
            this.system.newSource(this.properties.override(), tag, path, this.filename, this.properties.loop(), (float)p.x, (float)p.y, (float)p.z, 0, Math.max(this.properties.volume(), 1.0f));
            this.valid = true;
            this.tag = tag;
        }
        catch (IOException ioex) {
            LCLog.warn("Can't create StreamingSound.", ioex);
        }
    }

    @Override
    public void play() {
        try {
            if (!this.valid || this.playing()) {
                return;
            }
            if (this.culled) {
                this.activate();
            }
            this.paused = false;
            this.system.play(this.tag);
        }
        catch (Exception e) {
            this.errored = true;
        }
    }

    @Override
    public void pause() {
        try {
            if (!this.valid || !this.playing() || this.culled) {
                return;
            }
            this.paused = true;
            this.system.pause(this.tag);
        }
        catch (Exception e) {
            this.errored = true;
        }
    }

    @Override
    public void stop() {
        try {
            if (!this.valid || !this.playing() || this.culled) {
                return;
            }
            this.system.stop(this.tag);
            this.system.rewind(this.tag);
        }
        catch (Exception e) {
            this.errored = true;
        }
    }

    @Override
    public void remove() {
        try {
            if (!this.valid) {
                return;
            }
            this.system.stop(this.tag);
            this.system.removeSource(this.tag);
            this.valid = false;
            this.tag = null;
        }
        catch (Exception e) {
            this.errored = true;
        }
    }

    @Override
    public void cull() {
        try {
            if (!this.valid || this.culled) {
                return;
            }
            this.system.cull(this.tag);
            this.culled = true;
        }
        catch (Exception e) {
            this.errored = true;
        }
    }

    @Override
    public void activate() {
        try {
            if (!this.valid || !this.culled) {
                return;
            }
            this.system.activate(this.tag);
            this.culled = false;
            if (this.playing()) {
                this.stop();
                this.play();
            }
        }
        catch (Exception e) {
            this.errored = true;
        }
    }

    @Override
    public void think(ISoundServer server, Object player) {
        if (!this.valid || !this.playing()) {
            this.realVolume = 0.0f;
            return;
        }
        EntityPlayer clientPlayer = (EntityPlayer)player;
        float md = server.falloff();
        md *= Math.max(this.properties.volume(), 1.0f);
        float rolloff = 1.0f;
        float rd = 1.0f;
        float d = 0.0f;
        if (this.position.getWorldObject().equals(clientPlayer.field_70170_p)) {
            d = (float)((Vector3)this.position.getPositionObject()).sub(new Vector3((Entity)clientPlayer)).mag();
        }
        if (d > md) {
            this.realVolume = 0.0f;
            this.cull();
            return;
        }
        if (rd > d) {
            d = rd;
        }
        float gain = 1.0f - rolloff * (d - rd) / (md - rd);
        float nrv = gain * this.properties.volume() * server.master();
        Vector3 i = new Vector3((Entity)clientPlayer);
        Vector3 j = ((Vector3)this.position.getPositionObject()).sub(i).div(d);
        if (nrv > 0.1f) {
            int k = 0;
            while ((float)k < d) {
                Block b = clientPlayer.field_70170_p.func_147439_a((int)i.x, (int)i.y, (int)i.z);
                nrv = b.func_149662_c() ? (nrv *= 0.5f) : (nrv *= 0.85f);
                i.add(j);
                ++k;
            }
        }
        if ((double)Math.abs(this.realVolume / nrv - 1.0f) > 0.06) {
            this.system.setVolume(this.tag, Math.min(nrv, 1.0f) * server.master());
        }
        this.realVolume = nrv;
    }

    @Override
    public float realvol() {
        return this.realVolume;
    }

    @Override
    public boolean playing() {
        return this.system.playing(this.tag);
    }

    @Override
    public boolean paused() {
        return this.paused;
    }

    @Override
    public ISoundProperties properties() {
        return this.properties;
    }

    @Override
    public int compareTo(StreamingSound x) {
        if (this.culled) {
            return (int)((this.realVolume * 0.9f - x.realVolume) * 128.0f);
        }
        return (int)((this.realVolume - x.realVolume) * 128.0f);
    }

    public boolean errored() {
        return this.errored;
    }
}

