/*
 * Decompiled with CFR 0.152.
 */
package lc.client.openal;

import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import lc.LCRuntime;
import lc.api.audio.ISoundController;
import lc.api.audio.channel.IMixer;
import lc.api.audio.streaming.ISoundPosition;
import lc.api.audio.streaming.ISoundServer;
import lc.api.event.ITickEventHandler;
import lc.client.openal.StreamingSoundMixer;
import lc.client.openal.StreamingSoundPosition;
import lc.client.openal.StreamingSoundServer;
import lc.common.LCLog;
import lc.common.util.java.DestructableReference;
import lc.common.util.math.DimensionPos;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class ClientSoundController
implements ISoundController,
ITickEventHandler {
    private final ISoundServer server;
    private final HashMap<DestructableReference<Object>, IMixer> liveMixers;

    public ClientSoundController() {
        LCRuntime.runtime.ticks().register(this);
        this.server = new StreamingSoundServer();
        this.liveMixers = new HashMap();
        this.server.initialize();
    }

    @Override
    public boolean ready() {
        return this.server != null && this.server.ready();
    }

    @Override
    public ISoundPosition getPosition(Object object) {
        DimensionPos pos = null;
        if (object instanceof NBTTagCompound) {
            pos = new DimensionPos((NBTTagCompound)object);
        } else if (object instanceof TileEntity) {
            pos = new DimensionPos((TileEntity)object);
        } else {
            return null;
        }
        return new StreamingSoundPosition(pos);
    }

    @Override
    public ISoundServer getSoundService() {
        return this.server;
    }

    @Override
    public IMixer findMixer(Object key) {
        for (Map.Entry<DestructableReference<Object>, IMixer> mz : this.liveMixers.entrySet()) {
            if (!mz.getKey().get().equals(key)) continue;
            return mz.getValue();
        }
        StreamingSoundMixer mixer = new StreamingSoundMixer(this, key);
        this.liveMixers.put(new DestructableReference<Object>(key), mixer);
        return mixer;
    }

    @Override
    public void think(Side what) {
        if (what == Side.CLIENT) {
            this.server.think();
            Iterator<Map.Entry<DestructableReference<Object>, IMixer>> iter = this.liveMixers.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<DestructableReference<Object>, IMixer> mixer = iter.next();
                DestructableReference<Object> ref = mixer.getKey();
                if (ref.get() != null) {
                    mixer.getValue().think();
                    continue;
                }
                LCLog.debug("Cleaning up orphaned sound mixer %s", mixer);
                mixer.getValue().shutdown(true);
                iter.remove();
            }
        }
    }
}

