/*
 * Decompiled with CFR 0.152.
 */
package lc.client.models.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Pattern;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;

public class WavefrontModel {
    private static Pattern ruleVertex = Pattern.compile("(v( (\\-){0,1}\\d+\\.\\d+){3,4} *\\n)|(v( (\\-){0,1}\\d+\\.\\d+){3,4} *$)");
    private static Pattern ruleNormal = Pattern.compile("(vn( (\\-){0,1}\\d+\\.\\d+){3,4} *\\n)|(vn( (\\-){0,1}\\d+\\.\\d+){3,4} *$)");
    private static Pattern ruleTexCoord = Pattern.compile("(vt( (\\-){0,1}\\d+\\.\\d+){2,3} *\\n)|(vt( (\\-){0,1}\\d+\\.\\d+){2,3} *$)");
    private static Pattern ruleFace_V_VT_VN = Pattern.compile("(f( \\d+/\\d+/\\d+){3,4} *\\n)|(f( \\d+/\\d+/\\d+){3,4} *$)");
    private static Pattern ruleFace_V_VT = Pattern.compile("(f( \\d+/\\d+){3,4} *\\n)|(f( \\d+/\\d+){3,4} *$)");
    private static Pattern ruleFace_V_VN = Pattern.compile("(f( \\d+//\\d+){3,4} *\\n)|(f( \\d+//\\d+){3,4} *$)");
    private static Pattern ruleFace_V = Pattern.compile("(f( \\d+){3,4} *\\n)|(f( \\d+){3,4} *$)");
    private static Pattern ruleObjGroup = Pattern.compile("([go]( [\\w\\d]+) *\\n)|([go]( [\\w\\d]+) *$)");
    public final String name;
    public boolean ready = false;
    public final ArrayList<Vertex> vertexHeap = new ArrayList();
    public final ArrayList<Vertex> normalHeap = new ArrayList();
    public final ArrayList<TextureCoord> texCoordHeap = new ArrayList();
    public final ArrayList<ElementGroup> groupHeap = new ArrayList();
    public ElementGroup lastGroup;

    public WavefrontModel(ResourceLocation resource) throws WavefrontModelException {
        try {
            this.name = resource.toString();
            this.loadObjModel(Minecraft.func_71410_x().func_110442_L().func_110536_a(resource).func_110527_b());
        }
        catch (IOException ex) {
            throw new WavefrontModelException("Can't read input model file.", ex);
        }
    }

    public WavefrontModel(String name, InputStream input) throws WavefrontModelException {
        this.name = name;
        this.loadObjModel(input);
    }

    public void renderAll() {
        Tessellator tessellator = Tessellator.field_78398_a;
        if (this.lastGroup != null) {
            tessellator.func_78371_b(this.lastGroup.glDrawingMode);
        } else {
            tessellator.func_78371_b(4);
        }
        this.tessellateAll(tessellator);
        tessellator.func_78381_a();
    }

    public void tessellateAll(Tessellator tessellator) {
        for (ElementGroup groupObject : this.groupHeap) {
            groupObject.render(tessellator);
        }
    }

    public void renderOnly(String ... groupNames) {
        for (ElementGroup groupObject : this.groupHeap) {
            for (String groupName : groupNames) {
                if (!groupName.equalsIgnoreCase(groupObject.name)) continue;
                groupObject.render();
            }
        }
    }

    public void tessellateOnly(Tessellator tessellator, String ... groupNames) {
        for (ElementGroup groupObject : this.groupHeap) {
            for (String groupName : groupNames) {
                if (!groupName.equalsIgnoreCase(groupObject.name)) continue;
                groupObject.render(tessellator);
            }
        }
    }

    public void renderPart(String partName) {
        for (ElementGroup groupObject : this.groupHeap) {
            if (!partName.equalsIgnoreCase(groupObject.name)) continue;
            groupObject.render();
        }
    }

    public void tessellatePart(Tessellator tessellator, String partName) {
        for (ElementGroup groupObject : this.groupHeap) {
            if (!partName.equalsIgnoreCase(groupObject.name)) continue;
            groupObject.render(tessellator);
        }
    }

    public void renderAllExcept(String ... excludedGroupNames) {
        for (ElementGroup groupObject : this.groupHeap) {
            boolean flag = false;
            for (String excludedGroupName : excludedGroupNames) {
                if (!excludedGroupName.equalsIgnoreCase(groupObject.name)) continue;
                flag = true;
            }
            if (flag) continue;
            groupObject.render();
        }
    }

    public void tessellateAllExcept(Tessellator tessellator, String ... excludedGroupNames) {
        for (ElementGroup groupObject : this.groupHeap) {
            boolean flag = false;
            for (String excludedGroupName : excludedGroupNames) {
                if (!excludedGroupName.equalsIgnoreCase(groupObject.name)) continue;
                flag = true;
            }
            if (flag) continue;
            groupObject.render(tessellator);
        }
    }

    private void loadObjModel(InputStream inputStream) throws WavefrontModelException {
        BufferedReader reader = null;
        String currentLine = null;
        int lineCount = 0;
        try {
            reader = new BufferedReader(new InputStreamReader(inputStream));
            while ((currentLine = reader.readLine()) != null) {
                Vertex vertex;
                ++lineCount;
                if ((currentLine = currentLine.replaceAll("\\s+", " ").trim()).startsWith("#") || currentLine.length() == 0) continue;
                if (currentLine.startsWith("v ")) {
                    vertex = this.ofVertex(currentLine, lineCount);
                    if (vertex == null) continue;
                    this.vertexHeap.add(vertex);
                    continue;
                }
                if (currentLine.startsWith("vn ")) {
                    vertex = this.ofNormal(currentLine, lineCount);
                    if (vertex == null) continue;
                    this.normalHeap.add(vertex);
                    continue;
                }
                if (currentLine.startsWith("vt ")) {
                    TextureCoord textureCoordinate = this.ofTexCoord(currentLine, lineCount);
                    if (textureCoordinate == null) continue;
                    this.texCoordHeap.add(textureCoordinate);
                    continue;
                }
                if (currentLine.startsWith("f ")) {
                    Face face;
                    if (this.lastGroup == null) {
                        this.lastGroup = new ElementGroup("Default");
                    }
                    if ((face = this.ofFace(currentLine, lineCount)) == null) continue;
                    this.lastGroup.faces.add(face);
                    continue;
                }
                if (!(currentLine.startsWith("g ") | currentLine.startsWith("o "))) continue;
                ElementGroup group = this.ofElementGroup(currentLine, lineCount);
                if (group != null && this.lastGroup != null) {
                    this.groupHeap.add(this.lastGroup);
                }
                this.lastGroup = group;
            }
            this.groupHeap.add(this.lastGroup);
            this.ready = true;
        }
        catch (IOException e) {
            throw new WavefrontModelException("Stream error.", e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private ElementGroup ofElementGroup(String line, int idx) throws WavefrontModelException {
        if (ruleObjGroup.matcher(line).matches()) {
            ElementGroup group = null;
            String trimmedLine = line.substring(line.indexOf(" ") + 1);
            if (trimmedLine.length() > 0) {
                group = new ElementGroup(trimmedLine);
            }
            return group;
        }
        throw new WavefrontModelException("Not a valid element group.", idx, line);
    }

    private Face ofFace(String line, int idx) throws WavefrontModelException {
        if (ruleFace_V_VT_VN.matcher(line).matches() || ruleFace_V_VT.matcher(line).matches() || ruleFace_V_VN.matcher(line).matches() || ruleFace_V.matcher(line).matches()) {
            Face face = new Face();
            String trimmedLine = line.substring(line.indexOf(" ") + 1);
            String[] tokens = trimmedLine.split(" ");
            String[] subTokens = null;
            if (tokens.length == 3) {
                if (this.lastGroup.glDrawingMode == -1) {
                    this.lastGroup.glDrawingMode = 4;
                } else if (this.lastGroup.glDrawingMode != 4) {
                    throw new WavefrontModelException(String.format("Invalid points for face: expected 4, got %s.", tokens.length), idx, line);
                }
            } else if (tokens.length == 4) {
                if (this.lastGroup.glDrawingMode == -1) {
                    this.lastGroup.glDrawingMode = 7;
                } else if (this.lastGroup.glDrawingMode != 7) {
                    throw new WavefrontModelException(String.format("Invalid points for face: expected 3, got %s.", tokens.length), idx, line);
                }
            }
            if (ruleFace_V_VT_VN.matcher(line).matches()) {
                face.vertices = new Vertex[tokens.length];
                face.texCoords = new TextureCoord[tokens.length];
                face.normals = new Vertex[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    subTokens = tokens[i].split("/");
                    face.vertices[i] = this.vertexHeap.get(Integer.parseInt(subTokens[0]) - 1);
                    face.texCoords[i] = this.texCoordHeap.get(Integer.parseInt(subTokens[1]) - 1);
                    face.normals[i] = this.normalHeap.get(Integer.parseInt(subTokens[2]) - 1);
                }
                face.faceNormal = face.calculateFaceNormal();
            } else if (ruleFace_V_VT.matcher(line).matches()) {
                face.vertices = new Vertex[tokens.length];
                face.texCoords = new TextureCoord[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    subTokens = tokens[i].split("/");
                    face.vertices[i] = this.vertexHeap.get(Integer.parseInt(subTokens[0]) - 1);
                    face.texCoords[i] = this.texCoordHeap.get(Integer.parseInt(subTokens[1]) - 1);
                }
                face.faceNormal = face.calculateFaceNormal();
            } else if (ruleFace_V_VN.matcher(line).matches()) {
                face.vertices = new Vertex[tokens.length];
                face.normals = new Vertex[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    subTokens = tokens[i].split("//");
                    face.vertices[i] = this.vertexHeap.get(Integer.parseInt(subTokens[0]) - 1);
                    face.normals[i] = this.normalHeap.get(Integer.parseInt(subTokens[1]) - 1);
                }
                face.faceNormal = face.calculateFaceNormal();
            } else if (ruleFace_V.matcher(line).matches()) {
                face.vertices = new Vertex[tokens.length];
                for (int i = 0; i < tokens.length; ++i) {
                    face.vertices[i] = this.vertexHeap.get(Integer.parseInt(tokens[i]) - 1);
                }
                face.faceNormal = face.calculateFaceNormal();
            } else {
                throw new WavefrontModelException("Unknown instruction on line.", idx, line);
            }
            return face;
        }
        throw new WavefrontModelException("Unsupported face format.", idx, line);
    }

    private TextureCoord ofTexCoord(String line, int idx) throws WavefrontModelException {
        if (ruleTexCoord.matcher(line).matches()) {
            TextureCoord textureCoordinate = null;
            line = line.substring(line.indexOf(" ") + 1);
            String[] tokens = line.split(" ");
            try {
                if (tokens.length == 2) {
                    return new TextureCoord(Float.parseFloat(tokens[0]), 1.0f - Float.parseFloat(tokens[1]));
                }
                if (tokens.length == 3) {
                    return new TextureCoord(Float.parseFloat(tokens[0]), 1.0f - Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                }
            }
            catch (NumberFormatException e) {
                throw new WavefrontModelException(String.format("Number formatting error at line %d.", idx), e);
            }
            return textureCoordinate;
        }
        throw new WavefrontModelException("Not a valid texture coordinate.", idx, line);
    }

    private Vertex ofNormal(String line, int idx) throws WavefrontModelException {
        if (ruleNormal.matcher(line).matches()) {
            line = line.substring(line.indexOf(" ") + 1);
            String[] tokens = line.split(" ");
            try {
                if (tokens.length == 3) {
                    return new Vertex(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                }
                return null;
            }
            catch (NumberFormatException e) {
                throw new WavefrontModelException(String.format("Number formatting error at line %d.", idx), e);
            }
        }
        throw new WavefrontModelException("Not a valid normal vertex.", idx, line);
    }

    private Vertex ofVertex(String line, int idx) throws WavefrontModelException {
        if (ruleVertex.matcher(line).matches()) {
            line = line.substring(line.indexOf(" ") + 1);
            String[] tokens = line.split(" ");
            try {
                if (tokens.length == 2) {
                    return new Vertex(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]));
                }
                if (tokens.length == 3) {
                    return new Vertex(Float.parseFloat(tokens[0]), Float.parseFloat(tokens[1]), Float.parseFloat(tokens[2]));
                }
                return null;
            }
            catch (NumberFormatException e) {
                throw new WavefrontModelException(String.format("Number formatting error at line %d.", idx), e);
            }
        }
        throw new WavefrontModelException("Not a valid vertex.", idx, line);
    }

    public static class ElementGroup {
        public final String name;
        public final ArrayList<Face> faces = new ArrayList();
        public int glDrawingMode;

        public ElementGroup() {
            this("");
        }

        public ElementGroup(String name) {
            this(name, -1);
        }

        public ElementGroup(String name, int glDrawingMode) {
            this.name = name;
            this.glDrawingMode = glDrawingMode;
        }

        public void render() {
            if (this.faces.size() > 0) {
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78371_b(this.glDrawingMode);
                this.render(tessellator);
                tessellator.func_78381_a();
            }
        }

        public void render(Tessellator tessellator) {
            if (this.faces.size() > 0) {
                for (Face face : this.faces) {
                    face.addFaceForRender(tessellator);
                }
            }
        }
    }

    public static class Face {
        public Vertex[] vertices;
        public Vertex[] normals;
        public TextureCoord[] texCoords;
        public Vertex faceNormal;

        public void addFaceForRender(Tessellator tessellator) {
            this.addFaceForRender(tessellator, 5.0E-4f);
        }

        public void addFaceForRender(Tessellator tessellator, float textureOffset) {
            if (this.faceNormal == null) {
                this.faceNormal = this.calculateFaceNormal();
            }
            tessellator.func_78375_b(this.faceNormal.x, this.faceNormal.y, this.faceNormal.z);
            float averageU = 0.0f;
            float averageV = 0.0f;
            if (this.texCoords != null && this.texCoords.length > 0) {
                for (TextureCoord texCoord : this.texCoords) {
                    averageU += texCoord.u;
                    averageV += texCoord.v;
                }
                averageU /= (float)this.texCoords.length;
                averageV /= (float)this.texCoords.length;
            }
            for (int i = 0; i < this.vertices.length; ++i) {
                if (this.texCoords != null && this.texCoords.length > 0) {
                    float offsetU = textureOffset;
                    float offsetV = textureOffset;
                    if (this.texCoords[i].u > averageU) {
                        offsetU = -offsetU;
                    }
                    if (this.texCoords[i].v > averageV) {
                        offsetV = -offsetV;
                    }
                    tessellator.func_78374_a((double)this.vertices[i].x, (double)this.vertices[i].y, (double)this.vertices[i].z, (double)(this.texCoords[i].u + offsetU), (double)(this.texCoords[i].v + offsetV));
                    continue;
                }
                tessellator.func_78377_a((double)this.vertices[i].x, (double)this.vertices[i].y, (double)this.vertices[i].z);
            }
        }

        public Vertex calculateFaceNormal() {
            Vec3 v1 = Vec3.func_72443_a((double)(this.vertices[1].x - this.vertices[0].x), (double)(this.vertices[1].y - this.vertices[0].y), (double)(this.vertices[1].z - this.vertices[0].z));
            Vec3 v2 = Vec3.func_72443_a((double)(this.vertices[2].x - this.vertices[0].x), (double)(this.vertices[2].y - this.vertices[0].y), (double)(this.vertices[2].z - this.vertices[0].z));
            Vec3 normalVector = v1.func_72431_c(v2).func_72432_b();
            return new Vertex((float)normalVector.field_72450_a, (float)normalVector.field_72448_b, (float)normalVector.field_72449_c);
        }
    }

    public static class TextureCoord {
        public float u;
        public float v;
        public float w;

        public TextureCoord(float u, float v) {
            this(u, v, 0.0f);
        }

        public TextureCoord(float u, float v, float w) {
            this.u = u;
            this.v = v;
            this.w = w;
        }
    }

    public static class Vertex {
        public float x;
        public float y;
        public float z;

        public Vertex(float x, float y) {
            this(x, y, 0.0f);
        }

        public Vertex(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }

    public static class WavefrontModelException
    extends Exception {
        private static final long serialVersionUID = 5032918858527482568L;

        public WavefrontModelException(String reason) {
            super(reason);
        }

        public WavefrontModelException(String reason, Throwable top) {
            super(reason, top);
        }

        public WavefrontModelException(String reason, int idx, String line) {
            super(String.format("[line %s]: %s (`%s`)", idx, reason, line));
        }
    }
}

