/*
 * Decompiled with CFR 0.152.
 */
package lc.client.models;

import lc.client.opengl.BufferDisplayList;
import lc.client.opengl.GLHelper;
import lc.client.render.fabs.tiles.TileStargateBaseRenderer;
import lc.common.base.pipeline.LCTileRenderPipeline;
import lc.common.resource.ResourceMap;
import lc.common.util.data.StateMap;
import lc.common.util.math.Orientations;
import lc.tiles.TileStargateBase;
import org.lwjgl.opengl.GL11;

public class ModelStargate {
    public static final int numRingSegments = 38;
    public static final double ringSymbolAngle = 9.473684210526315;
    public static final double ringSymbolTextureLength = 304.0;
    public static final double ringSymbolTextureHeight = 12.0;
    public static final double ringSymbolSegmentWidth = 8.0;
    public static final double ringInnerRadius = 2.75;
    public static final double ringInnerMovingRadius = 2.9;
    public static final double ringOuterRadius = 3.5;
    public static final double ringMidRadius = 3.2;
    public static final double ringDepth = 0.15;
    public static final int numChevrons = 9;
    public static final double chevronInnerRadius = 3.2;
    public static final double chevronOuterRadius = 3.5625;
    public static final double chevronWidth = 0.5;
    public static final double chevronDepth = 0.0625;
    public static final double chevronBorderWidth = 0.08333333333333333;
    public static final double chevronAngle = 40.0;
    public static final double chevronAngleOffset = -89.5;
    public static final int ringFaceTextureIndex = 20;
    public static final int ringTextureIndex = 21;
    public static final int ringSymbolTextureIndex = 32;
    public static final int chevronTextureIndex = 5;
    public static final int chevronLitTextureIndex = 22;
    public static double[] sin;
    public static double[] cos;
    private static double[] chevronRotations;
    private final BufferDisplayList listShell = new BufferDisplayList();
    private final BufferDisplayList listRing = new BufferDisplayList();
    private double u0;
    private double v0;

    public void init() {
        this.listShell.init();
        this.listRing.init();
        if (this.listShell.supported()) {
            this.listShell.enter();
            this.renderShellImmediate();
            this.listShell.exit();
        }
        if (this.listRing.supported()) {
            this.listRing.enter();
            this.renderRingImmediate();
            this.listRing.exit();
        }
    }

    public void render(TileStargateBaseRenderer renderer, LCTileRenderPipeline tesr, TileStargateBase tile, StateMap state) {
        GL11.glRotatef((float)Orientations.from(tile.getRotation()).angle(), (float)0.0f, (float)1.0f, (float)0.0f);
        ResourceMap resources = renderer.resources;
        ResourceMap textures = resources.map(tile.getStargateType().getName());
        tesr.bind(textures.resource("frame"));
        if (this.listShell.supported()) {
            this.listShell.bind(new Object[0]);
            this.listShell.release();
        } else {
            this.renderShellImmediate();
        }
        for (int i = 0; i < 9; ++i) {
            GL11.glPushMatrix();
            GL11.glRotated((double)chevronRotations[i], (double)0.0, (double)0.0, (double)1.0);
            GL11.glTranslated((double)(-state.get("chevron-dist-" + i, 0.0).doubleValue()), (double)0.0, (double)0.0);
            this.renderChevronImmediate(state.get("chevron-light-" + i, 0.0));
            GL11.glPopMatrix();
        }
        tesr.bind(textures.resource("glyphs"));
        GL11.glPushMatrix();
        GL11.glRotated((double)state.get("ring-rotation", 0.0), (double)0.0, (double)0.0, (double)1.0);
        if (this.listRing.supported()) {
            this.listRing.bind(new Object[0]);
            this.listRing.release();
        } else {
            this.renderRingImmediate();
        }
        GL11.glPopMatrix();
    }

    private void renderShellImmediate() {
        double bevelDepth = 0.0875;
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glBegin((int)7);
        for (int i = 0; i < 38; ++i) {
            this.selectTile(4);
            GL11.glNormal3d((double)(-cos[i]), (double)(-sin[i]), (double)0.0);
            this.vertex(3.5 * cos[i], 3.5 * sin[i], 0.15, 0.0, 0.0);
            this.vertex(3.5 * cos[i], 3.5 * sin[i], -0.15, 0.0, 16.0);
            this.vertex(3.5 * cos[i + 1], 3.5 * sin[i + 1], -0.15, 16.0, 16.0);
            this.vertex(3.5 * cos[i + 1], 3.5 * sin[i + 1], 0.15, 16.0, 0.0);
            this.selectTile(20);
            this.vertex(3.2 * cos[i], 3.2 * sin[i], 0.15, 0.0, 0.0);
            this.vertex(3.2 * cos[i + 1], 3.2 * sin[i + 1], 0.15, 16.0, 0.0);
            this.vertex(3.2 * cos[i + 1], 3.2 * sin[i + 1], -0.15, 16.0, 16.0);
            this.vertex(3.2 * cos[i], 3.2 * sin[i], -0.15, 0.0, 16.0);
            this.selectTile(23);
            GL11.glNormal3d((double)(-cos[i]), (double)(-sin[i]), (double)0.0);
            this.vertex(2.75 * cos[i], 2.75 * sin[i], bevelDepth, 0.0, 0.0);
            this.vertex(2.75 * cos[i + 1], 2.75 * sin[i + 1], bevelDepth, 16.0, 0.0);
            this.vertex(2.75 * cos[i + 1], 2.75 * sin[i + 1], -bevelDepth, 16.0, 16.0);
            this.vertex(2.75 * cos[i], 2.75 * sin[i], -bevelDepth, 0.0, 16.0);
            this.selectTile(20);
            this.vertex(2.9 * cos[i], 2.9 * sin[i], 0.15, 0.0, 0.0);
            this.vertex(2.9 * cos[i], 2.9 * sin[i], -0.15, 0.0, 16.0);
            this.vertex(2.9 * cos[i + 1], 2.9 * sin[i + 1], -0.15, 16.0, 16.0);
            this.vertex(2.9 * cos[i + 1], 2.9 * sin[i + 1], 0.15, 16.0, 0.0);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            this.selectTile(20);
            this.vertex(2.75 * cos[i], 2.75 * sin[i], -bevelDepth, 0.0, 16.0);
            this.vertex(2.75 * cos[i + 1], 2.75 * sin[i + 1], -bevelDepth, 16.0, 16.0);
            this.vertex(2.9 * cos[i + 1], 2.9 * sin[i + 1], -0.15, 16.0, 0.0);
            this.vertex(2.9 * cos[i], 2.9 * sin[i], -0.15, 0.0, 0.0);
            this.vertex(2.9 * cos[i], 2.9 * sin[i], -0.15, 0.0, 16.0);
            this.vertex(2.9 * cos[i + 1], 2.9 * sin[i + 1], -0.15, 16.0, 16.0);
            this.vertex(3.5 * cos[i + 1], 3.5 * sin[i + 1], -0.15, 16.0, 0.0);
            this.vertex(3.5 * cos[i], 3.5 * sin[i], -0.15, 0.0, 0.0);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            this.selectTile(20);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            this.vertex(2.75 * cos[i], 2.75 * sin[i], bevelDepth, 16.0, 16.0);
            this.vertex(2.9 * cos[i], 2.9 * sin[i], 0.15, 16.0, 0.0);
            this.vertex(2.9 * cos[i + 1], 2.9 * sin[i + 1], 0.15, 0.0, 0.0);
            this.vertex(2.75 * cos[i + 1], 2.75 * sin[i + 1], bevelDepth, 0.0, 16.0);
            this.vertex(3.2 * cos[i], 3.2 * sin[i], 0.15, 16.0, 16.0);
            this.vertex(3.5 * cos[i], 3.5 * sin[i], 0.15, 16.0, 0.0);
            this.vertex(3.5 * cos[i + 1], 3.5 * sin[i + 1], 0.15, 0.0, 0.0);
            this.vertex(3.2 * cos[i + 1], 3.2 * sin[i + 1], 0.15, 0.0, 16.0);
        }
        GL11.glEnd();
    }

    private void renderChevronImmediate(double light) {
        double r1 = 3.144444444444445;
        double r2 = 3.5625;
        double z2 = 0.15;
        double z1 = z2 + 0.0625;
        double z3 = -0.2125;
        double w1 = 0.08333333333333333;
        double w2 = w1 * 1.25;
        double x1 = r1;
        double y1 = 0.125;
        double x2 = r2;
        double y2 = 0.25;
        GL11.glBegin((int)7);
        this.selectTile(5);
        this.vertex(x2, y2, z1, 0.0, 2.0);
        this.vertex(x1, y1, z1, 0.0, 16.0);
        this.vertex(x1 + w1, y1 - w1, z1, 4.0, 12.0);
        this.vertex(x2, y2 - w2, z1, 4.0, 2.0);
        this.vertex(x1 + w1, y1 - w1, z1, 4.0, 12.0);
        this.vertex(x1, y1, z1, 0.0, 16.0);
        this.vertex(x1, -y1, z1, 16.0, 16.0);
        this.vertex(x1 + w1, -y1 + w1, z1, 12.0, 12.0);
        this.vertex(x2, -y2 + w2, z1, 12.0, 0.0);
        this.vertex(x1 + w1, -y1 + w1, z1, 12.0, 12.0);
        this.vertex(x1, -y1, z1, 16.0, 16.0);
        this.vertex(x2, -y2, z1, 16.0, 0.0);
        this.vertex(x2, y2, z1, 0.0, 0.0);
        this.vertex(x2, y2, z3, 0.0, 4.0);
        this.vertex(x1, y1, z3, 16.0, 4.0);
        this.vertex(x1, y1, z1, 16.0, 0.0);
        this.vertex(x1, -y1, z1, 0.0, 0.0);
        this.vertex(x1, -y1, z3, 0.0, 4.0);
        this.vertex(x2, -y2, z3, 16.0, 4.0);
        this.vertex(x2, -y2, z1, 16.0, 0.0);
        this.vertex(x2, y2, z1, 16.0, 0.0);
        this.vertex(x2, y2 - w2, z1, 12.0, 0.0);
        this.vertex(x2, y2 - w2, z3, 12.0, 4.0);
        this.vertex(x2, y2, z3, 16.0, 4.0);
        this.vertex(x2, -y2, z1, 0.0, 0.0);
        this.vertex(x2, -y2, z3, 0.0, 4.0);
        this.vertex(x2, -y2 + w2, z3, 4.0, 4.0);
        this.vertex(x2, -y2 + w2, z1, 4.0, 0.0);
        this.vertex(x2, y2 - w2, z3, 0.0, 0.0);
        this.vertex(x2, y2 - w2, 0.0, 0.0, 4.0);
        this.vertex(x2, -y2 + w2, 0.0, 16.0, 4.0);
        this.vertex(x2, -y2 + w2, z3, 16.0, 0.0);
        this.vertex(x1, y1, z1, 0.0, 0.0);
        this.vertex(x1, y1, z3, 0.0, 4.0);
        this.vertex(x1, -y1, z3, 16.0, 4.0);
        this.vertex(x1, -y1, z1, 16.0, 0.0);
        this.vertex(x2, -y2, z3, 0.0, 0.0);
        this.vertex(x1, -y1, z3, 0.0, 16.0);
        this.vertex(x1, y1, z3, 16.0, 16.0);
        this.vertex(x2, y2, z3, 16.0, 0.0);
        GL11.glEnd();
        this.selectTile(22);
        if (light > 0.0) {
            GL11.glDisable((int)2896);
        }
        GL11.glColor3d((double)(0.5 + light), (double)(0.5 + light), (double)(0.5 + light));
        GL11.glBegin((int)7);
        this.vertex(x2, y2 - w2, z1, 0.0, 4.0);
        this.vertex(x1 + w1, y1 - w1, z1, 4.0, 16.0);
        this.vertex(x1 + w1, 0.0, z1, 8.0, 16.0);
        this.vertex(x2, 0.0, z1, 8.0, 4.0);
        this.vertex(x2, 0.0, z1, 8.0, 4.0);
        this.vertex(x1 + w1, 0.0, z1, 8.0, 16.0);
        this.vertex(x1 + w1, -y1 + w1, z1, 12.0, 16.0);
        this.vertex(x2, -y2 + w2, z1, 16.0, 4.0);
        this.vertex(x2, y2 - w2, 0.0, 0.0, 0.0);
        this.vertex(x2, y2 - w2, z1, 0.0, 4.0);
        this.vertex(x2, -y2 + w2, z1, 16.0, 4.0);
        this.vertex(x2, -y2 + w2, 0.0, 16.0, 0.0);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glEnd();
        GL11.glEnable((int)2896);
    }

    private void renderRingImmediate() {
        double radiusMidInner = 2.8921875;
        double radiusMidOuter = 3.2078125;
        double z = 0.134375;
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glBegin((int)7);
        this.selectTile(32);
        double u = 0.0;
        double du = 0.0;
        double dv = 0.0;
        for (int i = 0; i < 38; ++i) {
            u = (double)i * 0.02631578947368421;
            du = 0.02631578947368421;
            dv = 0.66;
            GLHelper.pushTexVertex(radiusMidInner * cos[i], radiusMidInner * sin[i], z, u + du, dv);
            GLHelper.pushTexVertex(radiusMidOuter * cos[i], radiusMidOuter * sin[i], z, u + du, 0.0);
            GLHelper.pushTexVertex(radiusMidOuter * cos[i + 1], radiusMidOuter * sin[i + 1], z, u, 0.0);
            GLHelper.pushTexVertex(radiusMidInner * cos[i + 1], radiusMidInner * sin[i + 1], z, u, dv);
        }
        GL11.glEnd();
    }

    private void selectTile(int index) {
        this.u0 = (double)(index & 0xF) / 16.0;
        this.v0 = (double)(index >> 4) / 16.0;
    }

    private void vertex(double x, double y, double z, double u, double v) {
        GLHelper.pushTexVertex(x, y, z, this.u0 + u * 0.00390625, this.v0 + v * 0.00390625);
    }

    static {
        int i;
        sin = new double[39];
        cos = new double[39];
        chevronRotations = new double[10];
        for (i = 0; i <= 38; ++i) {
            double a = Math.PI * 2 * (double)i / 38.0;
            ModelStargate.sin[i] = Math.sin(a);
            ModelStargate.cos[i] = Math.cos(a);
        }
        for (i = 0; i < 9; ++i) {
            ModelStargate.chevronRotations[i] = (double)i * 40.0 - -89.5;
        }
    }
}

