/*
 * Decompiled with CFR 0.152.
 */
package lc.client.animation;

import java.util.HashMap;
import java.util.Map;
import lc.common.util.data.StateMap;
import lc.common.util.game.RunnableTileCallback;

public abstract class Animation {
    protected final Double duration;
    protected final HashMap<String, Property> properties;
    protected final boolean requiresResampling;
    public final RunnableTileCallback doBefore;
    public final RunnableTileCallback doAfter;

    public Animation(Double duration, boolean resample, RunnableTileCallback doBefore, RunnableTileCallback doAfter) {
        this.duration = duration;
        this.properties = new HashMap();
        this.requiresResampling = resample;
        this.doBefore = doBefore;
        this.doAfter = doAfter;
    }

    public void addProperty(String name, Double start, Double end, InterpolationMode mode) {
        this.properties.put(name, new Property(start, end, mode));
    }

    public Double readProperty(String name, Double time) {
        Property property = this.properties.get(name);
        if (property != null) {
            return property.readProperty(time / this.duration);
        }
        throw new IllegalArgumentException("No such property found.");
    }

    public void sampleProperties(StateMap map, Double time) {
        for (Map.Entry<String, Property> rec : this.properties.entrySet()) {
            map.set(rec.getKey(), rec.getValue().readProperty(time / this.duration));
        }
    }

    public void sampleProperties(StateMap map) {
        for (Map.Entry<String, Property> rec : this.properties.entrySet()) {
            map.set(rec.getKey(), rec.getValue().readProperty(1.0));
        }
    }

    public void resampleProperties(StateMap map) {
        for (Map.Entry<String, Property> rec : this.properties.entrySet()) {
            Object zz = map.get(rec.getKey());
            if (zz == null || !(zz instanceof Double)) continue;
            rec.getValue().b = (Double)zz;
        }
    }

    public boolean requiresResampling() {
        return this.requiresResampling;
    }

    public boolean finished(Double time) {
        return time > this.duration;
    }

    protected class Property {
        public Double a;
        public Double b;
        public InterpolationMode mode;

        public Property(Double start, Double end, InterpolationMode mode) {
            this.a = end;
            this.b = start;
            this.mode = mode;
        }

        public Double readProperty(Double fracT) {
            Double fxFracT = 0.0;
            switch (this.mode) {
                default: {
                    return this.a * fracT + this.b * (1.0 - fracT);
                }
                case SMOOTHSTEP: {
                    fxFracT = fracT * fracT * (3.0 - 2.0 * fracT);
                    return this.a * fxFracT + this.b * (1.0 - fxFracT);
                }
                case SQUARE: {
                    fxFracT = fracT * fracT;
                    return this.a * fxFracT + this.b * (1.0 - fxFracT);
                }
                case INVSQUARE: {
                    fxFracT = 1.0 - (1.0 - fracT) * (1.0 - fracT);
                    return this.a * fxFracT + this.b * (1.0 - fxFracT);
                }
                case CUBED: {
                    fxFracT = fracT * fracT * fracT;
                    return this.a * fxFracT + this.b * (1.0 - fxFracT);
                }
                case INVCUBED: {
                    fxFracT = 1.0 - (1.0 - fracT) * (1.0 - fracT) * (1.0 - fracT);
                    return this.a * fxFracT + this.b * (1.0 - fxFracT);
                }
                case SIN: {
                    fxFracT = Math.sin(fracT * Math.PI / 2.0);
                    return this.a * fxFracT + this.b * (1.0 - fxFracT);
                }
                case INVSIN: 
            }
            fxFracT = 1.0 - Math.sin((1.0 - fracT) * Math.PI / 2.0);
            return this.a * fxFracT + this.b * (1.0 - fxFracT);
        }
    }

    public static enum InterpolationMode {
        LINEAR,
        SMOOTHSTEP,
        SQUARE,
        INVSQUARE,
        CUBED,
        INVCUBED,
        SIN,
        INVSIN;

    }
}

