/*
 * Decompiled with CFR 0.152.
 */
package lc.client;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.client.registry.RenderingRegistry;
import lc.LCRuntime;
import lc.api.audio.ISoundController;
import lc.api.defs.IContainerDefinition;
import lc.api.defs.IRecipeDefinition;
import lc.api.rendering.IParticleMachine;
import lc.blocks.BlockBrazier;
import lc.blocks.BlockConfigurator;
import lc.blocks.BlockDHD;
import lc.blocks.BlockLanteaDoor;
import lc.blocks.BlockObelisk;
import lc.client.openal.ClientSoundController;
import lc.client.opengl.ParticleMachine;
import lc.client.render.fabs.blocks.BlockBrazierRenderer;
import lc.client.render.fabs.blocks.BlockConfiguratorRenderer;
import lc.client.render.fabs.blocks.BlockDHDRenderer;
import lc.client.render.fabs.blocks.BlockDoorRenderer;
import lc.client.render.fabs.blocks.BlockObeliskRenderer;
import lc.client.render.fabs.entities.EntityStaffProjectileRenderer;
import lc.client.render.fabs.items.ItemDecoratorRenderer;
import lc.client.render.fabs.tiles.TileConfiguratorRenderer;
import lc.client.render.fabs.tiles.TileDHDRenderer;
import lc.client.render.fabs.tiles.TileDoorRenderer;
import lc.client.render.fabs.tiles.TileStargateBaseRenderer;
import lc.client.render.fabs.tiles.TileTransportRingRenderer;
import lc.common.LCLog;
import lc.common.base.LCBlock;
import lc.common.base.LCItem;
import lc.common.base.pipeline.LCBlockRenderPipeline;
import lc.common.base.pipeline.LCEntityRenderPipeline;
import lc.common.base.pipeline.LCItemRenderPipeline;
import lc.common.base.pipeline.LCTileRenderPipeline;
import lc.common.impl.registry.DefinitionRegistry;
import lc.entity.EntityStaffProjectile;
import lc.items.ItemDecorator;
import lc.server.HintProviderServer;
import lc.tiles.TileConfigurator;
import lc.tiles.TileDHD;
import lc.tiles.TileLanteaDoor;
import lc.tiles.TileStargateBase;
import lc.tiles.TileTransportRing;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class HintProviderClient
extends HintProviderServer {
    private LCBlockRenderPipeline blockRenderingHook;
    private LCTileRenderPipeline tileRenderingHook;
    private LCItemRenderPipeline itemRenderingHook;
    private LCEntityRenderPipeline entityRenderingHook;
    private ClientSoundController soundController;
    private ParticleMachine particleMachine;

    public HintProviderClient() {
        LCLog.debug("HintProviderClient providing client-side hints");
    }

    @Override
    public void preInit() {
        super.preInit();
        this.blockRenderingHook = new LCBlockRenderPipeline(RenderingRegistry.getNextAvailableRenderId());
        this.tileRenderingHook = new LCTileRenderPipeline();
        this.itemRenderingHook = new LCItemRenderPipeline();
        this.entityRenderingHook = new LCEntityRenderPipeline();
        this.soundController = new ClientSoundController();
        this.particleMachine = new ParticleMachine();
        RenderingRegistry.registerBlockHandler((int)this.blockRenderingHook.getRenderId(), (ISimpleBlockRenderingHandler)this.blockRenderingHook);
    }

    @Override
    public void init() {
        super.init();
        DefinitionRegistry registry = (DefinitionRegistry)LCRuntime.runtime.registries().definitions();
        registry.registerTileRenderer(TileStargateBase.class, TileStargateBaseRenderer.class);
        registry.registerTileRenderer(TileTransportRing.class, TileTransportRingRenderer.class);
        registry.registerItemRenderer(ItemDecorator.class, ItemDecoratorRenderer.class);
        registry.registerBlockRenderer(BlockLanteaDoor.class, BlockDoorRenderer.class);
        registry.registerBlockRenderer(BlockObelisk.class, BlockObeliskRenderer.class);
        registry.registerBlockRenderer(BlockBrazier.class, BlockBrazierRenderer.class);
        registry.registerBlockRenderer(BlockConfigurator.class, BlockConfiguratorRenderer.class);
        registry.registerBlockRenderer(BlockDHD.class, BlockDHDRenderer.class);
        registry.registerTileRenderer(TileLanteaDoor.class, TileDoorRenderer.class);
        registry.registerTileRenderer(TileDHD.class, TileDHDRenderer.class);
        registry.registerTileRenderer(TileConfigurator.class, TileConfiguratorRenderer.class);
        registry.registerEntityRenderer(EntityStaffProjectile.class, EntityStaffProjectileRenderer.class);
    }

    @Override
    public void postInit() {
        super.postInit();
    }

    @Override
    public void provideHints(IContainerDefinition definition) {
        super.provideHints(definition);
        if (definition.getBlock() != null) {
            LCBlock theBlock = (LCBlock)definition.getBlock();
            theBlock.setRenderer(this.blockRenderingHook.getRenderId());
        }
        if (definition.getTileType() != null) {
            Class<? extends TileEntity> theTile = definition.getTileType();
            ClientRegistry.bindTileEntitySpecialRenderer(theTile, (TileEntitySpecialRenderer)this.tileRenderingHook);
        }
        if (definition.getItem() != null && definition.getItem() instanceof LCItem) {
            LCItem theItem = (LCItem)definition.getItem();
            MinecraftForgeClient.registerItemRenderer((Item)theItem, (IItemRenderer)this.itemRenderingHook);
        }
        if (definition.getEntityType() != null) {
            Class<? extends Entity> theEntity = definition.getEntityType();
            RenderingRegistry.registerEntityRenderingHandler(theEntity, (Render)this.entityRenderingHook);
        }
    }

    @Override
    public void provideHints(IRecipeDefinition definition) {
        super.provideHints(definition);
    }

    @Override
    public ISoundController audio() {
        return this.soundController;
    }

    @Override
    public IParticleMachine particles() {
        return this.particleMachine;
    }
}

