/*
 * Decompiled with CFR 0.152.
 */
package lc.blocks;

import java.util.List;
import lc.api.components.ComponentType;
import lc.api.defs.Definition;
import lc.api.rendering.IBlockRenderInfo;
import lc.api.stargate.StargateType;
import lc.common.base.LCBlock;
import lc.common.base.LCTile;
import lc.common.base.multiblock.MultiblockState;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.resource.ResourceAccess;
import lc.items.ItemBlockStargateRing;
import lc.tiles.TileStargateRing;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;

@Definition(name="stargateRing", type=ComponentType.STARGATE, blockClass=BlockStargateRing.class, itemBlockClass=ItemBlockStargateRing.class, tileClass=TileStargateRing.class)
public class BlockStargateRing
extends LCBlock {
    private static final int blockMask = 2;
    private static final int blockCount;
    private static final int blockCraftingMask = 1;
    private static final int blockCraftingCount;
    IIcon[] topAndBottomTexture = new IIcon[StargateType.count()];
    IIcon[][] sideTextures = new IIcon[StargateType.count()][2];
    private static IBlockRenderInfo renderInfo;

    public BlockStargateRing() {
        super(Material.field_151578_c);
        this.func_149711_c(3.0f).func_149752_b(2000.0f);
        this.setOpaque(false).setProvidesInventory(false).setProvidesTypes(true);
    }

    protected String func_149641_N() {
        return ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", this.func_149739_a());
    }

    public IIcon func_149691_a(int side, int data) {
        int typeof = this.getBaseType(data);
        if (side <= 1) {
            return this.topAndBottomTexture[typeof];
        }
        return this.sideTextures[typeof][data % 2];
    }

    public void func_149651_a(IIconRegister register) {
        StargateType[] types;
        for (StargateType typeof : types = StargateType.values()) {
            StringBuilder typename = new StringBuilder();
            typename.append("stargate_%s");
            if (typeof.getSuffix() != null && typeof.getSuffix().length() > 0) {
                typename.append("_").append(typeof.getSuffix());
            }
            this.topAndBottomTexture[typeof.ordinal()] = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", String.format(typename.toString(), "block")));
            this.sideTextures[typeof.ordinal()][0] = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", String.format(typename.toString(), "ring")));
            this.sideTextures[typeof.ordinal()][1] = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", String.format(typename.toString(), "chevron")));
        }
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < blockCraftingCount; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int func_149692_a(int damage) {
        return damage;
    }

    public int getBaseType(int metadata) {
        return (int)Math.floor(metadata / 2);
    }

    @Override
    public IBlockRenderInfo renderInfoBlock() {
        return renderInfo;
    }

    @Override
    public void configure(ComponentConfig c) {
    }

    static {
        blockCraftingCount = blockCount = StargateType.count() * 2;
        renderInfo = new IBlockRenderInfo(){

            @Override
            public boolean doWorldRender(IBlockAccess access, int data, int x, int y, int z) {
                return true;
            }

            @Override
            public boolean doProperty(String property, IBlockAccess access, int data, int x, int y, int z, boolean def) {
                LCTile t;
                if (property.equalsIgnoreCase("noRender") && (t = (LCTile)access.func_147438_o(x, y, z)) != null && t instanceof TileStargateRing) {
                    return ((TileStargateRing)t).getState() != MultiblockState.FORMED;
                }
                return def;
            }

            @Override
            public boolean doInventoryRender(int data) {
                return true;
            }
        };
    }
}

