/*
 * Decompiled with CFR 0.152.
 */
package lc.blocks;

import java.util.List;
import lc.LCRuntime;
import lc.LanteaCraft;
import lc.api.components.ComponentType;
import lc.api.defs.Definition;
import lc.api.rendering.IBlockRenderInfo;
import lc.api.stargate.StargateType;
import lc.common.base.LCBlock;
import lc.common.base.LCTile;
import lc.common.base.multiblock.MultiblockState;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.resource.ResourceAccess;
import lc.items.ItemBlockStargateBase;
import lc.tiles.TileStargateBase;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@Definition(name="stargateBase", type=ComponentType.STARGATE, blockClass=BlockStargateBase.class, itemBlockClass=ItemBlockStargateBase.class, tileClass=TileStargateBase.class)
public class BlockStargateBase
extends LCBlock {
    private static final int blockCount = StargateType.count();
    private static IBlockRenderInfo renderInfo = new IBlockRenderInfo(){

        @Override
        public boolean doWorldRender(IBlockAccess access, int data, int x, int y, int z) {
            return true;
        }

        @Override
        public boolean doProperty(String property, IBlockAccess access, int data, int x, int y, int z, boolean def) {
            LCTile t;
            if (property.equalsIgnoreCase("noRender") && (t = (LCTile)access.func_147438_o(x, y, z)) != null && t instanceof TileStargateBase) {
                return ((TileStargateBase)t).getState() != MultiblockState.FORMED;
            }
            return def;
        }

        @Override
        public boolean doInventoryRender(int data) {
            return true;
        }
    };
    protected IIcon[] topAndBottomTexture = new IIcon[StargateType.count()];
    protected IIcon[] frontTexture = new IIcon[StargateType.count()];
    protected IIcon[] sideTexture = new IIcon[StargateType.count()];

    public BlockStargateBase() {
        super(Material.field_151578_c);
        this.func_149711_c(3.0f).func_149752_b(2000.0f);
        this.setOpaque(false).setProvidesInventory(false).setProvidesTypes(true).setCanRotate(true);
    }

    protected String func_149641_N() {
        return ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", this.func_149739_a());
    }

    public void func_149651_a(IIconRegister register) {
        StargateType[] types;
        for (StargateType typeof : types = StargateType.values()) {
            StringBuilder typename = new StringBuilder();
            typename.append("stargate_%s");
            if (typeof.getSuffix() != null && typeof.getSuffix().length() > 0) {
                typename.append("_").append(typeof.getSuffix());
            }
            this.topAndBottomTexture[typeof.ordinal()] = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", String.format(typename.toString(), "block")));
            this.frontTexture[typeof.ordinal()] = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", String.format(typename.toString(), "base_front")));
            this.sideTexture[typeof.ordinal()] = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", String.format(typename.toString(), "ring")));
        }
    }

    public int getBaseType(int metadata) {
        return metadata;
    }

    public IIcon func_149691_a(int side, int data) {
        int typeof = this.getBaseType(data);
        if (side <= 1) {
            return this.topAndBottomTexture[typeof];
        }
        if (side == 3) {
            return this.frontTexture[typeof];
        }
        return this.sideTexture[typeof];
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < blockCount; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int func_149692_a(int metadata) {
        return this.getBaseType(metadata);
    }

    @Override
    public IBlockRenderInfo renderInfoBlock() {
        return renderInfo;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float cx, float cy, float cz) {
        TileStargateBase te = (TileStargateBase)world.func_147438_o(x, y, z);
        if (te != null && te.getState() == MultiblockState.FORMED) {
            player.openGui((Object)LanteaCraft.instance, LCRuntime.runtime.interfaces().stargateUI.getGUIID(), world, x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public void configure(ComponentConfig c) {
    }
}

