/*
 * Decompiled with CFR 0.152.
 */
package lc.blocks;

import java.util.List;
import lc.api.components.ComponentType;
import lc.api.defs.Definition;
import lc.common.base.LCBlock;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.resource.ResourceAccess;
import lc.items.ItemBlockDecorative;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;

@Definition(name="blockDecorative", type=ComponentType.DECOR, blockClass=BlockDecorative.class, itemBlockClass=ItemBlockDecorative.class)
public class BlockDecorative
extends LCBlock {
    private IIcon missing;

    public BlockDecorative() {
        super(Material.field_151578_c);
        this.func_149711_c(10.0f);
        this.setHarvestLevel("pickaxe", 1);
        this.setOpaque(true);
    }

    public void func_149651_a(IIconRegister register) {
        this.missing = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:missing", new Object[0]));
        for (DecorBlockTypes type : DecorBlockTypes.values()) {
            type.icon = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", type.resource));
        }
    }

    public IIcon func_149691_a(int side, int data) {
        DecorBlockTypes type = DecorBlockTypes.meta(data);
        if (type == null) {
            return this.missing;
        }
        return type.icon;
    }

    public int func_149692_a(int meta) {
        return meta;
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (DecorBlockTypes type : DecorBlockTypes.values()) {
            list.add(new ItemStack(item, 1, type.idx));
        }
    }

    @Override
    public void configure(ComponentConfig c) {
    }

    public static enum DecorBlockTypes {
        LantSteel(1, "lantean_metal"),
        LantDecSteel(2, "lantean_decor"),
        GoaGold(3, "goauld_goldplain"),
        GoaDecGold(4, "goauld_golddecor");

        public final int idx;
        public final String resource;
        public IIcon icon;

        private DecorBlockTypes(int i, String s) {
            this.idx = i;
            this.resource = s;
        }

        public static DecorBlockTypes meta(int q) {
            for (DecorBlockTypes type : DecorBlockTypes.values()) {
                if (type.idx != q) continue;
                return type;
            }
            return null;
        }
    }
}

