/*
 * Decompiled with CFR 0.152.
 */
package lc.blocks;

import java.util.List;
import lc.LCRuntime;
import lc.LanteaCraft;
import lc.api.components.ComponentType;
import lc.api.defs.Definition;
import lc.api.rendering.IBlockRenderInfo;
import lc.api.stargate.StargateType;
import lc.common.base.LCBlock;
import lc.common.configuration.xml.ComponentConfig;
import lc.common.resource.ResourceAccess;
import lc.items.ItemBlockDHD;
import lc.tiles.TileDHD;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

@Definition(name="stargateDHD", type=ComponentType.STARGATE, blockClass=BlockDHD.class, itemBlockClass=ItemBlockDHD.class, tileClass=TileDHD.class)
public class BlockDHD
extends LCBlock {
    private static final int blockMask = 1;
    private static final int blockCount;
    private static final int blockCraftingMask = 1;
    private static final int blockCraftingCount;
    private static IBlockRenderInfo renderInfo;
    IIcon[] topTexture = new IIcon[StargateType.count()];
    IIcon[] bottomTexture = new IIcon[StargateType.count()];
    IIcon[] sideTexture = new IIcon[StargateType.count()];

    public BlockDHD() {
        super(Material.field_151578_c);
        this.func_149711_c(3.0f).func_149752_b(2000.0f);
        this.setOpaque(false).setProvidesInventory(false).setProvidesTypes(true).setCanRotate(true);
    }

    protected String func_149641_N() {
        return ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", this.func_149739_a());
    }

    public IIcon func_149691_a(int side, int data) {
        int typeof = this.getBaseType(data);
        if (side == 0) {
            return this.bottomTexture[typeof];
        }
        if (side == 1) {
            return this.topTexture[typeof];
        }
        return this.sideTexture[typeof];
    }

    public void func_149651_a(IIconRegister register) {
        StargateType[] types;
        for (StargateType typeof : types = StargateType.values()) {
            StringBuilder typename = new StringBuilder();
            typename.append("controller_%s");
            if (typeof.getSuffix() != null && typeof.getSuffix().length() > 0) {
                typename.append("_").append(typeof.getSuffix());
            }
            this.topTexture[typeof.ordinal()] = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", String.format(typename.toString(), "top")));
            this.bottomTexture[typeof.ordinal()] = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", String.format(typename.toString(), "bottom")));
            this.sideTexture[typeof.ordinal()] = register.func_94245_a(ResourceAccess.formatResourceName("${ASSET_KEY}:%s_${TEX_QUALITY}", String.format(typename.toString(), "side")));
        }
    }

    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < blockCraftingCount; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int func_149692_a(int damage) {
        return damage;
    }

    @Override
    public IBlockRenderInfo renderInfoBlock() {
        return renderInfo;
    }

    public int getBaseType(int metadata) {
        return (int)Math.floor(metadata / 1);
    }

    public StargateType getDHDType(int metadata) {
        return StargateType.fromOrdinal(this.getBaseType(metadata));
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float cx, float cy, float cz) {
        TileDHD te = (TileDHD)world.func_147438_o(x, y, z);
        if (te != null) {
            player.openGui((Object)LanteaCraft.instance, LCRuntime.runtime.interfaces().dhdUI.getGUIID(), world, x, y, z);
            return true;
        }
        return false;
    }

    @Override
    public void configure(ComponentConfig c) {
    }

    static {
        blockCraftingCount = blockCount = StargateType.count() * 1;
        renderInfo = new IBlockRenderInfo(){

            @Override
            public boolean doWorldRender(IBlockAccess access, int data, int x, int y, int z) {
                return true;
            }

            @Override
            public boolean doProperty(String property, IBlockAccess access, int data, int x, int y, int z, boolean def) {
                if (property.equalsIgnoreCase("noRender")) {
                    return false;
                }
                return def;
            }

            @Override
            public boolean doInventoryRender(int data) {
                return true;
            }
        };
    }
}

