/*
 * Decompiled with CFR 0.152.
 */
package lc.api.stargate;

import lc.common.stargate.StargateCharsetHelper;
import lc.common.util.data.PrimitiveCompare;
import lc.common.util.data.PrimitiveHelper;
import net.minecraft.nbt.NBTTagCompound;

public class StargateAddress {
    public static final StargateAddress VOID_ADDRESS = new StargateAddress("AAAAAAAAA");
    private char[] bytes;

    public StargateAddress(NBTTagCompound compound, String key) {
        this(compound.func_74779_i(key));
    }

    public StargateAddress(String address) {
        this(address.trim().toCharArray());
    }

    public StargateAddress(Character[] boxedBytes) {
        this(PrimitiveHelper.unbox(boxedBytes));
    }

    public StargateAddress(char[] bytes) {
        if (bytes.length != 7 && bytes.length != 9) {
            throw new ExceptionInInitializerError("Address must be 7 or 9 characters long, got " + bytes.length);
        }
        this.bytes = bytes;
    }

    public char[] getAddress() {
        return this.bytes;
    }

    public String getAddressString() {
        return new String(this.bytes);
    }

    public void toNBT(NBTTagCompound compound, String key) {
        compound.func_74778_a(key, this.getAddressString());
    }

    public long getILongValue() {
        return StargateCharsetHelper.singleton().addressToLong(this.bytes);
    }

    public boolean equals(Object o) {
        if (!(o instanceof StargateAddress)) {
            return false;
        }
        StargateAddress that = (StargateAddress)o;
        return PrimitiveCompare.compareChar(that.bytes, this.bytes);
    }
}

