/*
 * Decompiled with CFR 0.152.
 */
package lc.api.components;

import cpw.mods.fml.common.Loader;
import java.util.EnumSet;
import lc.api.components.IntegrationType;
import lc.common.LCLog;

public enum DriverMap {
    LANTEACRAFT("LanteaCraft", "LanteaCraft", "lc.common.impl.drivers.LanteaCraftPeripheralDriver", "lc.common.impl.drivers.LanteaCraftDriverManager", IntegrationType.COMPUTERS),
    COMPUTERCRAFT("ComputerCraft", "ComputerCraft", "lc.common.impl.drivers.ComputerCraftPeripheralDriver", "lc.common.impl.drivers.ComputerCraftDriverManager", IntegrationType.COMPUTERS),
    OPENCOMPUTERS("OpenComputers", "OpenComputers", "lc.common.impl.drivers.OpenComputersEnvironmentDriver", "lc.common.impl.drivers.OpenComputersDriverManager", IntegrationType.COMPUTERS);

    public final String modName;
    public final String modId;
    public final String className;
    public final String managerClassName;
    public Object managerObject;
    public final IntegrationType type;

    private DriverMap(String modName, String modId, String className, IntegrationType type) {
        this.modName = modName;
        this.modId = modId;
        this.className = className;
        this.managerClassName = null;
        this.type = type;
    }

    private DriverMap(String modName, String modId, String className, String managerClassName, IntegrationType type) {
        this.modName = modName;
        this.modId = modId;
        this.className = className;
        this.managerClassName = managerClassName;
        this.type = type;
    }

    public String toString() {
        return "DriverMapping{ mod: " + this.modName + " (" + this.modId + "): " + this.className + ", type " + (Object)((Object)this.type) + " }";
    }

    public void trySpinUpDriver() throws Exception {
        if (this.managerClassName == null || this.managerObject != null) {
            return;
        }
        Class<?> clazz = Class.forName(this.managerClassName);
        this.managerObject = clazz.newInstance();
    }

    public static void trySpinUpAll() {
        for (DriverMap mapping : DriverMap.values()) {
            if (!Loader.isModLoaded((String)mapping.modId)) continue;
            try {
                mapping.trySpinUpDriver();
            }
            catch (Exception e) {
                LCLog.warn("Failed to fallback spin-up needed driver %s (class %s).", mapping.modName, mapping.managerClassName);
            }
        }
    }

    public static EnumSet<DriverMap> mapOf(IntegrationType typeof) {
        EnumSet<DriverMap> map = EnumSet.noneOf(DriverMap.class);
        for (DriverMap mapping : DriverMap.values()) {
            if (!mapping.type.equals((Object)typeof)) continue;
            if (Loader.isModLoaded((String)mapping.modId)) {
                map.add(mapping);
                continue;
            }
            LCLog.debug(new Object[]{"Not loading driver %s", mapping});
        }
        return map;
    }
}

