/*
 * Decompiled with CFR 0.152.
 */
package lc;

import cpw.mods.fml.common.event.FMLFingerprintViolationEvent;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerAboutToStartEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppedEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import lc.BuildInfo;
import lc.LCInit;
import lc.LanteaCraft;
import lc.api.ILCAPIProxy;
import lc.api.IModInfo;
import lc.api.components.IRegistryContainer;
import lc.api.defs.HintProvider;
import lc.api.init.Biomes;
import lc.api.init.Blocks;
import lc.api.init.Dimensions;
import lc.api.init.Entities;
import lc.api.init.Interfaces;
import lc.api.init.Items;
import lc.api.init.Recipes;
import lc.api.init.Structures;
import lc.common.GUIHandler;
import lc.common.IHintProvider;
import lc.common.LCLog;
import lc.common.configuration.ConfigurationController;
import lc.common.impl.registry.DefinitionRegistry;
import lc.common.impl.registry.InterfaceRegistry;
import lc.common.impl.registry.RecipeRegistry;
import lc.common.impl.registry.RegistryContainer;
import lc.common.impl.registry.StructureRegistry;
import lc.common.network.LCNetworkController;
import lc.common.util.LCCreativeTabManager;
import lc.common.util.Tracer;
import lc.common.util.game.LCTickConnector;

public class LCRuntime
implements ILCAPIProxy {
    public static final LCRuntime runtime = new LCRuntime();
    private final Blocks blocks = new Blocks();
    private final Items items = new Items();
    private final Entities entities = new Entities();
    private final RegistryContainer registries = new RegistryContainer();
    private final Biomes biomes = new Biomes();
    private final Dimensions dimensions = new Dimensions();
    private final Recipes recipes = new Recipes();
    private final Structures structures = new Structures();
    private final Interfaces interfaces = new Interfaces();
    private final LCInit container = new LCInit();
    private final ConfigurationController config = new ConfigurationController();
    private final LCNetworkController network = new LCNetworkController();
    private final LCTickConnector ticks = new LCTickConnector();
    private final GUIHandler interfaceHook = new GUIHandler();
    @HintProvider(serverClass="lc.server.HintProviderServer", clientClass="lc.client.HintProviderClient")
    private IHintProvider hints;

    private LCRuntime() {
    }

    @Override
    public IModInfo info() {
        return BuildInfo.$;
    }

    @Override
    public boolean signedState() {
        return BuildInfo.IS_SIGNED;
    }

    @Override
    public Blocks blocks() {
        return this.blocks;
    }

    @Override
    public Items items() {
        return this.items;
    }

    @Override
    public Entities entities() {
        return this.entities;
    }

    @Override
    public IRegistryContainer registries() {
        return this.registries;
    }

    @Override
    public Biomes biomes() {
        return this.biomes;
    }

    @Override
    public Dimensions dimensions() {
        return this.dimensions;
    }

    @Override
    public Recipes recipes() {
        return this.recipes;
    }

    @Override
    public Structures structures() {
        return this.structures;
    }

    @Override
    public Interfaces interfaces() {
        return this.interfaces;
    }

    public LCNetworkController network() {
        return this.network;
    }

    public LCTickConnector ticks() {
        return this.ticks;
    }

    public ConfigurationController config() {
        return this.config;
    }

    public IHintProvider hints() {
        return this.hints;
    }

    public void preinit(FMLPreInitializationEvent event) {
        LCLog.debug("LCRuntime entering phase preinit");
        Tracer.begin(this, "LCRuntime pre-initialization");
        this.config.initialize(event.getSuggestedConfigurationFile().getParentFile());
        LCCreativeTabManager.registerTab("LanteaCraft", null);
        this.container.preinit(this, event);
        this.hints.preInit();
        Tracer.end();
    }

    public void init(FMLInitializationEvent event) {
        LCLog.debug("LCRuntime entering phase init");
        Tracer.begin(this, "LCRuntime initialization");
        this.container.init(this, event);
        this.network.init(this, event);
        ((DefinitionRegistry)this.registries().definitions()).init(this, event);
        ((RecipeRegistry)this.registries().recipes()).init(this, event);
        ((StructureRegistry)this.registries().structures()).init(this, event);
        ((InterfaceRegistry)this.registries().interfaces()).init(this, event);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)LanteaCraft.instance, (IGuiHandler)this.interfaceHook);
        this.hints.init();
        Tracer.end();
    }

    public void postinit(FMLPostInitializationEvent event) {
        LCLog.debug("LCRuntime entering phase postinit");
        Tracer.begin(this, "LCRuntime post-initialization");
        this.container.postinit(this, event);
        this.hints.postInit();
        this.config.commit();
        Tracer.end();
    }

    public void serverStarting(FMLServerStartingEvent event) {
        Tracer.begin(this, "serverStarting");
        this.hints.serverStarting(event);
        Tracer.end();
    }

    public void serverStopping(FMLServerStoppingEvent event) {
        Tracer.begin(this, "serverStopping");
        this.hints.serverStopping(event);
        Tracer.end();
    }

    public void signatureViolation(FMLFingerprintViolationEvent event) {
        Tracer.begin(this, "signatureViolation");
        this.hints.signatureViolation(event);
        Tracer.end();
    }

    public void receiveIMC(FMLInterModComms.IMCEvent event) {
        this.hints.receiveIMC(event);
    }

    public void serverStopped(FMLServerStoppedEvent event) {
        Tracer.begin(this, "serverStopped");
        this.hints.serverStopped(event);
        Tracer.end();
    }

    public void serverStarted(FMLServerStartedEvent event) {
        Tracer.begin(this, "serverStarted");
        this.hints.serverStarted(event);
        Tracer.end();
    }

    public void beforeServerStarting(FMLServerAboutToStartEvent event) {
        Tracer.begin(this, "beforeServerStarting");
        this.hints.beforeServerStarting(event);
        Tracer.end();
    }
}

