/*
 * Decompiled with CFR 0.152.
 */
package lc;

import cpw.mods.fml.common.CertificateHelper;
import java.security.CodeSource;
import java.security.cert.Certificate;
import lc.api.IModInfo;
import lc.common.resource.ResourceAccess;

public class BuildInfo
implements IModInfo {
    public static final String modName = "LanteaCraft";
    public static final String modID = "LanteaCraft";
    public static final String CERT = "".replace(":", "");
    public static final String versionNumber = "1.0.0";
    public static final String buildNumber = "23";
    public static final String webAPI = "http://lanteacraft.com/api/";
    public static final BuildInfo $ = new BuildInfo();
    public static boolean DEBUG;
    public static boolean DEBUG_MASQ;
    private static final boolean IS_DEV_ENV;
    public static final boolean IS_SIGNED;

    private BuildInfo init() {
        DEBUG_MASQ = DEBUG = IS_DEV_ENV;
        return this;
    }

    private boolean signed() {
        try {
            Class<?> me = this.getClass();
            CodeSource source = me.getProtectionDomain().getCodeSource();
            Certificate[] certs = source.getCertificates();
            if (certs == null || certs.length <= 0) {
                return false;
            }
            return CertificateHelper.getFingerprint((Certificate)certs[0]).equalsIgnoreCase(CERT);
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public int build() {
        try {
            return Integer.parseInt(buildNumber);
        }
        catch (Throwable t) {
            return 0;
        }
    }

    @Override
    public boolean development() {
        return IS_DEV_ENV;
    }

    @Override
    public String assets() {
        return ResourceAccess.getAssetKey();
    }

    static {
        IS_DEV_ENV = $.build() == 0;
        IS_SIGNED = $.signed();
        $.init();
    }
}

