/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Interfaces.TargetEntity;
import Reika.RotaryCraft.Base.TileEntity.TileEntityAimedCannon;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public class TileEntityLaserGun
extends TileEntityAimedCannon {
    private int range;

    @Override
    public int getRange() {
        return this.range;
    }

    @Override
    public int getMaxRange() {
        return 256;
    }

    @Override
    public boolean hasAmmo() {
        return true;
    }

    @Override
    protected double[] getTarget(World world, int x, int y, int z) {
        double[] xyzb = new double[4];
        int r = this.getRange();
        AxisAlignedBB box = AxisAlignedBB.func_72330_a((double)(x - r), (double)(y - r), (double)(z - r), (double)(x + 1 + r), (double)(y + 1 + r), (double)(z + 1 + r));
        List inrange = world.func_72872_a(Entity.class, box);
        double mindist = this.getRange() + 2;
        Entity i_at_min = null;
        for (Entity ent : inrange) {
            double dy;
            double reqtheta;
            double dist = ReikaMathLibrary.py3d((double)(ent.field_70165_t - (double)x - 0.5), (double)(ent.field_70163_u - (double)y - 0.5), (double)(ent.field_70161_v - (double)z - 0.5));
            if (!this.isValidTarget(ent) || !ReikaWorldHelper.canBlockSee((World)world, (int)x, (int)y, (int)z, (double)ent.field_70165_t, (double)ent.field_70163_u, (double)ent.field_70161_v, (double)this.getRange()) || !((reqtheta = -90.0 + Math.toDegrees(Math.abs(Math.acos((dy = -(ent.field_70163_u - (double)y)) / dist)))) <= (double)(this.dir * -10) && this.dir == -1) && (!(reqtheta >= (double)(this.dir * -10)) || this.dir != 1) || !(dist < mindist)) continue;
            mindist = dist;
            i_at_min = ent;
        }
        if (i_at_min == null) {
            return xyzb;
        }
        this.closestMob = i_at_min;
        xyzb[0] = this.closestMob.field_70165_t + this.randomOffset();
        xyzb[1] = this.closestMob.field_70163_u + (double)this.closestMob.func_70047_e() * 0.25 + this.randomOffset();
        xyzb[2] = this.closestMob.field_70161_v + this.randomOffset();
        xyzb[3] = 1.0;
        return xyzb;
    }

    @Override
    public void fire(World world, double[] xyz) {
        if (world.field_72995_K) {
            return;
        }
        for (float i = 0.0f; i <= (float)this.getMaxRange(); i += 0.5f) {
            double dx = (double)i * Math.cos(Math.toRadians(this.theta)) * Math.cos(Math.toRadians(-this.phi + 90.0f));
            double dy = (double)i * Math.sin(Math.toRadians(this.theta));
            double dz = (double)i * Math.cos(Math.toRadians(this.theta)) * Math.sin(Math.toRadians(-this.phi + 90.0f));
            boolean r = true;
            AxisAlignedBB light = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + dx), (double)((double)this.field_145848_d + dy), (double)((double)this.field_145849_e + dz), (double)((double)this.field_145851_c + dx), (double)((double)this.field_145848_d + dy), (double)((double)this.field_145849_e + dz)).func_72314_b((double)r, (double)r, (double)r);
            List in = world.func_72872_a(Entity.class, light);
            for (Entity e : in) {
                if (e instanceof TargetEntity) {
                    ((TargetEntity)e).onLaserBeam((TileEntity)this);
                }
                if (!(e instanceof EntityLivingBase)) continue;
                e.func_70097_a(DamageSource.field_76371_c, 4.0f);
                e.func_70015_d(7);
            }
            int x = this.field_145851_c + (int)dx;
            int y = this.field_145848_d + (int)dy;
            int z = this.field_145849_e + (int)dz;
            Block id = world.func_147439_a(x, y, z);
            int meta = world.func_72805_g(x, y, z);
            Block id2 = this.getAffectedID(id, meta);
            int meta2 = this.getAffectedMetadata(id2, meta);
            if (ConfigRegistry.ATTACKBLOCKS.getState()) {
                if (id2 != id || meta2 != meta) {
                    world.func_147465_d(x, y, z, id2, meta2, 3);
                    world.func_147471_g(x, y, z);
                    this.setRange((int)i + 1);
                    return;
                }
                if (id == Blocks.field_150424_aL) {
                    world.func_72885_a(null, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 3.0f, true, true);
                    world.func_147471_g(x, y, z);
                    this.setRange((int)i + 1);
                    return;
                }
                if (id == Blocks.field_150335_W) {
                    world.func_147468_f(x, y, z);
                    EntityTNTPrimed var6 = new EntityTNTPrimed(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, null);
                    world.func_72838_d((Entity)var6);
                    world.func_72956_a((Entity)var6, "random.fuse", 1.0f, 1.0f);
                    world.func_72869_a("lava", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), 0.0, 0.0, 0.0);
                    this.setRange((int)i + 1);
                    return;
                }
            }
            if (id != Blocks.field_150350_a && id.func_149662_c()) {
                this.setRange((int)i + 1);
                return;
            }
            if (i != (float)this.getMaxRange()) continue;
            this.setRange(this.getMaxRange());
        }
    }

    private Block getAffectedID(Block id, int meta) {
        if (id == Blocks.field_150350_a) {
            return Blocks.field_150350_a;
        }
        if (id == Blocks.field_150354_m) {
            return Blocks.field_150359_w;
        }
        if (id == Blocks.field_150348_b || id == Blocks.field_150417_aV || id == Blocks.field_150322_A) {
            return Blocks.field_150356_k;
        }
        if (id == Blocks.field_150349_c || id == Blocks.field_150391_bh) {
            return Blocks.field_150346_d;
        }
        if (id == Blocks.field_150346_d || id == Blocks.field_150458_ak) {
            return Blocks.field_150354_m;
        }
        if (id == Blocks.field_150347_e) {
            return Blocks.field_150356_k;
        }
        if (id == Blocks.field_150351_n) {
            return Blocks.field_150347_e;
        }
        if (id == Blocks.field_150351_n) {
            return Blocks.field_150347_e;
        }
        if (id == Blocks.field_150329_H || id == Blocks.field_150321_G || id == Blocks.field_150327_N || id == Blocks.field_150433_aE || id == Blocks.field_150328_O || id == Blocks.field_150337_Q || id == Blocks.field_150338_P || id == Blocks.field_150330_I || id == Blocks.field_150464_aj || id == Blocks.field_150459_bM || id == Blocks.field_150469_bN || id == Blocks.field_150395_bd || id == Blocks.field_150394_bc || id == Blocks.field_150393_bb || id == Blocks.field_150392_bi) {
            return Blocks.field_150350_a;
        }
        if (ReikaWorldHelper.flammable((Block)id)) {
            return Blocks.field_150480_ab;
        }
        if (id == Blocks.field_150432_aD || id == Blocks.field_150433_aE) {
            return Blocks.field_150358_i;
        }
        return id;
    }

    private int getAffectedMetadata(Block id, int meta) {
        return meta;
    }

    private void setRange(int i) {
        this.range = i;
    }

    @Override
    protected double randomOffset() {
        return 0.0;
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.LASERGUN;
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        if (this.power < this.MINPOWER) {
            this.setRange(0);
            return;
        }
        this.setRange(this.getMaxRange());
        if (this.tickcount < 0) {
            return;
        }
        this.tickcount = 0;
        this.fire(world, null);
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    protected boolean isValidTarget(Entity ent) {
        if (ent.field_70128_L) {
            return false;
        }
        if (ent instanceof TargetEntity) {
            return ((TargetEntity)ent).shouldTarget((TileEntity)this, this.placerUUID);
        }
        if (!(ent instanceof EntityLivingBase)) {
            return false;
        }
        EntityLivingBase elb = (EntityLivingBase)ent;
        return elb.func_110143_aJ() > 0.0f && this.isMobOrUnlistedPlayer(elb);
    }
}

