/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Weaponry;

import Reika.DragonAPI.Interfaces.Block.SemiTransparent;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.RotaryCraft.API.Interfaces.Laserable;
import Reika.RotaryCraft.Auxiliary.Interfaces.RangedEffect;
import Reika.RotaryCraft.Base.TileEntity.TileEntityBeamMachine;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.RotaryAchievements;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHeatRay
extends TileEntityBeamMachine
implements RangedEffect {
    public static final int FALLOFF = 256;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        ++this.tickcount;
        this.power = (long)this.omega * (long)this.torque;
        this.getIOSides(world, x, y, z, meta);
        this.getPower(false);
        this.scorch(world, x, y, z, meta);
    }

    private void scorch(World world, int x, int y, int z, int metadata) {
        boolean blocked = false;
        if (this.power >= this.MINPOWER) {
            int step;
            int maxdist = this.getRange();
            for (step = 1; !(step >= maxdist || step >= this.getMaxRange() && this.getMaxRange() != -1 || blocked); ++step) {
                int dx = x + step * this.facing.offsetX;
                int dy = y + step * this.facing.offsetY;
                int dz = z + step * this.facing.offsetZ;
                Block id = world.func_147439_a(dx, dy, dz);
                int meta2 = world.func_72805_g(dx, dy, dz);
                if (id != Blocks.field_150350_a && id.isFlammable((IBlockAccess)world, dx, dy, dz, ForgeDirection.UP)) {
                    this.ignite(world, dx, dy, dz, metadata, step);
                }
                if (this.makeBeam(world, x, y, z, step, id, meta2, maxdist)) {
                    blocked = true;
                    this.tickcount = 0;
                }
                if (id != world.func_147439_a(dx, dy, dz) || meta2 != world.func_72805_g(dx, dy, dz)) {
                    world.func_147471_g(dx, dy, dz);
                }
                if (id instanceof SemiTransparent) {
                    SemiTransparent st = (SemiTransparent)id;
                    if (!st.isOpaque(meta2)) continue;
                    blocked = true;
                    continue;
                }
                if (!id.func_149662_c()) continue;
                blocked = true;
            }
            AxisAlignedBB zone = this.getBurnZone(metadata, step);
            List inzone = this.field_145850_b.func_72872_a(Entity.class, zone);
            for (Entity caught : inzone) {
                if (!(caught instanceof EntityItem)) {
                    caught.func_70015_d(this.getBurnTime());
                }
                if (caught instanceof EntityTNTPrimed) {
                    world.func_72869_a("lava", caught.field_70165_t + (double)rand.nextFloat(), caught.field_70163_u + (double)rand.nextFloat(), caught.field_70161_v + (double)rand.nextFloat(), 0.0, 0.0, 0.0);
                }
                if (!(caught instanceof Laserable)) continue;
                ((Laserable)caught).whenInBeam(world, MathHelper.func_76128_c((double)caught.field_70165_t), MathHelper.func_76128_c((double)caught.field_70163_u), MathHelper.func_76128_c((double)caught.field_70161_v), this.power, step);
            }
        }
    }

    public int getBurnTime() {
        return 2 + (int)(16L * this.power / this.MINPOWER);
    }

    @Override
    public int getRange() {
        int r = (int)(8L + (this.power - this.MINPOWER) / 256L);
        if (r > this.getMaxRange()) {
            return this.getMaxRange();
        }
        return r;
    }

    private AxisAlignedBB getBurnZone(int meta, int step) {
        int minx = 0;
        int miny = 0;
        int minz = 0;
        int maxx = 0;
        int maxy = 0;
        int maxz = 0;
        switch (meta) {
            case 0: {
                minx = this.field_145851_c - step;
                maxx = this.field_145851_c - 1;
                miny = this.field_145848_d;
                maxy = this.field_145848_d;
                minz = this.field_145849_e;
                maxz = this.field_145849_e;
                break;
            }
            case 1: {
                minx = this.field_145851_c + 1;
                maxx = this.field_145851_c + step;
                miny = this.field_145848_d;
                maxy = this.field_145848_d + 1;
                minz = this.field_145849_e;
                maxz = this.field_145849_e + 1;
                break;
            }
            case 2: {
                maxz = this.field_145849_e + step;
                minz = this.field_145849_e + 1;
                miny = this.field_145848_d;
                maxy = this.field_145848_d + 1;
                minx = this.field_145851_c;
                maxx = this.field_145851_c + 1;
                break;
            }
            case 3: {
                maxz = this.field_145849_e - 1;
                minz = this.field_145849_e - step;
                miny = this.field_145848_d;
                maxy = this.field_145848_d + 1;
                minx = this.field_145851_c;
                maxx = this.field_145851_c + 1;
                break;
            }
            case 4: {
                miny = this.field_145848_d;
                maxz = this.field_145849_e + 1;
                miny = this.field_145848_d + 1;
                maxy = this.field_145848_d + step;
                minx = this.field_145851_c;
                maxx = this.field_145851_c + 1;
                break;
            }
            case 5: {
                minz = this.field_145849_e;
                maxz = this.field_145849_e + 1;
                miny = this.field_145848_d - 1;
                maxy = this.field_145848_d - step - 1;
                minx = this.field_145851_c;
                maxx = this.field_145851_c + 1;
            }
        }
        return AxisAlignedBB.func_72330_a((double)minx, (double)miny, (double)minz, (double)maxx, (double)maxy, (double)maxz);
    }

    private void ignite(World world, int x, int y, int z, int metadata, int step) {
        if (world.func_147439_a(x + 1, y, z) == Blocks.field_150350_a) {
            world.func_147449_b(x + 1, y, z, (Block)Blocks.field_150480_ab);
        }
        if (world.func_147439_a(x - 1, y, z) == Blocks.field_150350_a) {
            world.func_147449_b(x - 1, y, z, (Block)Blocks.field_150480_ab);
        }
        if (world.func_147439_a(x, y + 1, z) == Blocks.field_150350_a) {
            world.func_147449_b(x, y + 1, z, (Block)Blocks.field_150480_ab);
        }
        if (world.func_147439_a(x, y - 1, z) == Blocks.field_150350_a) {
            world.func_147449_b(x, y - 1, z, (Block)Blocks.field_150480_ab);
        }
        if (world.func_147439_a(x, y, z + 1) == Blocks.field_150350_a) {
            world.func_147449_b(x, y, z + 1, (Block)Blocks.field_150480_ab);
        }
        if (world.func_147439_a(x, y, z - 1) == Blocks.field_150350_a) {
            world.func_147449_b(x, y, z - 1, (Block)Blocks.field_150480_ab);
        }
    }

    private boolean makeBeam(World world, int x, int y, int z, int step, Block id, int metadata, int maxdist) {
        TileEntity te;
        boolean value = false;
        if (id == Blocks.field_150350_a) {
            return false;
        }
        if (id.hasTileEntity(metadata) && (te = world.func_147438_o(x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ)) instanceof Laserable) {
            ((Laserable)te).whenInBeam(world, x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ, this.power, step);
            if (((Laserable)te).blockBeam(world, x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ, this.power)) {
                return true;
            }
        }
        if (ConfigRegistry.ATTACKBLOCKS.getState()) {
            if (id == Blocks.field_150348_b || id == Blocks.field_150347_e || id == Blocks.field_150417_aV || id == Blocks.field_150322_A) {
                int chance = (int)((this.power - this.MINPOWER) / (long)(1024 * step * 2));
                if (rand.nextInt(chance = ReikaMathLibrary.extrema((int)chance, (int)1, (String)"max")) != 0 && rand.nextInt(step) == 0) {
                    world.func_147449_b(x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ, (Block)Blocks.field_150356_k);
                }
                world.func_72869_a("lava", (double)((float)(x + step * this.facing.offsetX) + rand.nextFloat()), (double)((float)(y + step * this.facing.offsetY) + rand.nextFloat()), (double)((float)(z + step * this.facing.offsetZ) + rand.nextFloat()), 0.0, 0.0, 0.0);
            }
            if (id == Blocks.field_150354_m) {
                int chance = (int)((this.power - this.MINPOWER) / (long)(1024 * step * 1));
                if (rand.nextInt(chance = ReikaMathLibrary.extrema((int)chance, (int)1, (String)"max")) != 0 && rand.nextInt(step) == 0) {
                    world.func_147449_b(x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ, Blocks.field_150359_w);
                }
            }
            if (id == Blocks.field_150351_n) {
                int chance = (int)((this.power - this.MINPOWER) / (long)(1024 * step * 1));
                if (rand.nextInt(chance = ReikaMathLibrary.extrema((int)chance, (int)1, (String)"max")) != 0 && rand.nextInt(step) == 0) {
                    world.func_147449_b(x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ, Blocks.field_150347_e);
                }
            }
            if (id == Blocks.field_150424_aL && this.tickcount >= 6) {
                world.func_72885_a(null, (double)(x + step * this.facing.offsetX) + 0.5, (double)(y + step * this.facing.offsetY) + 0.5, (double)(z + step * this.facing.offsetZ) + 0.5, 3.0f, true, true);
                if (world.field_73011_w.field_76574_g == -1 && step >= 500) {
                    RotaryAchievements.NETHERHEATRAY.triggerAchievement(this.getPlacer());
                }
                step = maxdist;
                value = true;
            }
            if (id == Blocks.field_150346_d || id == Blocks.field_150458_ak) {
                int chance = (int)((this.power - this.MINPOWER) / (long)(1024 * step * 1));
                if (rand.nextInt(chance = ReikaMathLibrary.extrema((int)chance, (int)1, (String)"max")) != 0 && rand.nextInt(step) == 0) {
                    world.func_147449_b(x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ, (Block)Blocks.field_150354_m);
                }
            }
            if (id == Blocks.field_150349_c || id == Blocks.field_150391_bh) {
                int chance = (int)((this.power - this.MINPOWER) / (long)(1024 * step * 2));
                if (rand.nextInt(chance = ReikaMathLibrary.extrema((int)chance, (int)1, (String)"max")) != 0 && rand.nextInt(step) == 0) {
                    world.func_147449_b(x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ, Blocks.field_150346_d);
                }
            }
            if (id == Blocks.field_150432_aD || id == Blocks.field_150433_aE) {
                int chance = (int)((this.power - this.MINPOWER) / (long)(1024 * step / 4));
                if (rand.nextInt(chance = ReikaMathLibrary.extrema((int)chance, (int)1, (String)"max")) != 0 && rand.nextInt(step) == 0) {
                    world.func_147449_b(x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ, (Block)Blocks.field_150358_i);
                }
            }
            if (id == Blocks.field_150329_H || id == Blocks.field_150321_G || id == Blocks.field_150327_N || id == Blocks.field_150433_aE || id == Blocks.field_150328_O || id == Blocks.field_150337_Q || id == Blocks.field_150338_P || id == Blocks.field_150330_I || id == Blocks.field_150464_aj || id == Blocks.field_150459_bM || id == Blocks.field_150469_bN || id == Blocks.field_150395_bd || id == Blocks.field_150394_bc || id == Blocks.field_150393_bb || id == Blocks.field_150392_bi) {
                int chance = (int)((this.power - this.MINPOWER) / (long)(1024 * step / 8));
                if (rand.nextInt(chance = ReikaMathLibrary.extrema((int)chance, (int)1, (String)"max")) != 0 && rand.nextInt(step) == 0) {
                    world.func_147468_f(x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ);
                    if (id == Blocks.field_150433_aE) {
                        world.func_72908_a((double)(x + step * this.facing.offsetX) + 0.5, (double)(y + step * this.facing.offsetY) + 0.5, (double)(z + step * this.facing.offsetZ) + 0.5, "random.fizz", 0.5f, 2.6f + (rand.nextFloat() - rand.nextFloat()) * 0.8f);
                    }
                }
            }
            if (id == Blocks.field_150358_i || id == Blocks.field_150355_j) {
                int chance = (int)((this.power - this.MINPOWER) / (long)(1024 * step / 8));
                if (rand.nextInt(chance = ReikaMathLibrary.extrema((int)chance, (int)1, (String)"max")) != 0 && rand.nextInt(step) == 0) {
                    world.func_147468_f(x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ);
                    world.func_72908_a((double)(x + step * this.facing.offsetX) + 0.5, (double)(y + step * this.facing.offsetY) + 0.5, (double)(z + step * this.facing.offsetZ) + 0.5, "random.fizz", 0.5f, 2.6f + (rand.nextFloat() - rand.nextFloat()) * 0.8f);
                }
            }
            if (id == Blocks.field_150335_W) {
                world.func_147468_f(x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ);
                EntityTNTPrimed var6 = new EntityTNTPrimed(world, (double)(x + step * this.facing.offsetX) + 0.5, (double)(y + step * this.facing.offsetY) + 0.5, (double)(z + step * this.facing.offsetZ) + 0.5, null);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)var6);
                }
                world.func_72956_a((Entity)var6, "random.fuse", 1.0f, 1.0f);
                world.func_72869_a("lava", (double)((float)(x + step * this.facing.offsetX) + rand.nextFloat()), (double)((float)(y + step * this.facing.offsetY) + rand.nextFloat()), (double)((float)(z + step * this.facing.offsetZ) + rand.nextFloat()), 0.0, 0.0, 0.0);
            }
            if (id instanceof Laserable) {
                ((Laserable)id).whenInBeam(world, x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ, this.power, step);
                if (((Laserable)id).blockBeam(world, x + step * this.facing.offsetX, y + step * this.facing.offsetY, z + step * this.facing.offsetZ, this.power)) {
                    return true;
                }
            }
        }
        return value;
    }

    @Override
    protected void makeBeam(World world, int x, int y, int z, int meta) {
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.HEATRAY;
    }

    @Override
    public int getMaxRange() {
        return Math.max(64, ConfigRegistry.HEATRAYRANGE.getValue());
    }

    public int getRedstoneOverride() {
        return 0;
    }
}

