/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Interfaces.TileEntity.GuiController;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntity1DTransmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPowerBus;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBevelGear
extends TileEntity1DTransmitter
implements GuiController {
    public int direction;

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.power = (long)this.omega * (long)this.torque;
        this.getIOSides(world, x, y, z);
        this.transferPower(world, x, y, z, meta);
        this.basicPowerReceiver();
    }

    public void getIOSides(World world, int x, int y, int z) {
        switch (this.direction) {
            case 0: {
                this.read = ForgeDirection.WEST;
                this.write = ForgeDirection.NORTH;
                break;
            }
            case 1: {
                this.read = ForgeDirection.NORTH;
                this.write = ForgeDirection.EAST;
                break;
            }
            case 2: {
                this.read = ForgeDirection.EAST;
                this.write = ForgeDirection.SOUTH;
                break;
            }
            case 3: {
                this.read = ForgeDirection.SOUTH;
                this.write = ForgeDirection.WEST;
                break;
            }
            case 4: {
                this.read = ForgeDirection.WEST;
                this.write = ForgeDirection.SOUTH;
                break;
            }
            case 5: {
                this.read = ForgeDirection.NORTH;
                this.write = ForgeDirection.WEST;
                break;
            }
            case 6: {
                this.write = ForgeDirection.NORTH;
                this.read = ForgeDirection.EAST;
                break;
            }
            case 7: {
                this.read = ForgeDirection.SOUTH;
                this.write = ForgeDirection.EAST;
                break;
            }
            case 8: {
                this.read = ForgeDirection.WEST;
                this.write = ForgeDirection.UP;
                break;
            }
            case 9: {
                this.read = ForgeDirection.NORTH;
                this.write = ForgeDirection.UP;
                break;
            }
            case 10: {
                this.read = ForgeDirection.EAST;
                this.write = ForgeDirection.UP;
                break;
            }
            case 11: {
                this.read = ForgeDirection.SOUTH;
                this.write = ForgeDirection.UP;
                break;
            }
            case 12: {
                this.read = ForgeDirection.DOWN;
                this.write = ForgeDirection.WEST;
                break;
            }
            case 13: {
                this.read = ForgeDirection.DOWN;
                this.write = ForgeDirection.NORTH;
                break;
            }
            case 14: {
                this.read = ForgeDirection.DOWN;
                this.write = ForgeDirection.EAST;
                break;
            }
            case 15: {
                this.read = ForgeDirection.DOWN;
                this.write = ForgeDirection.SOUTH;
                break;
            }
            case 16: {
                this.write = ForgeDirection.DOWN;
                this.read = ForgeDirection.WEST;
                break;
            }
            case 17: {
                this.write = ForgeDirection.DOWN;
                this.read = ForgeDirection.NORTH;
                break;
            }
            case 18: {
                this.write = ForgeDirection.DOWN;
                this.read = ForgeDirection.EAST;
                break;
            }
            case 19: {
                this.write = ForgeDirection.DOWN;
                this.read = ForgeDirection.SOUTH;
                break;
            }
            case 20: {
                this.read = ForgeDirection.UP;
                this.write = ForgeDirection.WEST;
                break;
            }
            case 21: {
                this.read = ForgeDirection.UP;
                this.write = ForgeDirection.NORTH;
                break;
            }
            case 22: {
                this.read = ForgeDirection.UP;
                this.write = ForgeDirection.EAST;
                break;
            }
            case 23: {
                this.read = ForgeDirection.UP;
                this.write = ForgeDirection.SOUTH;
            }
        }
    }

    @Override
    protected void transferPower(World world, int x, int y, int z, int meta) {
        TileEntity te;
        if (this.field_145850_b.field_72995_K && !RotaryAux.getPowerOnClient) {
            return;
        }
        this.torquein = 0;
        this.omegain = 0;
        boolean isCentered = x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e;
        int dx = x + this.read.offsetX;
        int dy = y + this.read.offsetY;
        int dz = z + this.read.offsetZ;
        MachineRegistry m = isCentered ? this.getMachine(this.read) : MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
        TileEntity tileEntity = te = isCentered ? this.getAdjacentTileEntity(this.read) : world.func_147438_o(dx, dy, dz);
        if (this.isProvider(te)) {
            ShaftPowerEmitter sp;
            TileEntityTransmissionMachine devicein;
            if (m == MachineRegistry.SHAFT) {
                devicein = (TileEntityShaft)te;
                if (((TileEntityShaft)devicein).isCross()) {
                    this.readFromCross((TileEntityShaft)devicein);
                    return;
                }
                if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntityShaft)devicein).torque;
                    this.omegain = ((TileEntityShaft)devicein).omega;
                }
            }
            if (te instanceof SimpleProvider) {
                this.copyStandardPower(te);
            }
            if (m == MachineRegistry.POWERBUS) {
                TileEntityPowerBus pwr = (TileEntityPowerBus)te;
                ForgeDirection dir = this.getInputForgeDirection().getOpposite();
                this.omegain = pwr.getSpeedToSide(dir);
                this.torquein = pwr.getTorqueToSide(dir);
            }
            if (te instanceof ShaftPowerEmitter && (sp = (ShaftPowerEmitter)te).isEmitting() && sp.canWriteTo(this.read.getOpposite())) {
                this.torquein = sp.getTorque();
                this.omegain = sp.getOmega();
            }
            if (m == MachineRegistry.SPLITTER) {
                devicein = (TileEntitySplitter)te;
                if (((TileEntitySplitter)devicein).isSplitting()) {
                    this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein);
                    this.torquein = this.torque;
                    this.omegain = this.omega;
                    return;
                }
                if (devicein.isWritingTo(this)) {
                    this.torquein = ((TileEntitySplitter)devicein).torque;
                    this.omegain = ((TileEntitySplitter)devicein).omega;
                }
            }
        } else if (te instanceof WorldRift) {
            WorldRift sr = (WorldRift)te;
            WorldLocation loc = sr.getLinkTarget();
            if (loc != null) {
                this.transferPower(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, meta);
            }
        } else {
            this.omega = 0;
            this.torque = 0;
            this.power = 0L;
            return;
        }
        this.omega = this.omegain;
        this.torque = this.torquein;
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("dir", this.direction);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.direction = NBT.func_74762_e("dir");
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.BEVELGEARS;
    }

    public int getRedstoneOverride() {
        return 0;
    }

    @Override
    public void onEMP() {
    }
}

