/*
 * Decompiled with CFR 0.152.
 */
package Reika.RotaryCraft.TileEntities.Transmission;

import Reika.ChromatiCraft.API.Interfaces.WorldRift;
import Reika.DragonAPI.Instantiable.Data.Immutable.WorldLocation;
import Reika.DragonAPI.Instantiable.HybridTank;
import Reika.DragonAPI.Instantiable.StepTimer;
import Reika.DragonAPI.Interfaces.TileEntity.InertIInv;
import Reika.DragonAPI.Interfaces.TileEntity.PartialInventory;
import Reika.DragonAPI.Interfaces.TileEntity.PartialTank;
import Reika.DragonAPI.Interfaces.TileEntity.ToggleTile;
import Reika.DragonAPI.Libraries.IO.ReikaSoundHelper;
import Reika.DragonAPI.Libraries.Java.ReikaRandomHelper;
import Reika.DragonAPI.Libraries.MathSci.ReikaEngLibrary;
import Reika.DragonAPI.Libraries.MathSci.ReikaMathLibrary;
import Reika.DragonAPI.Libraries.Registry.ReikaItemHelper;
import Reika.DragonAPI.Libraries.Registry.ReikaParticleHelper;
import Reika.DragonAPI.Libraries.ReikaInventoryHelper;
import Reika.DragonAPI.Libraries.ReikaNBTHelper;
import Reika.DragonAPI.Libraries.World.ReikaWorldHelper;
import Reika.RotaryCraft.API.Interfaces.CVTController;
import Reika.RotaryCraft.API.Power.PowerGenerator;
import Reika.RotaryCraft.API.Power.ShaftMerger;
import Reika.RotaryCraft.Auxiliary.Interfaces.PipeConnector;
import Reika.RotaryCraft.Auxiliary.Interfaces.PowerSourceTracker;
import Reika.RotaryCraft.Auxiliary.Interfaces.SimpleProvider;
import Reika.RotaryCraft.Auxiliary.ItemStacks;
import Reika.RotaryCraft.Auxiliary.PowerSourceList;
import Reika.RotaryCraft.Auxiliary.RotaryAux;
import Reika.RotaryCraft.Auxiliary.ShaftPowerEmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntity1DTransmitter;
import Reika.RotaryCraft.Base.TileEntity.TileEntityPiping;
import Reika.RotaryCraft.Base.TileEntity.TileEntityTransmissionMachine;
import Reika.RotaryCraft.Registry.ConfigRegistry;
import Reika.RotaryCraft.Registry.DifficultyEffects;
import Reika.RotaryCraft.Registry.MachineRegistry;
import Reika.RotaryCraft.Registry.SoundRegistry;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityPowerBus;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntityShaft;
import Reika.RotaryCraft.TileEntities.Transmission.TileEntitySplitter;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileEntityAdvancedGear
extends TileEntity1DTransmitter
implements ISidedInventory,
PowerGenerator,
PartialInventory,
PartialTank,
PipeConnector,
IFluidHandler,
ToggleTile,
CVTController.CVTControllable {
    private boolean isReleasing = false;
    private int releaseTorque = 0;
    private int releaseOmega = 0;
    private long energy;
    public static final int WORMRATIO = 16;
    private CVTController controller;
    private ItemStack[] belts = new ItemStack[31];
    private final HybridTank lubricant = new HybridTank("advgear", 20000);
    private final CVTState[] cvtState = new CVTState[2];
    public boolean isRedstoneControlled;
    private boolean isBedrockCoil = false;
    private boolean isCreative;
    private StepTimer redstoneTimer = new StepTimer(40);
    public boolean torquemode = true;
    private boolean enabled = true;

    public static long getMaxStorageCapacity(boolean bedrock) {
        return bedrock ? 240L * ReikaMathLibrary.longpow((int)10, (int)12) : (long)(720 * ReikaMathLibrary.intpow2((int)10, (int)6));
    }

    public static String getMaxStorageCapacityFormatted(boolean bedrock) {
        long max = TileEntityAdvancedGear.getMaxStorageCapacity(bedrock);
        return String.format("%.3f%sJ", ReikaMathLibrary.getThousandBase((double)max), ReikaEngLibrary.getSIPrefix((double)max));
    }

    public static String getRequiredInputPower() {
        return "CEIL2((log_2(energy))^4)";
    }

    public static String getRequiredInputTorque() {
        return "CEIL2((log_2(energy))^3)";
    }

    public static int getOutputCap(boolean bedrock) {
        return bedrock ? 4096 : 1024;
    }

    public static String getOutputFunction() {
        return "CEIL2_pseudo(SQRT(energy)/4)";
    }

    @Override
    public void setController(CVTController c) {
        this.controller = c;
    }

    public long getMaxStorageCapacity() {
        return this.getGearType().storesEnergy() ? TileEntityAdvancedGear.getMaxStorageCapacity(this.isBedrockCoil) : 0L;
    }

    public void setBedrock(boolean bedrock) {
        this.isBedrockCoil = bedrock;
    }

    public void setCreative(boolean flag) {
        this.isCreative = flag;
    }

    public int getMaximumEmission() {
        return this.isCreative ? Integer.MAX_VALUE : TileEntityAdvancedGear.getOutputCap(this.isBedrockCoil());
    }

    public int getReleaseTorque() {
        return this.releaseTorque;
    }

    public int getReleaseOmega() {
        return this.releaseOmega;
    }

    public void setReleaseTorque(int torque) {
        this.releaseTorque = Math.min(this.getTorqueCap(), Math.min(this.getMaximumEmission(), torque));
    }

    public void setReleaseOmega(int omega) {
        this.releaseOmega = Math.min(this.getMaximumEmission(), omega);
    }

    public GearType getGearType() {
        int meta = this.func_145832_p();
        return GearType.list[meta / 4];
    }

    public int getLubricant() {
        return this.lubricant.getLevel();
    }

    public void addLubricant(int amt) {
        this.lubricant.addLiquid(amt, FluidRegistry.getFluid((String)"rc lubricant"));
    }

    public boolean hasLubricant() {
        return !this.lubricant.isEmpty();
    }

    public boolean canAcceptAnotherLubricantBucket() {
        return this.lubricant.getLevel() + 1000 <= this.lubricant.getCapacity();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void readFromSplitter(World world, int x, int y, int z, TileEntitySplitter spl) {
        boolean favorbent;
        int sratio;
        block25: {
            block24: {
                block26: {
                    sratio = spl.getRatioFromMode();
                    if (sratio == 0) {
                        return;
                    }
                    favorbent = false;
                    if (sratio < 0) {
                        favorbent = true;
                        sratio = -sratio;
                    }
                    if (this.getGearType() == GearType.WORM || this.getGearType() == GearType.CVT && this.getEffectiveRatio() < 0.0) {
                        if (x == spl.getWriteX() && z == spl.getWriteZ()) {
                            this.omega = Math.abs((int)((double)spl.omega / this.getEffectiveRatio() * this.getPowerLossFraction(spl.omega)));
                            if (sratio == 1) {
                                this.torque = Math.abs((int)((double)(spl.torque / 2) * this.getEffectiveRatio()));
                                return;
                            }
                            if (favorbent) {
                                this.torque = Math.abs((int)((double)(spl.torque / sratio) * this.getEffectiveRatio()));
                                return;
                            }
                            this.torque = Math.abs((int)(this.getEffectiveRatio() * (double)((int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio)))));
                            return;
                        }
                        if (x == spl.getWriteX2() && z == spl.getWriteZ2()) {
                            this.omega = Math.abs((int)((double)spl.omega / this.getEffectiveRatio() * this.getPowerLossFraction(spl.omega)));
                            if (sratio == 1) {
                                this.torque = Math.abs((int)((double)(spl.torque / 2) * this.getEffectiveRatio()));
                                return;
                            }
                            if (favorbent) {
                                this.torque = Math.abs((int)(this.getEffectiveRatio() * (double)((int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio)))));
                                return;
                            }
                            this.torque = Math.abs((int)((double)(spl.torque / sratio) * this.getEffectiveRatio()));
                            return;
                        }
                        this.torque = 0;
                        this.omega = 0;
                        this.power = 0L;
                        return;
                    }
                    if (this.getGearType() != GearType.HIGH) break block25;
                    if (!this.hasLubricant()) {
                        this.torque = 0;
                        this.omega = 0;
                        return;
                    }
                    if (!(this.getEffectiveRatio() < 0.0)) break block26;
                    if (x == spl.getWriteX() && z == spl.getWriteZ()) {
                        this.omega = -((int)((double)spl.omega / this.getEffectiveRatio()));
                        this.torque = sratio == 1 ? Math.abs((int)((double)(spl.torque / 2) * this.getEffectiveRatio())) : (favorbent ? Math.abs((int)((double)(spl.torque / sratio) * this.getEffectiveRatio())) : Math.abs((int)(this.getEffectiveRatio() * (double)((int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio))))));
                        break block24;
                    } else if (x == spl.getWriteX2() && z == spl.getWriteZ2()) {
                        this.omega = -((int)((double)spl.omega / this.getEffectiveRatio()));
                        this.torque = sratio == 1 ? Math.abs((int)((double)(spl.torque / 2) * this.getEffectiveRatio())) : (favorbent ? Math.abs((int)(this.getEffectiveRatio() * (double)((int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio))))) : Math.abs((int)((double)(spl.torque / sratio) * this.getEffectiveRatio())));
                        break block24;
                    } else {
                        this.torque = 0;
                        this.omega = 0;
                        this.power = 0L;
                        return;
                    }
                }
                if (x == spl.getWriteX() && z == spl.getWriteZ()) {
                    this.omega = (int)((double)spl.omega * this.getEffectiveRatio());
                    this.torque = sratio == 1 ? (int)((double)(spl.torque / 2) / this.getEffectiveRatio()) : (favorbent ? (int)((double)(spl.torque / sratio) / this.getEffectiveRatio()) : (int)((double)spl.torque * ((double)sratio - 1.0) / (double)sratio / this.getEffectiveRatio()));
                } else if (x == spl.getWriteX2() && z == spl.getWriteZ2()) {
                    this.omega = (int)((double)spl.omega * this.getEffectiveRatio());
                    this.torque = sratio == 1 ? (int)((double)(spl.torque / 2) / this.getEffectiveRatio()) : (favorbent ? (int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio) / this.getEffectiveRatio()) : (int)((double)(spl.torque / sratio) / this.getEffectiveRatio()));
                } else {
                    this.torque = 0;
                    this.omega = 0;
                    this.power = 0L;
                    return;
                }
            }
            if (this.omega <= 0) return;
            if ((this.field_145850_b.func_82737_E() & 4L) != 4L) return;
            this.lubricant.removeLiquid((int)ReikaMathLibrary.logbase((long)Math.max(this.omega, this.torque), (int)2));
            return;
        }
        if (x == spl.getWriteX() && z == spl.getWriteZ()) {
            this.omega = (int)((double)spl.omega * this.getEffectiveRatio() * this.getPowerLossFraction(spl.omega));
            if (sratio == 1) {
                this.torque = (int)((double)(spl.torque / 2) / this.getEffectiveRatio());
                return;
            }
            if (favorbent) {
                this.torque = (int)((double)(spl.torque / sratio) / this.getEffectiveRatio());
                return;
            }
            this.torque = (int)((double)spl.torque * ((double)sratio - 1.0) / (double)sratio / this.getEffectiveRatio());
            return;
        }
        if (x == spl.getWriteX2() && z == spl.getWriteZ2()) {
            this.omega = (int)((double)spl.omega * this.getEffectiveRatio() * this.getPowerLossFraction(spl.omega));
            if (sratio == 1) {
                this.torque = (int)((double)(spl.torque / 2) / this.getEffectiveRatio());
                return;
            }
            if (favorbent) {
                this.torque = (int)((double)spl.torque * (((double)sratio - 1.0) / (double)sratio) / this.getEffectiveRatio());
                return;
            }
            this.torque = (int)((double)(spl.torque / sratio) / this.getEffectiveRatio());
            return;
        }
        this.torque = 0;
        this.omega = 0;
        this.power = 0L;
    }

    private double getEffectiveRatio() {
        GearType type = this.getGearType();
        if (type == GearType.COIL) {
            return 1.0;
        }
        if (type == GearType.WORM) {
            return 16.0;
        }
        if (type == GearType.HIGH) {
            return this.torquemode ? -256.0 : 256.0;
        }
        return this.getCVTRatio();
    }

    private int getCVTRatio() {
        if (this.isRedstoneControlled) {
            int ratio = this.getCVTState((boolean)this.hasRedstoneSignal()).gearRatio;
            return (int)Math.signum(ratio) * Math.min(Math.abs(ratio), this.getMaxRatio());
        }
        return this.ratio;
    }

    private double getPowerLossFraction(int speed) {
        if (this.getGearType() == GearType.WORM) {
            return (128.0 - 4.0 * ReikaMathLibrary.logbase((long)speed, (int)2)) / 100.0;
        }
        return 1.0;
    }

    public double getCurrentLoss() {
        return this.getPowerLossFraction(this.omegain);
    }

    public boolean func_70300_a(EntityPlayer var1) {
        if (this.getGearType() == GearType.WORM) {
            return false;
        }
        return this.isPlayerAccessible(var1);
    }

    public void updateEntity(World world, int x, int y, int z, int meta) {
        super.updateTileEntity();
        this.getIOSides(world, x, y, z, meta);
        if (this.getGearType() == GearType.CVT && this.controller != null && this.controller.isActive() && this.controller.getCVT().equals(this)) {
            boolean torque = this.controller.isTorque();
            int r = MathHelper.func_76125_a((int)this.controller.getControlledRatio(), (int)1, (int)32);
            int n = this.ratio = torque ? r : -r;
        }
        if (this.getGearType().storesEnergy()) {
            this.store(world, x, y, z, meta);
        } else {
            this.transferPower(world, x, y, z, meta);
        }
        this.power = (long)this.omega * (long)this.torque;
        this.basicPowerReceiver();
        if (this.getGearType().storesEnergy()) {
            this.redstoneTimer.update();
            if (this.redstoneTimer.checkCap()) {
                ReikaWorldHelper.causeAdjacentUpdates((World)world, (int)x, (int)y, (int)z);
            }
        }
    }

    public boolean isBedrockCoil() {
        return this.isBedrockCoil;
    }

    private void store(World world, int x, int y, int z, int meta) {
        this.transferPower(world, x, y, z, meta);
        boolean bl = this.isReleasing = this.enabled && this.hasRedstoneSignal();
        if (!this.isCreative && !world.field_72995_K && this.energy / 20L >= this.getMaxStorageCapacity()) {
            this.overChargeExplosion(world, x, y, z);
        }
        if (!this.isReleasing) {
            this.omega = 0;
            this.torque = 0;
            this.power = 0L;
            if (this.energy + (long)this.torquein * (long)this.omegain < 0L || this.energy + (long)this.torquein * (long)this.omegain > Long.MAX_VALUE) {
                this.destroy(world, x, y, z);
            } else if (!this.isCreative) {
                long pwr = (long)this.torquein * (long)this.omegain;
                if (this.torquein >= this.getChargingTorque() && pwr >= this.getChargingPower()) {
                    this.energy += pwr;
                }
            }
        } else if (this.energy > 0L && this.releaseTorque > 0 && this.releaseOmega > 0) {
            this.torque = this.releaseTorque = Math.min(this.releaseTorque, this.getTorqueCap());
            this.omega = this.releaseOmega;
            this.power = (long)this.torque * (long)this.omega;
            if (this.getTicksExisted() % 26 == 0) {
                SoundRegistry.COIL.playSoundAtBlock((TileEntity)this);
            }
            if (!this.isCreative) {
                this.energy -= this.power;
            }
            if (this.energy < 0L) {
                this.energy = 0L;
            }
        } else {
            this.torque = 0;
            this.omega = 0;
            this.power = 0L;
        }
    }

    public long getChargingPower() {
        return this.energy >= 20L ? (long)ReikaMathLibrary.ceil2exp((int)ReikaMathLibrary.intpow2((int)ReikaMathLibrary.logbase2((long)(this.energy / 20L)), (int)4)) : 1L;
    }

    public int getChargingTorque() {
        return this.energy >= 20L ? ReikaMathLibrary.ceil2exp((int)ReikaMathLibrary.intpow2((int)ReikaMathLibrary.logbase2((long)(this.energy / 20L)), (int)3)) / 2 : 1;
    }

    public int getTorqueCap() {
        return ReikaMathLibrary.ceilPseudo2Exp((int)((int)Math.ceil(Math.sqrt(this.energy / 20L) / 4.0)));
    }

    private void overChargeExplosion(World world, int x, int y, int z) {
        world.func_147468_f(x, y, z);
        int num = this.isBedrockCoil ? 24 : 3;
        int pow = this.isBedrockCoil ? 12 : 8;
        int r = this.isBedrockCoil ? 9 : 1;
        for (int i = 0; i < num; ++i) {
            double rx = ReikaRandomHelper.getRandomPlusMinus((int)x, (int)r);
            double ry = ReikaRandomHelper.getRandomPlusMinus((int)y, (int)r);
            double rz = ReikaRandomHelper.getRandomPlusMinus((int)z, (int)r);
            world.func_72876_a(null, rx, ry, rz, 8.0f, ConfigRegistry.BLOCKDAMAGE.getState());
        }
        world.func_72876_a(null, (double)x, (double)y, (double)z, (float)pow, ConfigRegistry.BLOCKDAMAGE.getState());
    }

    private void destroy(World world, int x, int y, int z) {
        for (int i = 0; i < 16; ++i) {
            ReikaSoundHelper.playSoundAtBlock((World)world, (int)x, (int)y, (int)z, (String)"random.explode", (float)5.0f, (float)0.2f);
        }
        ReikaParticleHelper.EXPLODE.spawnAroundBlock(world, x, y, z, 2);
        int r = 20;
        for (int i = -r; i <= r; ++i) {
            for (int j = -r; j <= r; ++j) {
                for (int k = -r; k <= r; ++k) {
                    double dd = ReikaMathLibrary.py3d((double)i, (double)(j * 2), (double)k);
                    if (dd <= (double)r + 0.5 && world.func_147439_a(x + i, y + j, z + k) != Blocks.field_150357_h) {
                        world.func_147468_f(x + i, y + j, z + k);
                        world.func_147471_g(x + i, y + j, z + k);
                    }
                    if (world.field_72995_K || rand.nextInt(8) != 0) continue;
                    ReikaWorldHelper.ignite((World)world, (int)(x + i), (int)(y + j), (int)(z + k));
                }
            }
        }
    }

    public void getIOSides(World world, int x, int y, int z, int metadata) {
        while (metadata > 3) {
            metadata -= 4;
        }
        super.getIOSides(world, x, y, z, metadata, false);
    }

    private void calculateRatio() {
        int sign = 1;
        if (this.ratio < 0) {
            sign = -1;
        }
        if (Math.abs(this.ratio) > this.getMaxRatio()) {
            this.ratio = this.getMaxRatio() * sign;
        }
        if (this.ratio == 0) {
            this.ratio = 1;
        }
    }

    public void setRatio(int ratio) {
        if (ratio == 0) {
            this.ratio = 1;
        } else {
            int sign = ratio < 0 ? -1 : 1;
            int maxrat = Math.min(Math.abs(ratio), this.getMaxRatio());
            this.ratio = maxrat * sign;
        }
    }

    public int getMaxRatio() {
        int i;
        if (this.belts[0] == null) {
            return 1;
        }
        if (this.belts[0].func_77973_b() != ItemStacks.belt.func_77973_b() || this.belts[0].func_77960_j() != ItemStacks.belt.func_77960_j()) {
            return 1;
        }
        for (i = 1; i <= 2; ++i) {
            if (this.belts[i] == null) {
                return 2;
            }
            if (this.belts[i].func_77973_b() == ItemStacks.belt.func_77973_b() && this.belts[i].func_77960_j() == ItemStacks.belt.func_77960_j()) continue;
            return 2;
        }
        for (i = 3; i <= 6; ++i) {
            if (this.belts[i] == null) {
                return 4;
            }
            if (this.belts[i].func_77973_b() == ItemStacks.belt.func_77973_b() && this.belts[i].func_77960_j() == ItemStacks.belt.func_77960_j()) continue;
            return 4;
        }
        for (i = 7; i <= 14; ++i) {
            if (this.belts[i] == null) {
                return 8;
            }
            if (this.belts[i].func_77973_b() == ItemStacks.belt.func_77973_b() && this.belts[i].func_77960_j() == ItemStacks.belt.func_77960_j()) continue;
            return 8;
        }
        for (i = 15; i <= 30; ++i) {
            if (this.belts[i] == null) {
                return 16;
            }
            if (this.belts[i].func_77973_b() == ItemStacks.belt.func_77973_b() && this.belts[i].func_77960_j() == ItemStacks.belt.func_77960_j()) continue;
            return 16;
        }
        return 32;
    }

    @Override
    protected void readFromCross(TileEntityShaft cross) {
        if (cross.isWritingTo(this)) {
            this.omega = cross.readomega[0];
            if (this.getGearType() == GearType.WORM) {
                this.omega = (int)((double)(this.omega / 16) * (100.0 - 4.0 * ReikaMathLibrary.logbase((long)this.omega, (int)2) + 28.0) / 100.0);
            }
            this.torque = cross.readtorque[0];
            if (this.getGearType() == GearType.WORM) {
                this.torque *= 16;
            }
        } else if (cross.isWritingTo2(this)) {
            this.omega = cross.readomega[1];
            if (this.getGearType() == GearType.WORM) {
                this.omega = (int)((double)(this.omega / 16) * (100.0 - 4.0 * ReikaMathLibrary.logbase((long)this.omega, (int)2) + 28.0) / 100.0);
            }
            this.torque = cross.readtorque[1];
            if (this.getGearType() == GearType.WORM) {
                this.torque *= 16;
            }
        } else {
            this.torque = 0;
            this.omega = 0;
            return;
        }
    }

    @Override
    protected void transferPower(World world, int x, int y, int z, int meta) {
        TileEntity te;
        this.calculateRatio();
        if (this.field_145850_b.field_72995_K && !RotaryAux.getPowerOnClient) {
            return;
        }
        this.performRatio = true;
        this.torquein = 0;
        this.omegain = 0;
        boolean isCentered = x == this.field_145851_c && y == this.field_145848_d && z == this.field_145849_e;
        int dx = x + this.read.offsetX;
        int dy = y + this.read.offsetY;
        int dz = z + this.read.offsetZ;
        MachineRegistry m = isCentered ? this.getMachine(this.read) : MachineRegistry.getMachine((IBlockAccess)world, dx, dy, dz);
        TileEntity tileEntity = te = isCentered ? this.getAdjacentTileEntity(this.read) : world.func_147438_o(dx, dy, dz);
        if (this.isProvider(te)) {
            ShaftPowerEmitter sp;
            TileEntityTransmissionMachine devicein;
            if (m == MachineRegistry.SHAFT) {
                devicein = (TileEntityShaft)te;
                if (((TileEntityShaft)devicein).isCross()) {
                    this.readFromCross((TileEntityShaft)devicein);
                    return;
                }
                if (devicein.isWritingToCoordinate(x, y, z)) {
                    this.torquein = ((TileEntityShaft)devicein).torque;
                    this.omegain = ((TileEntityShaft)devicein).omega;
                }
            }
            if (te instanceof SimpleProvider) {
                this.copyStandardPower(te);
            }
            if (te instanceof ShaftPowerEmitter && (sp = (ShaftPowerEmitter)te).isEmitting() && sp.canWriteTo(this.read.getOpposite())) {
                this.torquein = sp.getTorque();
                this.omegain = sp.getOmega();
            }
            if (m == MachineRegistry.POWERBUS) {
                TileEntityPowerBus pwr = (TileEntityPowerBus)te;
                ForgeDirection dir = this.getInputForgeDirection().getOpposite();
                this.omegain = pwr.getSpeedToSide(dir);
                this.torquein = pwr.getTorqueToSide(dir);
            }
            if (m == MachineRegistry.SPLITTER) {
                devicein = (TileEntitySplitter)te;
                if (((TileEntitySplitter)devicein).isSplitting()) {
                    this.readFromSplitter(world, x, y, z, (TileEntitySplitter)devicein);
                    this.performRatio = false;
                    this.torquein = this.torque;
                    this.omegain = this.omega;
                    return;
                }
                if (devicein.isWritingToCoordinate(x, y, z)) {
                    this.torquein = ((TileEntitySplitter)devicein).torque;
                    this.omegain = ((TileEntitySplitter)devicein).omega;
                }
            }
        } else if (te instanceof WorldRift) {
            WorldRift sr = (WorldRift)te;
            WorldLocation loc = sr.getLinkTarget();
            if (loc != null) {
                this.transferPower(loc.getWorld(), loc.xCoord, loc.yCoord, loc.zCoord, meta);
            }
        } else {
            this.omega = 0;
            this.torque = 0;
            this.power = 0L;
            return;
        }
        if (this.performRatio) {
            switch (this.getGearType()) {
                case WORM: {
                    this.omega = (int)((double)(this.omegain / 16) * this.getPowerLossFraction(this.omegain));
                    if (this.torquein <= 0x3FFFFFF) {
                        this.torque = this.torquein * 16;
                        break;
                    }
                    this.torque = 0x3FFFFFFF;
                    world.func_72869_a("crit", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), -0.5 + (double)rand.nextFloat(), (double)rand.nextFloat(), -0.5 + (double)rand.nextFloat());
                    world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 0.1f, 1.0f);
                    break;
                }
                case CVT: {
                    int ratio = this.getCVTRatio();
                    if (this.hasLubricant()) {
                        boolean speed = true;
                        if (ratio > 0) {
                            if (this.omegain <= 0x3FFFFFFF / ratio) {
                                this.omega = this.omegain * ratio;
                            } else {
                                this.omega = 0x3FFFFFFF;
                                world.func_72869_a("crit", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), -0.5 + (double)rand.nextFloat(), (double)rand.nextFloat(), -0.5 + (double)rand.nextFloat());
                                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 0.1f, 1.0f);
                            }
                            this.torque = this.torquein / ratio;
                            break;
                        }
                        if (this.torquein <= 0x3FFFFFFF / -ratio) {
                            this.torque = this.torquein * -ratio;
                        } else {
                            this.torque = 0x3FFFFFFF;
                            world.func_72869_a("crit", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), -0.5 + (double)rand.nextFloat(), (double)rand.nextFloat(), -0.5 + (double)rand.nextFloat());
                            world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 0.1f, 1.0f);
                        }
                        this.omega = this.omegain / -ratio;
                        break;
                    }
                    this.torque = 0;
                    this.omega = 0;
                    break;
                }
                case COIL: {
                    break;
                }
                case HIGH: {
                    if (this.hasLubricant()) {
                        if (this.torquemode) {
                            if (this.torquein <= 0x3FFFFF) {
                                this.torque = this.torquein * 256;
                            } else {
                                this.torque = 0x3FFFFFFF;
                                world.func_72869_a("crit", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), -0.5 + (double)rand.nextFloat(), (double)rand.nextFloat(), -0.5 + (double)rand.nextFloat());
                                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 0.1f, 1.0f);
                            }
                            this.omega = this.omegain / 256;
                        } else {
                            this.torque = this.torquein / 256;
                            if (this.omegain <= 0x3FFFFF) {
                                this.omega = this.omegain * 256;
                            } else {
                                this.omega = 0x3FFFFFFF;
                                world.func_72869_a("crit", (double)((float)x + rand.nextFloat()), (double)((float)y + rand.nextFloat()), (double)((float)z + rand.nextFloat()), -0.5 + (double)rand.nextFloat(), (double)rand.nextFloat(), -0.5 + (double)rand.nextFloat());
                                world.func_72908_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, "mob.blaze.hit", 0.1f, 1.0f);
                            }
                        }
                        if (this.omega <= 0 || (world.func_82737_E() & 4L) != 4L) break;
                        this.lubricant.removeLiquid((int)((double)DifficultyEffects.LUBEUSAGE.getChance() * ReikaMathLibrary.logbase((long)Math.max(this.omega, this.torque), (int)2)));
                        break;
                    }
                    this.torque = 0;
                    this.omega = 0;
                }
            }
        }
    }

    @Override
    protected void writeSyncTag(NBTTagCompound NBT) {
        super.writeSyncTag(NBT);
        NBT.func_74768_a("ratio", this.ratio);
        NBT.func_74772_a("e", this.energy);
        NBT.func_74768_a("relo", this.releaseOmega);
        NBT.func_74768_a("relt", this.releaseTorque);
        NBT.func_74757_a("redstone", this.isRedstoneControlled);
        NBT.func_74768_a("cvton", this.getCVTState(true).ordinal());
        NBT.func_74768_a("cvtoff", this.getCVTState(false).ordinal());
        NBT.func_74757_a("bedrock", this.isBedrockCoil);
        NBT.func_74757_a("creative", this.isCreative);
        NBT.func_74757_a("trq", this.torquemode);
        NBT.func_74757_a("t_enable", this.enabled);
        this.lubricant.writeToNBT(NBT);
    }

    @Override
    protected void readSyncTag(NBTTagCompound NBT) {
        super.readSyncTag(NBT);
        this.ratio = NBT.func_74762_e("ratio");
        this.energy = NBT.func_74763_f("e");
        this.releaseOmega = NBT.func_74762_e("relo");
        this.releaseTorque = NBT.func_74762_e("relt");
        this.isRedstoneControlled = NBT.func_74767_n("redstone");
        this.cvtState[0] = CVTState.list[NBT.func_74762_e("cvtoff")];
        this.cvtState[1] = CVTState.list[NBT.func_74762_e("cvton")];
        this.isBedrockCoil = NBT.func_74767_n("bedrock");
        this.isCreative = NBT.func_74767_n("creative");
        this.torquemode = NBT.func_74767_n("trq");
        if (NBT.func_74764_b("t_enable")) {
            this.enabled = NBT.func_74767_n("t_enable");
        }
        this.lubricant.readFromNBT(NBT);
    }

    @Override
    public void func_145841_b(NBTTagCompound NBT) {
        super.func_145841_b(NBT);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.belts.length; ++i) {
            if (this.belts[i] == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            this.belts[i].func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        NBT.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    @Override
    public void func_145839_a(NBTTagCompound NBT) {
        super.func_145839_a(NBT);
        NBTTagList nbttaglist = NBT.func_150295_c("Items", ReikaNBTHelper.NBTTypes.COMPOUND.ID);
        this.belts = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.belts.length) continue;
            this.belts[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound);
        }
    }

    public int func_70302_i_() {
        return this.belts.length;
    }

    public ItemStack func_70301_a(int var1) {
        return this.belts[var1];
    }

    public ItemStack func_70298_a(int var1, int var2) {
        return ReikaInventoryHelper.decrStackSize((IInventory)this, (int)var1, (int)var2);
    }

    public ItemStack func_70304_b(int var1) {
        return ReikaInventoryHelper.getStackInSlotOnClosing((IInventory)this, (int)var1);
    }

    public void func_70299_a(int var1, ItemStack var2) {
        this.belts[var1] = var2;
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return this.getGearType() == GearType.CVT && ReikaItemHelper.matchStacks((ItemStack)itemstack, (ItemStack)ItemStacks.belt);
    }

    public final String func_145825_b() {
        return this.getMultiValuedName();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public final boolean func_145818_k_() {
        return true;
    }

    public final void func_70296_d() {
        this.field_145847_g = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
        if (this.func_145838_q() != Blocks.field_150350_a) {
            this.field_145850_b.func_147453_f(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
        }
    }

    @Override
    public boolean hasModelTransparency() {
        return false;
    }

    @Override
    protected void animateWithTick(World world, int x, int y, int z) {
        if (!this.isInWorld()) {
            this.phi = 0.0f;
            return;
        }
        this.phi = (float)((double)this.phi + ReikaMathLibrary.doubpow((double)ReikaMathLibrary.logbase((long)(this.omega + 1), (int)2), (double)1.05));
    }

    @Override
    public MachineRegistry getMachine() {
        return MachineRegistry.ADVANCEDGEARS;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public int getRedstoneOverride() {
        if (this.getGearType().storesEnergy()) {
            int level = (int)(15L * (this.energy + this.power) / 20L / this.getMaxStorageCapacity());
            return level;
        }
        return 0;
    }

    @Override
    public void onEMP() {
    }

    public int[] func_94128_d(int var1) {
        if (this instanceof InertIInv) {
            return new int[0];
        }
        return ReikaInventoryHelper.getWholeInventoryForISided((ISidedInventory)this);
    }

    public boolean func_102007_a(int i, ItemStack is, int side) {
        if (this instanceof InertIInv) {
            return false;
        }
        return this.func_94041_b(i, is);
    }

    public final String getInvName() {
        return this.getMultiValuedName();
    }

    public long getEnergy() {
        return this.energy;
    }

    public void setEnergyFromNBT(NBTTagCompound NBT) {
        this.energy = NBT.func_74763_f("energy");
    }

    @Override
    public long getMaxPower() {
        if (this.getGearType() != GearType.COIL) {
            return 0L;
        }
        return this.power > 0L ? (long)(this.releaseOmega * this.releaseTorque) : 0L;
    }

    @Override
    public long getCurrentPower() {
        return this.power;
    }

    @Override
    public PowerSourceList getPowerSources(PowerSourceTracker io, ShaftMerger caller) {
        if (this.getGearType() == GearType.COIL) {
            return new PowerSourceList().addSource(this);
        }
        return super.getPowerSources(io, caller);
    }

    public void incrementCVTState(boolean on) {
        int i = on ? 1 : 0;
        this.cvtState[i] = this.getCVTState(on).next();
        while (!this.getCVTState(on).isValid(this)) {
            this.cvtState[i] = this.getCVTState(on).next();
        }
    }

    private CVTState getCVTState(boolean on) {
        int i = on ? 1 : 0;
        return this.cvtState[i] != null ? this.cvtState[i] : CVTState.S1;
    }

    public String getCVTString(boolean on) {
        return this.getCVTState(on).toString();
    }

    public final boolean hasInventory() {
        return this.getGearType().hasInventory();
    }

    public final boolean hasTank() {
        return this.getGearType().isLubricated();
    }

    public boolean isCreative() {
        return this.isCreative;
    }

    @Override
    public int getEmittingX() {
        return this.field_145851_c + this.write.offsetX;
    }

    @Override
    public int getEmittingY() {
        return this.field_145848_d + this.write.offsetY;
    }

    @Override
    public int getEmittingZ() {
        return this.field_145849_e + this.write.offsetZ;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.getGearType().consumesLubricant() ? FluidRegistry.getFluid((String)"rc lubricant").equals(fluid) : false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] fluidTankInfoArray;
        if (this.getGearType().consumesLubricant()) {
            FluidTankInfo[] fluidTankInfoArray2 = new FluidTankInfo[1];
            fluidTankInfoArray = fluidTankInfoArray2;
            fluidTankInfoArray2[0] = this.lubricant.getInfo();
        } else {
            fluidTankInfoArray = null;
        }
        return fluidTankInfoArray;
    }

    @Override
    public boolean canConnectToPipe(MachineRegistry m) {
        return this.getGearType().consumesLubricant() ? m == MachineRegistry.HOSE : false;
    }

    @Override
    public boolean canConnectToPipeOnSide(MachineRegistry p, ForgeDirection side) {
        return this.getGearType().consumesLubricant() ? p == MachineRegistry.HOSE : false;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        return this.canFill(from, resource.getFluid()) ? this.lubricant.fill(resource, doFill) : 0;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    @Override
    public TileEntityPiping.Flow getFlowForSide(ForgeDirection side) {
        return this.getGearType().isLubricated() ? TileEntityPiping.Flow.INPUT : TileEntityPiping.Flow.NONE;
    }

    public void setLubricantFromNBT(NBTTagCompound NBT) {
        this.lubricant.setContents(NBT.func_74762_e("lube"), FluidRegistry.getFluid((String)"rc lubricant"));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enable) {
        this.enabled = enable;
        this.syncAllData(false);
    }

    @Override
    public int getItemMetadata() {
        return this.getGearType().ordinal();
    }

    private static enum CVTState {
        S1(1),
        S2(2),
        S4(4),
        S8(8),
        S16(16),
        S32(32),
        T1(-1),
        T2(-2),
        T4(-4),
        T8(-8),
        T16(-16),
        T32(-32);

        public final int gearRatio;
        public static final CVTState[] list;

        private CVTState(int ratio) {
            this.gearRatio = ratio;
        }

        public CVTState next() {
            if (this.ordinal() == list.length - 1) {
                return list[0];
            }
            return list[this.ordinal() + 1];
        }

        public boolean isValid(TileEntityAdvancedGear te) {
            int abs = Math.abs(this.gearRatio);
            int max = Math.abs(te.getMaxRatio());
            return max >= abs;
        }

        public String toString() {
            return Math.abs(this.gearRatio) + "x " + (this.gearRatio > 0 ? "Speed" : "Torque");
        }

        static {
            list = CVTState.values();
        }
    }

    public static enum GearType {
        WORM,
        CVT,
        COIL,
        HIGH;

        public static final GearType[] list;

        public boolean isLubricated() {
            return this == CVT || this.consumesLubricant();
        }

        public boolean consumesLubricant() {
            return this == HIGH;
        }

        public boolean hasLosses() {
            return this == WORM;
        }

        public boolean storesEnergy() {
            return this == COIL;
        }

        public boolean hasInventory() {
            return this == CVT;
        }

        static {
            list = GearType.values();
        }
    }
}

